/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss;

import com.wcohen.ss.BagOfSourcedTokens;
import com.wcohen.ss.JaroWinkler;
import com.wcohen.ss.PrintfFormat;
import com.wcohen.ss.SourcedTFIDF;
import com.wcohen.ss.api.SourcedStringWrapper;
import com.wcohen.ss.api.SourcedToken;
import com.wcohen.ss.api.SourcedTokenizer;
import com.wcohen.ss.api.StringDistance;
import com.wcohen.ss.api.StringWrapper;
import com.wcohen.ss.api.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class SourcedSoftTFIDF
extends SourcedTFIDF {
    private StringDistance tokenDistance;
    private double tokenMatchThreshold;
    private static final StringDistance DEFAULT_TOKEN_DISTANCE = new JaroWinkler();

    public SourcedSoftTFIDF(SourcedTokenizer tokenizer, StringDistance tokenDistance, double tokenMatchThreshold) {
        super(tokenizer);
        this.tokenDistance = tokenDistance;
        this.tokenMatchThreshold = tokenMatchThreshold;
    }

    public SourcedSoftTFIDF(StringDistance tokenDistance, double tokenMatchThreshold) {
        this.tokenDistance = tokenDistance;
        this.tokenMatchThreshold = tokenMatchThreshold;
    }

    public SourcedSoftTFIDF(StringDistance tokenDistance) {
        this(tokenDistance, 0.9);
    }

    public SourcedSoftTFIDF() {
        this(new JaroWinkler(), 0.9);
    }

    public void setTokenMatchThreshold(double d) {
        this.tokenMatchThreshold = d;
    }

    public void setTokenMatchThreshold(Double d) {
        this.tokenMatchThreshold = d;
    }

    public double getTokenMatchThreshold() {
        return this.tokenMatchThreshold;
    }

    public double score(StringWrapper s0, StringWrapper t0) {
        SourcedStringWrapper s2 = (SourcedStringWrapper)s0;
        SourcedStringWrapper t = (SourcedStringWrapper)t0;
        this.checkTrainingHasHappened(s2, t);
        SourcedTFIDF.UnitVector sBag = this.asUnitVector(s2);
        SourcedTFIDF.UnitVector tBag = this.asUnitVector(t);
        ArrayList<Similarity> similarities = new ArrayList<Similarity>(sBag.size());
        double sim = 0.0;
        int i = 0;
        Iterator ti = sBag.tokenIterator();
        while (ti.hasNext()) {
            Token tok = (Token)ti.next();
            int j = 0;
            Iterator tj = tBag.tokenIterator();
            while (tj.hasNext()) {
                Token tokJ = (Token)tj.next();
                double distItoJ = this.tokenDistance.score(tok.getValue(), tokJ.getValue());
                if (distItoJ >= this.tokenMatchThreshold) {
                    similarities.add(new Similarity(i, j, distItoJ * sBag.getWeight(tok) * tBag.getWeight(tokJ)));
                }
                ++j;
            }
            ++i;
        }
        Collections.sort(similarities, Collections.reverseOrder());
        boolean[] sUsed = new boolean[sBag.size()];
        boolean[] tUsed = new boolean[tBag.size()];
        for (int k = 0; k < similarities.size(); ++k) {
            Similarity similarity = (Similarity)similarities.get(k);
            if (sUsed[similarity.r1] || tUsed[similarity.r2]) continue;
            sim += similarity.sim;
            sUsed[similarity.r1] = true;
            tUsed[similarity.r2] = true;
        }
        return sim;
    }

    public String explainScore(StringWrapper s2, StringWrapper t) {
        BagOfSourcedTokens sBag = (BagOfSourcedTokens)s2;
        BagOfSourcedTokens tBag = (BagOfSourcedTokens)t;
        StringBuilder buf = new StringBuilder("");
        PrintfFormat fmt = new PrintfFormat("%.3f");
        buf.append("Common tokens: ");
        Iterator i = sBag.tokenIterator();
        while (i.hasNext()) {
            Token sTok = (Token)i.next();
            SourcedToken tTok = null;
            tTok = tBag.getEquivalentToken(sTok);
            if (tTok != null) {
                buf.append(" " + sTok.getValue() + ": ");
                buf.append(fmt.sprintf(sBag.getWeight(sTok)));
                buf.append("*");
                buf.append(fmt.sprintf(tBag.getWeight(tTok)));
                continue;
            }
            double matchScore = this.tokenMatchThreshold;
            Token matchTok = null;
            Iterator j = tBag.tokenIterator();
            while (j.hasNext()) {
                Token tokJ = (Token)j.next();
                double distItoJ = this.tokenDistance.score(sTok.getValue(), tokJ.getValue());
                if (!(distItoJ >= matchScore)) continue;
                matchTok = tokJ;
                matchScore = distItoJ;
            }
            if (matchTok == null) continue;
            buf.append(" '" + sTok.getValue() + "'~='" + matchTok.getValue() + "': ");
            buf.append(fmt.sprintf(sBag.getWeight(sTok)));
            buf.append("*");
            buf.append(fmt.sprintf(tBag.getWeight(matchTok)));
            buf.append("*");
            buf.append(fmt.sprintf(matchScore));
        }
        buf.append("\nscore = " + this.score(s2, t));
        return buf.toString();
    }

    public String toString() {
        return "[SoftTFIDF thresh=" + this.tokenMatchThreshold + ";" + this.tokenDistance + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Similarity
    implements Comparable<Similarity> {
        int r1;
        int r2;
        double sim;

        public Similarity(int r1, int r2, double sim) {
            this.r1 = r1;
            this.r2 = r2;
            this.sim = sim;
        }

        @Override
        public int compareTo(Similarity o) {
            if (this.sim > o.sim) {
                return 1;
            }
            if (this.sim < o.sim) {
                return -1;
            }
            return 0;
        }
    }
}

