/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss;

import com.wcohen.ss.AbstractStringDistance;
import com.wcohen.ss.CharMatchScore;
import com.wcohen.ss.MemoMatrix;
import com.wcohen.ss.api.StringWrapper;

public class SmithWaterman
extends AbstractStringDistance {
    private CharMatchScore charMatchScore;
    private double gapCost;

    public SmithWaterman() {
        this(CharMatchScore.DIST_21, 1.0);
    }

    public SmithWaterman(CharMatchScore charMatchScore, double gapCost) {
        this.charMatchScore = charMatchScore;
        this.gapCost = gapCost;
    }

    public double score(StringWrapper s2, StringWrapper t) {
        MyMatrix mat = new MyMatrix(s2, t);
        return this.score(s2, t, mat);
    }

    private double score(StringWrapper s2, StringWrapper t, MyMatrix mat) {
        double best = -1.7976931348623157E308;
        for (int i = 0; i <= s2.length(); ++i) {
            for (int j = 0; j <= t.length(); ++j) {
                best = Math.max(best, mat.get(i, j));
            }
        }
        return best;
    }

    public String explainScore(StringWrapper s2, StringWrapper t) {
        MyMatrix mat = new MyMatrix(s2, t);
        double d = this.score(s2, t, mat);
        return mat.toString() + "\nScore = " + d;
    }

    public String toString() {
        return "[SmithWaterman]";
    }

    public static void main(String[] argv) {
        SmithWaterman.doMain(new SmithWaterman(), argv);
    }

    private class MyMatrix
    extends MemoMatrix {
        public MyMatrix(StringWrapper s2, StringWrapper t) {
            super(s2, t);
        }

        public double compute(int i, int j) {
            if (i == 0) {
                return 0.0;
            }
            if (j == 0) {
                return 0.0;
            }
            return MyMatrix.max4(0.0, this.get(i - 1, j - 1) + SmithWaterman.this.charMatchScore.matchScore(this.sAt(i), this.tAt(j)), this.get(i - 1, j) - SmithWaterman.this.gapCost, this.get(i, j - 1) - SmithWaterman.this.gapCost);
        }
    }
}

