/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss;

import com.wcohen.ss.AbstractStatisticalTokenDistance;
import com.wcohen.ss.BagOfTokens;
import com.wcohen.ss.api.StringWrapper;
import com.wcohen.ss.api.Token;
import com.wcohen.ss.api.Tokenizer;
import java.util.Iterator;

public class Mixture
extends AbstractStatisticalTokenDistance {
    private double minChange = 0.01;
    private double maxIterate = 20.0;

    public Mixture(Tokenizer tokenizer) {
        super(tokenizer);
    }

    public Mixture() {
    }

    public double score(StringWrapper s2, StringWrapper t) {
        BagOfTokens sBag = this.asBagOfTokens(s2);
        BagOfTokens tBag = this.asBagOfTokens(t);
        double lambda = 0.5;
        boolean iterations = false;
        while (true) {
            double newLamba = 0.0;
            Iterator i = sBag.tokenIterator();
            while (i.hasNext()) {
                Token tok = (Token)i.next();
                double sWeight = sBag.getWeight(tok);
                double tWeight = tBag.getWeight(tok);
                double probTokGivenT = tWeight / tBag.getTotalWeight();
                double probTokGivenCorpus = (double)this.getDocumentFrequency(tok) / (double)this.totalTokenCount;
                double probDrawnFromT = lambda * probTokGivenT;
                double probDrawnFromCorpus = (1.0 - lambda) * probTokGivenCorpus;
                double normalizingConstant = probTokGivenT + probTokGivenCorpus;
                probDrawnFromCorpus /= normalizingConstant;
                newLamba += (probDrawnFromT /= normalizingConstant) * sWeight;
            }
            double change = (newLamba /= sBag.getTotalWeight()) - lambda;
            if ((double)iterations > this.maxIterate || change >= -this.minChange && change <= this.minChange) break;
            lambda = newLamba;
        }
        return lambda;
    }

    public String explainScore(StringWrapper s2, StringWrapper t) {
        return "can't explain";
    }

    public String toString() {
        return "[Mixture]";
    }

    public static void main(String[] argv) {
        Mixture.doMain(new Mixture(), argv);
    }
}

