/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss;

import com.wcohen.ss.AbstractStringDistance;
import com.wcohen.ss.BagOfTokens;
import com.wcohen.ss.api.StringWrapper;
import com.wcohen.ss.api.Token;
import com.wcohen.ss.api.Tokenizer;
import com.wcohen.ss.tokens.SimpleTokenizer;
import java.util.Iterator;

public class Jaccard
extends AbstractStringDistance {
    private Tokenizer tokenizer;

    public Jaccard(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    public Jaccard() {
        this(SimpleTokenizer.DEFAULT_TOKENIZER);
    }

    public double score(StringWrapper s2, StringWrapper t) {
        BagOfTokens sBag = this.asBagOfTokens(s2);
        BagOfTokens tBag = this.asBagOfTokens(t);
        double numCommon = 0.0;
        Iterator i = sBag.tokenIterator();
        while (i.hasNext()) {
            Token tok = (Token)i.next();
            if (!tBag.contains(tok)) continue;
            numCommon += 1.0;
        }
        return numCommon / ((double)(sBag.size() + tBag.size()) - numCommon);
    }

    public StringWrapper prepare(String s2) {
        return new BagOfTokens(s2, this.tokenizer.tokenize(s2));
    }

    private BagOfTokens asBagOfTokens(StringWrapper w) {
        if (w instanceof BagOfTokens) {
            return (BagOfTokens)w;
        }
        return new BagOfTokens(w.unwrap(), this.tokenizer.tokenize(w.unwrap()));
    }

    public String explainScore(StringWrapper s2, StringWrapper t) {
        Token tok;
        BagOfTokens sBag = (BagOfTokens)s2;
        BagOfTokens tBag = (BagOfTokens)t;
        StringBuffer buf = new StringBuffer("");
        buf.append("S: ");
        Iterator i = sBag.tokenIterator();
        while (i.hasNext()) {
            tok = (Token)i.next();
            buf.append(" " + tok.getValue());
            if (!tBag.contains(tok)) continue;
            buf.append("*");
        }
        buf.append("\nT: ");
        i = tBag.tokenIterator();
        while (i.hasNext()) {
            tok = (Token)i.next();
            buf.append(" " + tok.getValue());
            if (!sBag.contains(tok)) continue;
            buf.append("*");
        }
        buf.append("\nscore = " + this.score(s2, t));
        return buf.toString();
    }

    public String toString() {
        return "[Jaccard]";
    }

    public static void main(String[] argv) {
        Jaccard.doMain(new Jaccard(), argv);
    }
}

