/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss;

import com.wcohen.ss.api.StringDistance;
import com.wcohen.ss.api.StringDistanceLearner;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class DistanceLearnerFactory {
    public static StringDistanceLearner build(String classNames) {
        return DistanceLearnerFactory.build(0, DistanceLearnerFactory.split(classNames));
    }

    public static StringDistance[] buildArray(String classNames) {
        String[] classNamesArray = DistanceLearnerFactory.split(classNames);
        StringDistance[] learners = new StringDistance[classNamesArray.length];
        for (int i = 0; i < classNamesArray.length; ++i) {
            learners[i] = DistanceLearnerFactory.build(classNamesArray[i]).getDistance();
        }
        return learners;
    }

    public static StringDistanceLearner build(String[] classNames) {
        return DistanceLearnerFactory.build(0, classNames);
    }

    private static StringDistanceLearner build(int lo, String[] classNames) {
        try {
            Class c = DistanceLearnerFactory.findClassFor(classNames[lo]);
            StringDistanceLearner result = null;
            if (lo == classNames.length - 1) {
                result = (StringDistanceLearner)c.newInstance();
            } else {
                StringDistanceLearner innerDist = DistanceLearnerFactory.build(lo + 1, classNames);
                Constructor constr = c.getConstructor(StringDistance.class);
                result = (StringDistanceLearner)constr.newInstance(innerDist);
            }
            String p = DistanceLearnerFactory.findParamFor(classNames[lo]);
            if (p != null) {
                String v = DistanceLearnerFactory.findParamValueFor(classNames[lo]);
                Double d = new Double(Double.parseDouble(v));
                String setMethodName = "set" + p.substring(0, 1).toUpperCase() + p.substring(1);
                Method m3 = result.getClass().getMethod(setMethodName, Double.class);
                m3.invoke((Object)result, d);
            }
            return result;
        }
        catch (Exception e) {
            StringBuffer buf = new StringBuffer(classNames[0]);
            if (lo == 0) {
                buf.append("<<<");
            }
            for (int i = 1; i < classNames.length; ++i) {
                buf.append("/" + classNames[i]);
                if (lo != i) continue;
                buf.append("<<<");
            }
            throw new IllegalStateException("error building '" + buf + "': " + e);
        }
    }

    private static String findParamFor(String s2) {
        int endClassIndex = s2.indexOf(91);
        if (endClassIndex < 0) {
            return null;
        }
        int endParamIndex = s2.indexOf(61, endClassIndex + 1);
        if (endParamIndex < 0) {
            throw new IllegalStateException("illegal class description '" + s2 + "'");
        }
        return s2.substring(endClassIndex + 1, endParamIndex);
    }

    private static String findParamValueFor(String s2) {
        int endParamIndex = s2.indexOf(61);
        int endValueIndex = s2.indexOf(93, endParamIndex);
        if (endValueIndex < 0) {
            throw new IllegalStateException("illegal class description '" + s2 + "'");
        }
        return s2.substring(endParamIndex + 1, endValueIndex);
    }

    private static Class findClassFor(String s2) throws ClassNotFoundException {
        int endClassIndex = s2.indexOf(91);
        if (endClassIndex >= 0) {
            s2 = s2.substring(0, endClassIndex);
        }
        try {
            return Class.forName(s2);
        }
        catch (ClassNotFoundException e) {
            return Class.forName("com.wcohen.ss." + s2);
        }
    }

    private static String[] split(String s2) {
        ArrayList<String> list = new ArrayList<String>();
        int begin = 0;
        int end = s2.indexOf(47);
        while (end >= 0) {
            list.add(s2.substring(begin, end));
            begin = end + 1;
            end = s2.indexOf(47, end + 1);
        }
        list.add(s2.substring(begin));
        return list.toArray(new String[list.size()]);
    }

    public static void main(String[] args) {
        try {
            if (args[0].indexOf(47) > 0) {
                System.out.println(DistanceLearnerFactory.build(args[0]));
            } else {
                System.out.println(DistanceLearnerFactory.build(args));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

