/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss;

import com.wcohen.ss.BasicDistanceInstanceIterator;
import com.wcohen.ss.BasicStringWrapper;
import com.wcohen.ss.BasicStringWrapperIterator;
import com.wcohen.ss.Jaccard;
import com.wcohen.ss.JaroWinkler;
import com.wcohen.ss.JaroWinklerTFIDF;
import com.wcohen.ss.MultiStringWrapper;
import com.wcohen.ss.ScaledLevenstein;
import com.wcohen.ss.TFIDF;
import com.wcohen.ss.api.DistanceInstance;
import com.wcohen.ss.api.DistanceInstanceIterator;
import com.wcohen.ss.api.StringDistance;
import com.wcohen.ss.api.StringDistanceLearner;
import com.wcohen.ss.api.StringWrapper;
import com.wcohen.ss.api.StringWrapperIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class CombinedStringDistanceLearner
implements StringDistanceLearner {
    protected StringDistanceLearner[] innerLearners;
    protected String delim;

    public CombinedStringDistanceLearner() {
        this.innerLearners = new StringDistanceLearner[]{new JaroWinkler(), new ScaledLevenstein(), new Jaccard(), new TFIDF(), new JaroWinklerTFIDF()};
        this.delim = null;
    }

    public CombinedStringDistanceLearner(StringDistanceLearner[] innerLearners, String delim) {
        this.innerLearners = innerLearners;
        this.delim = delim;
    }

    protected abstract void comboSetStringWrapperPool(Iterator var1);

    protected abstract void comboSetDistanceInstancePool(Iterator var1);

    protected abstract boolean comboHasNextQuery();

    protected abstract DistanceInstance comboNextQuery();

    protected abstract void comboAddExample(DistanceInstance var1);

    public abstract StringDistance getDistance();

    public void setStringWrapperPool(StringWrapperIterator it) {
        List buffer = this.asMultiStringWrapperList(it);
        if (buffer.size() == 0) {
            throw new IllegalStateException("need some unlabeled strings");
        }
        MultiStringWrapper prototype = (MultiStringWrapper)buffer.get(0);
        for (int i = 0; i < prototype.size(); ++i) {
            int j = prototype.getDistanceLearnerIndex(i);
            this.innerLearners[j].setStringWrapperPool(new JthStringWrapperValueIterator(j, buffer.iterator()));
        }
        this.comboSetStringWrapperPool(buffer.iterator());
    }

    public void setDistanceInstancePool(DistanceInstanceIterator it) {
        List buffer = this.asMultiDistanceInstanceList(it);
        if (buffer.size() == 0) {
            return;
        }
        MyMultiDistanceInstance instance = (MyMultiDistanceInstance)buffer.get(0);
        MultiStringWrapper prototype = this.asMultiStringWrapper(instance.getA());
        for (int i = 0; i < prototype.size(); ++i) {
            int j = prototype.getDistanceLearnerIndex(i);
            this.innerLearners[j].setDistanceInstancePool(new JthDistanceInstanceIterator(j, buffer.iterator()));
        }
        this.comboSetDistanceInstancePool(buffer.iterator());
    }

    public boolean hasNextQuery() {
        for (int i = 0; i < this.innerLearners.length; ++i) {
            if (!this.innerLearners[i].hasNextQuery()) continue;
            return true;
        }
        return this.comboHasNextQuery();
    }

    public DistanceInstance nextQuery() {
        int i;
        ArrayList<Integer> indices = new ArrayList<Integer>(this.innerLearners.length + 1);
        for (i = 0; i < indices.size(); ++i) {
            indices.set(i, new Integer(i));
        }
        Collections.shuffle(indices);
        for (i = 0; i < indices.size(); ++i) {
            int k = (Integer)indices.get(i);
            if (k == this.innerLearners.length && this.comboHasNextQuery()) {
                return this.comboNextQuery();
            }
            if (!this.innerLearners[k].hasNextQuery()) continue;
            return this.innerLearners[k].nextQuery();
        }
        throw new IllegalStateException("someone seems to have forgotten they want a query");
    }

    public void addExample(DistanceInstance answeredQuery) {
        MyMultiDistanceInstance di = this.asMultiDistanceInstance(answeredQuery);
        for (int i = 0; i < this.innerLearners.length; ++i) {
            this.innerLearners[i].addExample(di.get(i));
        }
        this.comboAddExample(di);
    }

    public StringWrapperIterator prepare(StringWrapperIterator it) {
        List multiWrappers = this.asMultiStringWrapperList(it);
        if (multiWrappers.size() == 0) {
            return new BasicStringWrapperIterator(Collections.EMPTY_SET.iterator());
        }
        MultiStringWrapper prototype = (MultiStringWrapper)multiWrappers.get(0);
        for (int i = 0; i < prototype.size(); ++i) {
            int j = prototype.getDistanceLearnerIndex(i);
            StringDistanceLearner learner = this.innerLearners[j];
            StringWrapperIterator prepped = learner.prepare(new JthStringWrapperValueIterator(j, multiWrappers.iterator()));
            for (int k = 0; k < multiWrappers.size(); ++k) {
                MultiStringWrapper msw = (MultiStringWrapper)multiWrappers.get(k);
                StringWrapper w = prepped.nextStringWrapper();
                msw.set(i, w);
            }
        }
        return new BasicStringWrapperIterator(multiWrappers.iterator());
    }

    public DistanceInstanceIterator prepare(DistanceInstanceIterator it) {
        List multiDistances = this.asMultiDistanceInstanceList(it);
        return new BasicDistanceInstanceIterator(multiDistances.iterator());
    }

    protected List asMultiStringWrapperList(StringWrapperIterator i) {
        ArrayList<MultiStringWrapper> buffer = new ArrayList<MultiStringWrapper>();
        while (i.hasNext()) {
            StringWrapper w = i.nextStringWrapper();
            MultiStringWrapper mw = this.asMultiStringWrapper(w);
            buffer.add(mw);
        }
        return buffer;
    }

    protected MultiStringWrapper asMultiStringWrapper(StringWrapper w) {
        if (w instanceof MultiStringWrapper) {
            return (MultiStringWrapper)w;
        }
        MultiStringWrapper mw = new MultiStringWrapper(w.unwrap(), this.innerLearners.length, this.delim);
        for (int i = 0; i < mw.size(); ++i) {
            mw.set(i, this.prepareForLearner(mw.get(i), this.innerLearners[mw.getDistanceLearnerIndex(i)]));
        }
        return mw;
    }

    private StringWrapper prepareForLearner(StringWrapper w, StringDistanceLearner learner) {
        BasicStringWrapperIterator it = new BasicStringWrapperIterator(Collections.singleton(w).iterator());
        return learner.prepare(it).nextStringWrapper();
    }

    protected List asMultiDistanceInstanceList(DistanceInstanceIterator i) {
        ArrayList<MyMultiDistanceInstance> buffer = new ArrayList<MyMultiDistanceInstance>();
        while (i.hasNext()) {
            DistanceInstance di = i.nextDistanceInstance();
            buffer.add(this.asMultiDistanceInstance(i.nextDistanceInstance()));
        }
        return buffer;
    }

    protected MyMultiDistanceInstance asMultiDistanceInstance(DistanceInstance di) {
        if (di instanceof MyMultiDistanceInstance) {
            return (MyMultiDistanceInstance)di;
        }
        return new MyMultiDistanceInstance(di.getA(), di.getB(), di.isCorrect(), di.getDistance());
    }

    protected StringDistance[] getInnerDistances() {
        StringDistance[] innerDistances = new StringDistance[this.innerLearners.length];
        for (int j = 0; j < this.innerLearners.length; ++j) {
            innerDistances[j] = this.innerLearners[j].getDistance();
        }
        return innerDistances;
    }

    protected abstract class CombinedStringDistance
    implements StringDistance {
        protected StringDistance[] innerDistances;
        protected MultiStringWrapper prototype;

        public CombinedStringDistance(StringDistance[] innerDistances, MultiStringWrapper prototype) {
            this.innerDistances = innerDistances;
            this.prototype = prototype;
        }

        public final double score(String s2, String t) {
            return this.score(this.prepare(s2), this.prepare(t));
        }

        public final String explainScore(String s2, String t) {
            return this.explainScore(this.prepare(s2), this.prepare(t));
        }

        public final StringWrapper prepare(String s2) {
            MultiStringWrapper ms = CombinedStringDistanceLearner.this.asMultiStringWrapper(new BasicStringWrapper(s2));
            ms.prepare(this.innerDistances);
            return ms;
        }

        public final double score(StringWrapper s2, StringWrapper t) {
            MultiStringWrapper ms = CombinedStringDistanceLearner.this.asMultiStringWrapper(s2);
            MultiStringWrapper mt = CombinedStringDistanceLearner.this.asMultiStringWrapper(t);
            ms.prepare(this.innerDistances);
            mt.prepare(this.innerDistances);
            if (ms.size() != mt.size() || ms.size() != this.prototype.size()) {
                throw new IllegalStateException("ms,mt=" + ms + "," + mt + " expected MultiStringWrapper's of size " + this.prototype.size());
            }
            return this.doScore(ms, mt);
        }

        public final String explainScore(StringWrapper s2, StringWrapper t) {
            StringBuffer buf = new StringBuffer();
            MultiStringWrapper ms = CombinedStringDistanceLearner.this.asMultiStringWrapper(s2);
            MultiStringWrapper mt = CombinedStringDistanceLearner.this.asMultiStringWrapper(t);
            if (ms.size() != mt.size() || ms.size() != this.prototype.size()) {
                throw new IllegalStateException("expected MultiStringWrapper's of size " + this.prototype.size());
            }
            for (int i = 0; i < ms.size(); ++i) {
                StringDistance d = this.innerDistances[ms.getDistanceLearnerIndex(i)];
                buf.append("score of " + d + " on '" + ms.get(i) + "' and '" + mt.get(i) + "' = " + d.score(ms.get(i), mt.get(i)) + "\n");
            }
            buf.append(this.explainCombination(ms, mt));
            return buf.toString();
        }

        protected abstract double doScore(MultiStringWrapper var1, MultiStringWrapper var2);

        protected abstract String explainCombination(MultiStringWrapper var1, MultiStringWrapper var2);

        protected String innerDistanceString() {
            StringBuffer buf = new StringBuffer("");
            for (int i = 0; i < this.innerDistances.length; ++i) {
                buf.append(" " + this.innerDistances[i]);
            }
            return buf.toString();
        }
    }

    protected class JthDistanceInstanceIterator
    implements DistanceInstanceIterator {
        private Iterator i;
        private int j;

        public JthDistanceInstanceIterator(int j, Iterator i) {
            this.j = j;
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public DistanceInstance nextDistanceInstance() {
            return (DistanceInstance)this.next();
        }

        public Object next() {
            return ((MyMultiDistanceInstance)this.i.next()).get(this.j);
        }

        public void remove() {
            throw new UnsupportedOperationException("can't remove");
        }
    }

    protected class MyMultiDistanceInstance
    extends MyDistanceInstance {
        MultiStringWrapper ma;
        MultiStringWrapper mb;

        public MyMultiDistanceInstance(StringWrapper a, StringWrapper b, boolean correct, double distance) {
            super(a, b, correct, distance);
            this.ma = CombinedStringDistanceLearner.this.asMultiStringWrapper(a);
            this.mb = CombinedStringDistanceLearner.this.asMultiStringWrapper(b);
        }

        public StringWrapper getA(int j) {
            return this.ma.get(j);
        }

        public StringWrapper getB(int j) {
            return this.mb.get(j);
        }

        public DistanceInstance get(int j) {
            return new MyDistanceInstance(this.ma.get(j), this.mb.get(j), this.correct, this.distance);
        }

        public String toString() {
            return "[" + this.ma + ";" + this.mb + "]";
        }
    }

    protected class MyDistanceInstance
    implements DistanceInstance {
        protected StringWrapper a;
        protected StringWrapper b;
        protected boolean correct;
        protected double distance;

        public MyDistanceInstance(StringWrapper a, StringWrapper b, boolean correct, double distance) {
            this.a = a;
            this.b = b;
            this.correct = correct;
            this.distance = distance;
        }

        public StringWrapper getA() {
            return this.a;
        }

        public StringWrapper getB() {
            return this.b;
        }

        public boolean isCorrect() {
            return this.correct;
        }

        public double getDistance() {
            return this.distance;
        }

        public void setDistance(double distance) {
            this.distance = distance;
        }
    }

    protected class JthStringWrapperValueIterator
    implements StringWrapperIterator {
        private Iterator i;
        private int j;

        public JthStringWrapperValueIterator(int j, Iterator i) {
            this.j = j;
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public Object next() {
            return ((MultiStringWrapper)this.i.next()).get(this.j);
        }

        public StringWrapper nextStringWrapper() {
            return (StringWrapper)this.next();
        }

        public void remove() {
            throw new UnsupportedOperationException("can't remove");
        }
    }
}

