/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss;

import com.wcohen.ss.BasicStringWrapper;
import com.wcohen.ss.api.SourcedStringWrapper;
import com.wcohen.ss.api.SourcedToken;
import com.wcohen.ss.api.Token;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

class BagOfSourcedTokens
extends BasicStringWrapper
implements SourcedStringWrapper {
    private Map weightMap = new TreeMap();
    private Set unsourcedTokens = new TreeSet();
    private double totalWeight = 0.0;
    private SourcedToken[] tokens;

    BagOfSourcedTokens(String s2, SourcedToken[] tokens) {
        super(s2);
        this.tokens = tokens;
        for (int i = 0; i < tokens.length; ++i) {
            this.weightMap.put(tokens[i], new Double(this.getWeight(tokens[i]) + 1.0));
            this.unsourcedTokens.add(tokens[i].getValue());
        }
        this.totalWeight = tokens.length;
    }

    public String getSource() {
        return this.tokens[0].getSource();
    }

    Iterator tokenIterator() {
        return this.weightMap.keySet().iterator();
    }

    SourcedToken getEquivalentToken(Token tok) {
        if (this.unsourcedTokens.contains(tok.getValue())) {
            for (int i = 0; i < this.tokens.length; ++i) {
                if (!this.tokens[i].getValue().equals(tok.getValue())) continue;
                return this.tokens[i];
            }
            System.out.println("This is a problem");
            return null;
        }
        return null;
    }

    double getWeight(Token tok) {
        Double f = (Double)this.weightMap.get(tok);
        return f == null ? 0.0 : f;
    }

    void setWeight(Token tok, double d) {
        Double oldWeight = (Double)this.weightMap.get(tok);
        this.totalWeight += oldWeight == null ? d : d - oldWeight;
        this.weightMap.put(tok, new Double(d));
    }

    int size() {
        return this.weightMap.keySet().size();
    }

    double getTotalWeight() {
        return this.totalWeight;
    }

    Token[] getTokens() {
        return this.tokens;
    }

    SourcedToken[] getSourcedTokens() {
        return this.tokens;
    }
}

