/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss;

import com.wcohen.ss.AbstractStatisticalTokenDistance;
import com.wcohen.ss.abbvGapsHmm.AbbreviationAlignmentContainer;
import com.wcohen.ss.abbvGapsHmm.AbbvGapsHMM;
import com.wcohen.ss.abbvGapsHmm.AlignmentPredictionModel;
import com.wcohen.ss.api.StringWrapper;
import java.io.IOException;

public class AbbreviationAlignment
extends AbstractStatisticalTokenDistance {
    private AlignmentPredictionModel _alignPredictor = null;
    private static String _trainingDir = "./train/";

    public static void main(String[] argv) {
        String[] newArgv = AbbreviationAlignment.init(argv);
        AbbreviationAlignment aligner = new AbbreviationAlignment();
        AbbreviationAlignment.doMain(aligner, newArgv);
    }

    public static String[] init(String[] argv) {
        if (argv.length < 2) {
            System.out.println("Usage: AlignmentPredictionModel short_form_string long_form_string [train_data_dir]\n\nshort_form_string long_form_string - Candidate abbreviation strings, for example, \"DNA\" \"Deoxyribonucleic acid\"\ntrain_data_dir - Optional. Directory containing a corpus file named 'abbvAlign_corpus.txt' for training the abbreviation HMM. Corpus format is one line per file.\n                 The model parameters will be saved in this directory under 'hmmModelParams.txt' so the HMM will only have to be trained once.\n                 Default = './train/'\n\nExample: java com.wcohen.ss.AbbreviationAlignment \"DNA\" \"Deoxyribonucleic acid\"\nExpected output:\nM        |M      |M|M   |\nD        |N      | |A   |\nDeoxyribo|nucleic| |acid|\n\nProbability = 3.674595157620664E-6");
            System.exit(1);
        }
        if (argv.length >= 3) {
            _trainingDir = argv[2];
        }
        String[] newArgv = new String[]{argv[0], argv[1]};
        return newArgv;
    }

    public AbbreviationAlignment() {
        this.loadPredictor();
        this.setTrainDir(_trainingDir);
    }

    public void setTrainDir(String trainDir) {
        _trainingDir = trainDir;
        this._alignPredictor.setTrainingDataDir(trainDir + "/");
        this._alignPredictor.setModelParamsFile(trainDir + "/hmmModelParams.txt");
        this._alignPredictor.trainIfNeeded();
    }

    protected AlignmentPredictionModel loadPredictor() {
        if (this._alignPredictor == null) {
            try {
                this._alignPredictor = new AlignmentPredictionModel();
            }
            catch (IOException e) {
                System.err.println("Unable to load AlignmentPredictionModel");
                e.printStackTrace();
                System.exit(1);
            }
        }
        return this._alignPredictor;
    }

    public double score(StringWrapper s2, StringWrapper t) {
        AbbreviationAlignmentContainer<AbbvGapsHMM.Emissions, AbbvGapsHMM.States> alignment = this._alignPredictor.predict(s2.unwrap(), t.unwrap());
        if (alignment != null) {
            return alignment.getProbability();
        }
        return 0.0;
    }

    public String explainScore(StringWrapper s2, StringWrapper t) {
        String explainStr = "";
        AbbreviationAlignmentContainer<AbbvGapsHMM.Emissions, AbbvGapsHMM.States> alignment = this._alignPredictor.predict(s2.unwrap(), t.unwrap());
        if (alignment != null) {
            explainStr = explainStr + alignment.toString() + "\n\n";
            explainStr = explainStr + "Probability = " + alignment.getProbability();
        } else {
            explainStr = explainStr + "No alignment found between: \"" + s2.unwrap() + "\", \"" + t.unwrap() + "\"";
        }
        return explainStr;
    }
}

