/*
 * Decompiled with CFR 0.152.
 */
package com.lahodiuk.ahocorasick;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;

public class AhoCorasickOptimized {
    private static final int INITIAL_STATE = 0;
    private static final int FAIL = -1;
    private char[] charToIntMapping;
    private final int absentCharInt;
    private int[][] goTo;
    private List<String>[] output;
    private int[] fail;

    public AhoCorasickOptimized(String ... patterns) {
        this(Arrays.asList(patterns));
    }

    public AhoCorasickOptimized(Collection<String> patterns) {
        this.initializeCharToIntMapping(patterns.stream());
        this.absentCharInt = this.charToIntMapping.length;
        int maxAmountOfStates = this.getMaxPossibleAmountOfStates(patterns.stream());
        this.initializeTransitionsTable(maxAmountOfStates);
        this.initializeOutputTable(maxAmountOfStates);
        this.initializeFailureTransitions(maxAmountOfStates);
        int actualStatesCount = this.calculateTransitionsTable(patterns.stream());
        this.adjustTransitionsTableSize(actualStatesCount);
        this.adjustOutputTableSize(actualStatesCount);
        this.adjustFailureTransitionsSize(actualStatesCount);
        this.makeInitialStateNeverFail();
        this.calculateFailureTransitions();
    }

    public void adjustFailureTransitionsSize(int actualStatesCount) {
        if (actualStatesCount == this.fail.length) {
            return;
        }
        int[] adjustedFail = new int[actualStatesCount];
        System.arraycopy(this.fail, 0, adjustedFail, 0, actualStatesCount);
        this.fail = adjustedFail;
    }

    public void adjustOutputTableSize(int actualStatesCount) {
        if (actualStatesCount == this.output.length) {
            return;
        }
        List[] adjustedOutput = new List[actualStatesCount];
        System.arraycopy(this.output, 0, adjustedOutput, 0, actualStatesCount);
        this.output = adjustedOutput;
    }

    public void adjustTransitionsTableSize(int actualStatesCount) {
        if (actualStatesCount == this.goTo.length) {
            return;
        }
        int[][] adjustedGoTo = new int[actualStatesCount][this.charToIntMapping.length + 1];
        for (int i = 0; i < actualStatesCount; ++i) {
            adjustedGoTo[i] = this.goTo[i];
        }
        this.goTo = adjustedGoTo;
    }

    public final void match(String text, MatchCallback callback) {
        int state = 0;
        for (int ci = 0; ci < text.length(); ++ci) {
            int chrInt;
            char chr = text.charAt(ci);
            int char2IntMappingIndex = Arrays.binarySearch(this.charToIntMapping, chr);
            int n = chrInt = char2IntMappingIndex < 0 ? this.absentCharInt : char2IntMappingIndex;
            while (this.goTo[state][chrInt] == -1) {
                state = this.fail[state];
            }
            state = this.goTo[state][chrInt];
            List<String> matched = this.output[state];
            for (int j = 0; j < matched.size(); ++j) {
                String found = matched.get(j);
                callback.onMatch(ci - found.length() + 1, ci, found);
            }
        }
    }

    public final boolean isEntryPrefix(String text) {
        int state = 0;
        for (int ci = 0; ci < text.length(); ++ci) {
            int chrInt;
            char chr = text.charAt(ci);
            int char2IntMappingIndex = Arrays.binarySearch(this.charToIntMapping, chr);
            int n = chrInt = char2IntMappingIndex < 0 ? this.absentCharInt : char2IntMappingIndex;
            if (this.goTo[state][chrInt] == -1) {
                state = -1;
                break;
            }
            state = this.goTo[state][chrInt];
        }
        if (state >= 0 && !this.output[state].isEmpty()) {
            for (int i = 0; i < this.goTo[state].length; ++i) {
                if (this.goTo[state][i] == -1) continue;
                return true;
            }
        }
        return state != 0 && state != -1 && this.output[state].isEmpty();
    }

    private void initializeOutputTable(int maxAmountOfStates) {
        this.output = new List[maxAmountOfStates];
        for (int i = 0; i < this.output.length; ++i) {
            this.output[i] = new ArrayList<String>();
        }
    }

    private void initializeFailureTransitions(int maxAmountOfStates) {
        this.fail = new int[maxAmountOfStates];
        Arrays.fill(this.fail, -1);
        this.fail[0] = 0;
    }

    private void initializeTransitionsTable(int maxAmountOfStates) {
        for (int[] row : this.goTo = new int[maxAmountOfStates][this.charToIntMapping.length + 1]) {
            Arrays.fill(row, -1);
        }
    }

    private void makeInitialStateNeverFail() {
        for (int i = 0; i < this.goTo[0].length; ++i) {
            if (this.goTo[0][i] != -1) continue;
            this.goTo[0][i] = 0;
        }
    }

    private int getMaxPossibleAmountOfStates(Stream<String> patterns) {
        return 1 + patterns.mapToInt(String::length).sum();
    }

    private void initializeCharToIntMapping(Stream<String> patterns) {
        HashSet uniqueChars = new HashSet();
        patterns.forEach(s2 -> {
            for (char c : s2.toCharArray()) {
                uniqueChars.add(Character.valueOf(c));
            }
        });
        this.charToIntMapping = new char[uniqueChars.size()];
        int charToIntMappingIdx = 0;
        Iterator iterator = uniqueChars.iterator();
        while (iterator.hasNext()) {
            char c;
            this.charToIntMapping[charToIntMappingIdx] = c = ((Character)iterator.next()).charValue();
            ++charToIntMappingIdx;
        }
        Arrays.sort(this.charToIntMapping);
    }

    private void calculateFailureTransitions() {
        LinkedList<Integer> queue = new LinkedList<Integer>();
        for (int stateReachableFromInitial : this.goTo[0]) {
            if (stateReachableFromInitial == 0) continue;
            queue.add(stateReachableFromInitial);
            this.fail[stateReachableFromInitial] = 0;
        }
        while (!queue.isEmpty()) {
            int curr = (Integer)queue.remove();
            for (int chrInt = 0; chrInt < this.goTo[curr].length; ++chrInt) {
                int stateReachableFromCurr = this.goTo[curr][chrInt];
                if (stateReachableFromCurr == -1) continue;
                queue.add(stateReachableFromCurr);
                int state = this.fail[curr];
                while (this.goTo[state][chrInt] == -1) {
                    state = this.fail[state];
                }
                this.fail[stateReachableFromCurr] = this.goTo[state][chrInt];
                this.output[stateReachableFromCurr].addAll(this.output[this.fail[stateReachableFromCurr]]);
            }
        }
    }

    private int calculateTransitionsTable(Stream<String> patterns) {
        int newState = 0;
        for (String s2 : () -> patterns.iterator()) {
            char chr;
            int chrInt;
            int ci;
            int state = 0;
            for (ci = 0; ci < s2.length() && this.goTo[state][chrInt = Arrays.binarySearch(this.charToIntMapping, chr = s2.charAt(ci))] != -1; ++ci) {
                state = this.goTo[state][chrInt];
            }
            while (ci < s2.length()) {
                chr = s2.charAt(ci);
                chrInt = Arrays.binarySearch(this.charToIntMapping, chr);
                this.goTo[state][chrInt] = ++newState;
                state = newState;
                ++ci;
            }
            this.output[state].add(s2);
        }
        return newState + 1;
    }

    public String generateGraphvizAutomatonRepresentation(boolean displayEdgesToInitialState) {
        return Util.generateGraphvizAutomatonRepresentation(this, displayEdgesToInitialState);
    }

    public static class Util {
        private static final String STYLE_FAILURE_TRANSITION = " [style=dashed, color=gray, constraint=false];";
        private static final String STYLE_STATE_WITHOUT_OUTPUT = " [shape=circle];";
        private static final String STYLE_STATE_WITH_OUTPUT = " [shape=doublecircle];";
        private static final char TAB = '\t';
        private static final char NEW_LINE = '\n';

        public static String generateGraphvizAutomatonRepresentation(AhoCorasickOptimized automaton, boolean displayEdgesToInitialState) {
            StringBuilder sb = new StringBuilder();
            sb.append("digraph automaton {").append('\n');
            sb.append('\t').append("graph [rankdir=LR];").append('\n');
            LinkedList<Integer> queue = new LinkedList<Integer>();
            queue.add(0);
            ArrayList<Integer> visitedStates = new ArrayList<Integer>();
            while (!queue.isEmpty()) {
                int state = (Integer)queue.remove();
                visitedStates.add(state);
                for (int charInt = 0; charInt < automaton.charToIntMapping.length; ++charInt) {
                    if (automaton.goTo[state][charInt] == -1 || automaton.goTo[state][charInt] == 0) continue;
                    queue.add(automaton.goTo[state][charInt]);
                    Util.appendAutomatonTransitionGraphviz(automaton, sb, state, charInt);
                }
            }
            Util.appendFailureTransitionsToGraphviz(automaton, displayEdgesToInitialState, sb, visitedStates);
            Util.displayStatesInGraphviz(automaton, sb, visitedStates);
            sb.append("}");
            return sb.toString();
        }

        public static void appendAutomatonTransitionGraphviz(AhoCorasickOptimized automaton, StringBuilder sb, int state, int charInt) {
            sb.append('\t').append(state).append(" -> ").append(automaton.goTo[state][charInt]).append(" [label=").append(automaton.charToIntMapping[charInt]).append(", weight=100, style=bold];").append('\n');
        }

        private static void displayStatesInGraphviz(AhoCorasickOptimized automaton, StringBuilder sb, List<Integer> visitedStates) {
            for (int state : visitedStates) {
                if (!automaton.output[state].isEmpty()) {
                    sb.append('\t').append(state).append(STYLE_STATE_WITH_OUTPUT).append('\n');
                    continue;
                }
                sb.append('\t').append(state).append(STYLE_STATE_WITHOUT_OUTPUT).append('\n');
            }
        }

        private static void appendFailureTransitionsToGraphviz(AhoCorasickOptimized automaton, boolean displayEdgesToInitialState, StringBuilder sb, List<Integer> states) {
            for (int state : states) {
                if (!displayEdgesToInitialState && automaton.fail[state] == 0 && state != 0) continue;
                sb.append('\t').append(state).append(" -> ").append(automaton.fail[state]).append(STYLE_FAILURE_TRANSITION).append('\n');
            }
        }
    }

    public static interface MatchCallback {
        public void onMatch(int var1, int var2, String var3);
    }
}

