/*
 * Decompiled with CFR 0.152.
 */
package com.fulmicoton.multiregexp;

import com.fulmicoton.multiregexp.MultiPatternAutomaton;
import com.fulmicoton.multiregexp.ScanException;
import java.util.ArrayList;

public class Scanner<T extends Enum> {
    private final MultiPatternAutomaton automaton;
    private final CharSequence str;
    private final ArrayList<T> tokenTypes;
    public T type;
    public int start = 0;
    public int end = 0;

    public CharSequence tokenString() {
        return this.str.subSequence(this.start, this.end);
    }

    public Scanner(MultiPatternAutomaton automaton, CharSequence str, ArrayList<T> tokenTypes) {
        this.str = str;
        this.automaton = automaton;
        this.tokenTypes = tokenTypes;
    }

    boolean nextUnchecked() {
        try {
            return this.next();
        }
        catch (ScanException e) {
            throw new RuntimeException(e);
        }
    }

    boolean next() throws ScanException {
        char chr;
        this.start = this.end;
        if (this.start == this.str.length()) {
            return false;
        }
        int p = 0;
        int highestPriorityMatch = Integer.MAX_VALUE;
        int lastLetter = this.start;
        for (int i = this.start; i < this.str.length() && (p = this.automaton.step(p, chr = this.str.charAt(i))) != -1; ++i) {
            int minAccept;
            int[] accept = this.automaton.accept[p];
            if (accept.length <= 0 || (minAccept = accept[0]) > highestPriorityMatch) continue;
            highestPriorityMatch = minAccept;
            lastLetter = i;
        }
        if (highestPriorityMatch == Integer.MAX_VALUE) {
            int contextStart = Math.max(0, this.start - 10);
            int contextEnd = Math.min(this.start + 10, this.str.length());
            String context = this.str.subSequence(contextStart, this.start) + "|" + this.str.subSequence(this.start, contextEnd);
            throw new ScanException(context, this.start);
        }
        this.end = lastLetter + 1;
        this.type = (Enum)this.tokenTypes.get(highestPriorityMatch);
        return true;
    }
}

