/*
 * Decompiled with CFR 0.152.
 */
package com.fulmicoton.multiregexp;

import com.fulmicoton.multiregexp.MultiPatternAutomaton;
import dk.brics.automaton.Automaton;
import dk.brics.automaton.RunAutomaton;
import dk.brics.automaton.State;
import dk.brics.automaton.StatePair;
import dk.brics.automaton.Transition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MultiPatternSearcher {
    private final MultiPatternAutomaton automaton;
    private final List<RunAutomaton> individualAutomatons;
    private final List<RunAutomaton> inverseAutomatons;

    MultiPatternSearcher(MultiPatternAutomaton automaton, List<Automaton> individualAutomatons) {
        this.automaton = automaton;
        this.individualAutomatons = new ArrayList<RunAutomaton>();
        for (Automaton individualAutomaton : individualAutomatons) {
            this.individualAutomatons.add(new RunAutomaton(individualAutomaton));
        }
        this.inverseAutomatons = new ArrayList<RunAutomaton>(this.individualAutomatons.size());
        for (Automaton individualAutomaton : individualAutomatons) {
            Automaton inverseAutomaton = MultiPatternSearcher.inverseAutomaton(individualAutomaton);
            this.inverseAutomatons.add(new RunAutomaton(inverseAutomaton));
        }
    }

    static Automaton inverseAutomaton(Automaton automaton) {
        HashMap<State, State> stateMapping = new HashMap<State, State>();
        for (State state : automaton.getStates()) {
            stateMapping.put(state, new State());
        }
        for (State state : automaton.getStates()) {
            for (Transition transition : state.getTransitions()) {
                State invDest = (State)stateMapping.get(state);
                State invOrig = (State)stateMapping.get(transition.getDest());
                invOrig.addTransition(new Transition(transition.getMin(), transition.getMax(), invDest));
            }
        }
        Automaton inverseAutomaton = new Automaton();
        ((State)stateMapping.get(automaton.getInitialState())).setAccept(true);
        State initialState = new State();
        inverseAutomaton.setInitialState(initialState);
        ArrayList<StatePair> epsilons = new ArrayList<StatePair>();
        for (State acceptState : automaton.getAcceptStates()) {
            State invOrigState = (State)stateMapping.get(acceptState);
            StatePair statePair = new StatePair(initialState, invOrigState);
            epsilons.add(statePair);
        }
        inverseAutomaton.addEpsilons(epsilons);
        return inverseAutomaton;
    }

    public Cursor search(CharSequence s2) {
        return this.search(s2, 0);
    }

    public Cursor search(CharSequence s2, int position) {
        return new Cursor(s2, position);
    }

    public class Cursor {
        private final CharSequence seq;
        private int matchingPattern = -1;
        private int end = 0;
        private int start = -1;

        Cursor(CharSequence seq, int position) {
            this.seq = seq;
            this.end = position;
        }

        public int start() {
            return this.start;
        }

        public int end() {
            return this.end;
        }

        public int match() {
            return this.matchingPattern;
        }

        public boolean found() {
            return this.matchingPattern >= 0;
        }

        public boolean next() {
            char c;
            int pos;
            this.start = -1;
            this.matchingPattern = -1;
            int seqLength = this.seq.length();
            int state = 0;
            for (int pos2 = this.end; pos2 < seqLength; ++pos2) {
                char c2 = this.seq.charAt(pos2);
                state = MultiPatternSearcher.this.automaton.step(state, c2);
                if (!((MultiPatternSearcher)MultiPatternSearcher.this).automaton.atLeastOneAccept[state]) continue;
                this.matchingPattern = ((MultiPatternSearcher)MultiPatternSearcher.this).automaton.accept[state][0];
                this.end = pos2;
                break;
            }
            if (this.matchingPattern == -1) {
                return false;
            }
            RunAutomaton backwardAutomaton = (RunAutomaton)MultiPatternSearcher.this.inverseAutomatons.get(this.matchingPattern);
            int state2 = backwardAutomaton.getInitialState();
            for (pos = this.end; pos >= 0 && (state2 = backwardAutomaton.step(state2, c = this.seq.charAt(pos))) != -1; --pos) {
                if (!backwardAutomaton.isAccept(state2)) continue;
                this.start = pos;
            }
            RunAutomaton forwardAutomaton = (RunAutomaton)MultiPatternSearcher.this.individualAutomatons.get(this.matchingPattern);
            state2 = forwardAutomaton.getInitialState();
            for (pos = this.start; pos < seqLength && (state2 = forwardAutomaton.step(state2, c = this.seq.charAt(pos))) != -1; ++pos) {
                if (!forwardAutomaton.isAccept(state2)) continue;
                this.end = pos + 1;
            }
            return true;
        }
    }
}

