/*
 * Decompiled with CFR 0.152.
 */
package com.bluecast.xml;

import com.bluecast.io.CharsetDecoder;
import com.bluecast.xml.XMLDecoderFactory;
import com.bluecast.xml.XMLInputReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

public final class XMLStreamReader
extends XMLInputReader {
    private static final int BYTE_BUFFER_SIZE = 8192;
    private CharsetDecoder decoder = null;
    private int minBytesPerChar;
    private int maxBytesPerChar;
    private InputStream in;
    private int[] decodeResult = new int[2];
    private String encoding;
    private boolean useDeclaredEncoding = false;
    private boolean rewindDeclaration;
    private char[] cbuf = new char[100];
    private byte[] bbuf = new byte[8192];
    private int cbufPos = 0;
    private int cbufEnd = 0;
    private int bbufPos = 0;
    private int bbufEnd = 0;
    private boolean eofReached = false;
    private static final int MAX_XML_DECL_CHARS = 100;
    private static HashMap charsetTable = new HashMap(31);

    public XMLStreamReader() {
    }

    public XMLStreamReader(InputStream inputStream, boolean bl) throws IOException {
        this(inputStream, null, bl);
    }

    public XMLStreamReader(InputStream inputStream, String string, boolean bl) throws IOException {
        this.reset(inputStream, string, bl);
    }

    public void reset(InputStream inputStream, String string, boolean bl) throws IOException {
        super.resetInput();
        this.in = inputStream;
        this.rewindDeclaration = bl;
        this.useDeclaredEncoding = false;
        this.bbufEnd = 0;
        this.bbufPos = 0;
        this.cbufEnd = 0;
        this.cbufPos = 0;
        this.fillByteBuffer();
        if (string != null) {
            this.encoding = this.getJavaCharset(string);
            if (this.encoding == "Unicode") {
                this.encoding = this.guessEncoding();
                if (this.encoding == null || !this.encoding.equals("UnicodeLittle")) {
                    this.encoding = "UnicodeBig";
                }
            }
        } else {
            this.encoding = this.guessEncoding();
            if (this.encoding == null) {
                this.useDeclaredEncoding = true;
                this.encoding = "UTF-8";
            }
        }
        this.setEncoding(this.encoding);
        this.processXMLDecl();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void close() throws IOException {
        this.eofReached = true;
        this.cbufEnd = 0;
        this.cbufPos = 0;
        this.bbufEnd = 0;
        this.bbufPos = 0;
        if (this.in != null) {
            this.in.close();
        }
    }

    public void mark(int n) throws IOException {
        throw new UnsupportedOperationException("mark() not supported");
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (this.cbufEnd - this.cbufPos > 0) {
            return this.cbuf[this.cbufPos++];
        }
        this.cbufEnd = 0;
        this.cbufPos = 0;
        this.cbufEnd = this.read(this.cbuf, this.cbufPos, 100);
        if (this.cbufEnd > 0) {
            return this.cbuf[this.cbufPos++];
        }
        return -1;
    }

    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        if (this.cbufEnd - this.cbufPos > 0 && (n3 = Math.min(this.cbufEnd - this.cbufPos, n2 - n4)) > 0) {
            System.arraycopy(this.cbuf, this.cbufPos, cArray, n, n3);
            n4 += n3;
            this.cbufPos += n3;
        }
        while (n4 < n2) {
            if (this.bbufEnd - this.bbufPos < this.maxBytesPerChar) {
                this.fillByteBuffer();
                if (this.bbufEnd - this.bbufPos < this.minBytesPerChar) {
                    return n4 == 0 ? -1 : n4;
                }
            }
            this.decoder.decode(this.bbuf, this.bbufPos, this.bbufEnd - this.bbufPos, cArray, n + n4, n2 - n4, this.decodeResult);
            this.bbufPos += this.decodeResult[0];
            n4 += this.decodeResult[1];
        }
        return n4 == 0 && this.eofReached ? -1 : n4;
    }

    public boolean ready() throws IOException {
        return this.cbufEnd - this.cbufPos > 0 || this.bbufEnd - this.bbufPos > this.maxBytesPerChar || this.in.available() > 0;
    }

    public void reset() throws IOException {
        super.resetInput();
        this.in.reset();
        this.cbufEnd = 0;
        this.cbufPos = 0;
        this.bbufEnd = 0;
        this.bbufPos = 0;
    }

    public long skip(long l) throws IOException {
        long l2 = 0L;
        if (this.cbufEnd - this.cbufPos > 0) {
            l2 = Math.min((long)this.cbufEnd - (long)this.cbufPos, l);
            this.cbufPos = (int)((long)this.cbufPos + l2);
        }
        while (l2 < l) {
            this.cbufPos = 0;
            this.cbufEnd = this.read(this.cbuf, 0, 100);
            if (this.cbufEnd > 0) {
                this.cbufPos = (int)Math.min((long)this.cbufEnd, l - l2);
                l2 += (long)this.cbufPos;
                continue;
            }
            this.cbufEnd = 0;
            return l2;
        }
        return l2;
    }

    private void setEncoding(String string) throws IOException {
        this.decoder = XMLDecoderFactory.createDecoder(string);
        this.encoding = string;
        if (this.decoder == null) {
            throw new UnsupportedEncodingException(string);
        }
        this.minBytesPerChar = this.decoder.minBytesPerChar();
        this.maxBytesPerChar = this.decoder.maxBytesPerChar();
    }

    private int fillByteBuffer() throws IOException {
        int n = this.bbufEnd - this.bbufPos;
        if (n > 0) {
            System.arraycopy(this.bbuf, this.bbufPos, this.bbuf, 0, n);
        }
        this.bbufPos = 0;
        this.bbufEnd = n;
        int n2 = 0;
        while (this.bbufEnd < 8192 && (n2 = this.in.read(this.bbuf, this.bbufEnd, 8192 - this.bbufEnd)) != -1) {
            this.bbufEnd += n2;
        }
        if (n2 == -1) {
            this.eofReached = true;
        }
        return n2;
    }

    private String getJavaCharset(String string) {
        if (string == null) {
            return null;
        }
        String string2 = (String)charsetTable.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    private String guessEncoding() throws IOException {
        if (this.bbufEnd < 4) {
            return null;
        }
        switch (this.bbuf[0]) {
            case -17: {
                if (this.bbuf[1] == -69 && this.bbuf[2] == -65) {
                    this.bbufPos = 3;
                    return "UTF-8";
                }
                return null;
            }
            case 60: {
                switch (this.bbuf[1]) {
                    case 63: {
                        if (this.bbuf[2] == 120 && this.bbuf[3] == 109) {
                            this.useDeclaredEncoding = true;
                            return "UTF-8";
                        }
                        return null;
                    }
                    case 0: {
                        if (this.bbuf[2] == 63 && this.bbuf[3] == 0) {
                            return "UnicodeLittleUnmarked";
                        }
                        if (this.bbuf[2] == 0 && this.bbuf[3] == 0) {
                            return "UCS-4";
                        }
                        return null;
                    }
                }
                return null;
            }
            case -2: {
                if (this.bbuf[1] == -1) {
                    if (this.bbuf[2] == 0 && this.bbuf[3] == 0) {
                        this.bbufPos = 4;
                        return "UCS-4";
                    }
                    this.bbufPos = 2;
                    return "UnicodeBig";
                }
                return null;
            }
            case -1: {
                if (this.bbuf[1] == -2) {
                    if (this.bbuf[2] == 0 && this.bbuf[3] == 0) {
                        this.bbufPos = 4;
                        return "UCS-4";
                    }
                    this.bbufPos = 2;
                    return "UnicodeLittle";
                }
                return null;
            }
            case 0: {
                switch (this.bbuf[1]) {
                    case 0: {
                        if (this.bbuf[2] == -2 && this.bbuf[3] == -1) {
                            this.bbufPos = 4;
                            return "UCS-4";
                        }
                        if (this.bbuf[2] == -1 && this.bbuf[3] == -2) {
                            this.bbufPos = 4;
                            return "UCS-4";
                        }
                        if (this.bbuf[2] == 60 && this.bbuf[3] == 0 || this.bbuf[2] == 0 && this.bbuf[3] == 60) {
                            return "UCS-4";
                        }
                        return null;
                    }
                    case 60: {
                        if (this.bbuf[2] == 0 && this.bbuf[3] == 63) {
                            return "UnicodeBigUnmarked";
                        }
                        if (this.bbuf[2] == 0 && this.bbuf[3] == 0) {
                            return "UCS-4";
                        }
                        return null;
                    }
                }
                return null;
            }
            case 76: {
                if (this.bbuf[1] == 111 && this.bbuf[2] == -89 && this.bbuf[3] == -108) {
                    this.useDeclaredEncoding = true;
                    return "Cp037";
                }
                return null;
            }
        }
        this.useDeclaredEncoding = true;
        return null;
    }

    private void processXMLDecl() throws IOException {
        int n = this.bbufPos;
        this.decoder.decode(this.bbuf, this.bbufPos, this.bbufEnd - this.bbufPos, this.cbuf, this.cbufPos, this.cbuf.length, this.decodeResult);
        this.bbufPos += this.decodeResult[0];
        this.cbufEnd = this.decodeResult[1];
        int n2 = this.parseXMLDeclaration(this.cbuf, 0, this.cbufEnd);
        if (n2 > 0) {
            String string = this.getJavaCharset(this.getXMLDeclaredEncoding());
            if (!this.rewindDeclaration) {
                this.cbufPos += n2;
            }
            if (this.useDeclaredEncoding && string != null && !string.equalsIgnoreCase(this.encoding)) {
                this.cbufEnd = 0;
                this.cbufPos = 0;
                this.bbufPos = this.rewindDeclaration ? n : n2 * this.minBytesPerChar;
                this.setEncoding(string);
            }
        }
    }

    static {
        charsetTable.put("EBCDIC-CP-US", "Cp037");
        charsetTable.put("EBCDIC-CP-CA", "Cp037");
        charsetTable.put("EBCDIC-CP-NL", "Cp037");
        charsetTable.put("EBCDIC-CP-WT", "Cp037");
        charsetTable.put("EBCDIC-CP-DK", "Cp277");
        charsetTable.put("EBCDIC-CP-NO", "Cp277");
        charsetTable.put("EBCDIC-CP-FI", "Cp278");
        charsetTable.put("EBCDIC-CP-SE", "Cp278");
        charsetTable.put("EBCDIC-CP-IT", "Cp280");
        charsetTable.put("EBCDIC-CP-ES", "Cp284");
        charsetTable.put("EBCDIC-CP-GB", "Cp285");
        charsetTable.put("EBCDIC-CP-FR", "Cp297");
        charsetTable.put("EBCDIC-CP-AR1", "Cp420");
        charsetTable.put("EBCDIC-CP-GR", "Cp423");
        charsetTable.put("EBCDIC-CP-HE", "Cp424");
        charsetTable.put("EBCDIC-CP-BE", "Cp500");
        charsetTable.put("EBCDIC-CP-CH", "Cp500");
        charsetTable.put("EBCDIC-CP-ROECE", "Cp870");
        charsetTable.put("EBCDIC-CP-YU", "Cp870");
        charsetTable.put("EBCDIC-CP-IS", "Cp871");
        charsetTable.put("EBCDIC-CP-TR", "Cp905");
        charsetTable.put("EBCDIC-CP-AR2", "Cp918");
        charsetTable.put("UTF-16", "Unicode");
        charsetTable.put("ISO-10646-UCS-2", "Unicode");
    }
}

