/*
 * Decompiled with CFR 0.152.
 */
package com.bluecast.xml;

import com.bluecast.xml.XMLInputReader;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.Reader;

public final class XMLReaderReader
extends XMLInputReader {
    private static final int BUFFER_SIZE = 8192;
    private Reader in;
    private boolean rewindDeclaration;
    private char[] cbuf = new char[8192];
    private int cbufPos = 0;
    private int cbufEnd = 0;
    private boolean eofReached = false;
    private boolean sawCR = false;
    private char[] oneCharBuf = new char[1];

    public XMLReaderReader() {
    }

    public XMLReaderReader(Reader reader) throws IOException {
        this(reader, true);
    }

    public XMLReaderReader(Reader reader, boolean bl) throws IOException {
        this.reset(reader, bl);
    }

    public void reset(Reader reader, boolean bl) throws IOException {
        super.resetInput();
        this.in = reader;
        this.rewindDeclaration = bl;
        this.cbufEnd = 0;
        this.cbufPos = 0;
        this.sawCR = false;
        this.eofReached = false;
        this.fillCharBuffer();
        this.processXMLDecl();
    }

    public void close() throws IOException {
        this.eofReached = true;
        this.cbufEnd = 0;
        this.cbufPos = 0;
        if (this.in != null) {
            this.in.close();
        }
    }

    public void mark(int n) throws IOException {
        throw new UnsupportedOperationException("mark() not supported");
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        int n = this.read(this.oneCharBuf, 0, 1);
        if (n <= 0) {
            return n;
        }
        return this.oneCharBuf[0];
    }

    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            if (this.cbufPos >= this.cbufEnd) {
                if (this.eofReached) break;
                this.fillCharBuffer();
                continue;
            }
            char c = this.cbuf[this.cbufPos++];
            if (c >= ' ') {
                if (c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff') {
                    this.sawCR = false;
                    cArray[n + n3++] = c;
                    continue;
                }
                throw new CharConversionException("Illegal XML Character: 0x" + Integer.toHexString(c));
            }
            switch (c) {
                case '\n': {
                    if (this.sawCR) {
                        this.sawCR = false;
                        break;
                    }
                    cArray[n + n3++] = 10;
                    break;
                }
                case '\r': {
                    this.sawCR = true;
                    cArray[n + n3++] = 10;
                    break;
                }
                case '\t': {
                    cArray[n + n3++] = 9;
                    break;
                }
                default: {
                    throw new CharConversionException("Illegal XML character: 0x" + Integer.toHexString(c));
                }
            }
        }
        return n3 == 0 && this.eofReached ? -1 : n3;
    }

    public boolean ready() throws IOException {
        return this.cbufEnd - this.cbufPos > 0 || this.in.ready();
    }

    public void reset() throws IOException {
        super.resetInput();
        this.in.reset();
        this.cbufEnd = 0;
        this.cbufPos = 0;
        this.sawCR = false;
        this.eofReached = false;
    }

    public long skip(long l) throws IOException {
        int n = 0;
        while ((long)n < l) {
            if (this.cbufPos >= this.cbufEnd) {
                if (this.eofReached) break;
                this.fillCharBuffer();
                continue;
            }
            char c = this.cbuf[this.cbufPos++];
            if (c >= ' ') {
                if (c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff') {
                    this.sawCR = false;
                    ++n;
                    continue;
                }
                throw new CharConversionException("Illegal XML Character: 0x" + Integer.toHexString(c));
            }
            switch (c) {
                case '\n': {
                    if (this.sawCR) {
                        this.sawCR = false;
                        break;
                    }
                    ++n;
                    break;
                }
                case '\r': {
                    this.sawCR = true;
                    ++n;
                    break;
                }
                case '\t': {
                    ++n;
                    break;
                }
                default: {
                    throw new CharConversionException("Illegal XML character: 0x" + Integer.toHexString(c));
                }
            }
        }
        return n == 0 && this.eofReached ? -1 : n;
    }

    private void fillCharBuffer() throws IOException {
        this.cbufPos = 0;
        this.cbufEnd = this.in.read(this.cbuf, 0, 8192);
        if (this.cbufEnd <= 0) {
            this.eofReached = true;
        }
    }

    private void processXMLDecl() throws IOException {
        int n = this.parseXMLDeclaration(this.cbuf, 0, this.cbufEnd);
        if (n > 0 && !this.rewindDeclaration) {
            this.cbufPos += n;
        }
    }
}

