/*
 * Decompiled with CFR 0.152.
 */
package com.bluecast.xml;

import com.bluecast.io.CharsetDecoder;
import com.bluecast.xml.ASCIIXMLDecoder;
import com.bluecast.xml.ISO8859_1XMLDecoder;
import com.bluecast.xml.UTF8XMLDecoder;
import com.bluecast.xml.UnicodeBigXMLDecoder;
import com.bluecast.xml.UnicodeLittleXMLDecoder;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

public class XMLDecoderFactory {
    private static HashMap decoders = new HashMap();

    public static CharsetDecoder createDecoder(String string) throws UnsupportedEncodingException {
        CharsetDecoder charsetDecoder = (CharsetDecoder)decoders.get(string.toUpperCase());
        if (charsetDecoder != null) {
            return charsetDecoder.newInstance();
        }
        throw new UnsupportedEncodingException("Encoding '" + string + "' not supported");
    }

    static {
        UTF8XMLDecoder uTF8XMLDecoder = new UTF8XMLDecoder();
        ASCIIXMLDecoder aSCIIXMLDecoder = new ASCIIXMLDecoder();
        ISO8859_1XMLDecoder iSO8859_1XMLDecoder = new ISO8859_1XMLDecoder();
        UnicodeBigXMLDecoder unicodeBigXMLDecoder = new UnicodeBigXMLDecoder();
        UnicodeLittleXMLDecoder unicodeLittleXMLDecoder = new UnicodeLittleXMLDecoder();
        decoders.put("UTF-8", uTF8XMLDecoder);
        decoders.put("UTF8", uTF8XMLDecoder);
        decoders.put("US-ASCII", aSCIIXMLDecoder);
        decoders.put("ASCII", aSCIIXMLDecoder);
        decoders.put("ISO-8859-1", iSO8859_1XMLDecoder);
        decoders.put("ISO8859_1", iSO8859_1XMLDecoder);
        decoders.put("UTF-16LE", unicodeLittleXMLDecoder);
        decoders.put("UNICODELITTLE", unicodeLittleXMLDecoder);
        decoders.put("UNICODELITTLEUNMARKED", unicodeLittleXMLDecoder);
        decoders.put("UTF-16BE", unicodeBigXMLDecoder);
        decoders.put("UNICODEBIG", unicodeBigXMLDecoder);
        decoders.put("UNICODEBIGUNMARKED", unicodeBigXMLDecoder);
    }
}

