/*
 * Decompiled with CFR 0.152.
 */
package com.bluecast.xml;

import com.bluecast.io.CharsetDecoder;
import java.io.CharConversionException;

public final class UnicodeBigXMLDecoder
implements CharsetDecoder {
    public CharsetDecoder newInstance() {
        return new UnicodeBigXMLDecoder();
    }

    public int minBytesPerChar() {
        return 1;
    }

    public int maxBytesPerChar() {
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void decode(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4, int[] nArray) throws CharConversionException {
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        while (n6 + 1 < n2 && n5 < n4) {
            char c = (char)((0xFF & byArray[n + n6]) << 8 | 0xFF & byArray[n + n6 + 1]);
            if (c >= ' ') {
                if (c > '\ud7ff' && (c < '\ue000' || c > '\ufffd') && (c < '\u10000' || c > '\u10ffff')) throw new CharConversionException("Illegal XML Character: 0x" + Integer.toHexString(c));
                bl = false;
                cArray[n3 + n5++] = c;
            } else {
                switch (c) {
                    case '\n': {
                        if (bl) {
                            bl = false;
                            break;
                        }
                        cArray[n3 + n5++] = 10;
                        break;
                    }
                    case '\r': {
                        bl = true;
                        cArray[n3 + n5++] = 10;
                        break;
                    }
                    case '\t': {
                        cArray[n3 + n5++] = 9;
                        break;
                    }
                    default: {
                        throw new CharConversionException("Illegal XML character: 0x" + Integer.toHexString(c));
                    }
                }
            }
            n6 += 2;
        }
        nArray[0] = n6;
        nArray[1] = n5;
    }
}

