/*
 * Decompiled with CFR 0.152.
 */
package com.bluecast.xml;

import com.bluecast.util.FactoryServiceFinder;
import com.bluecast.xml.Piccolo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class JAXPSAXParserFactory
extends SAXParserFactory {
    private Map featureMap = new HashMap();
    private static Boolean TRUE = new Boolean(true);
    private static Boolean FALSE = new Boolean(false);
    private Piccolo nvParser = new Piccolo();
    private SAXParserFactory validatingFactory;
    private static final String VALIDATING_PROPERTY = "com.bluecast.xml.ValidatingSAXParserFactory";
    private static Class validatingFactoryClass = JAXPSAXParserFactory.findValidatingFactory();
    private ParserConfigurationException pendingValidatingException = null;
    private ParserConfigurationException pendingNonvalidatingException = null;
    private boolean validating = false;
    private boolean namespaceAware = false;

    public JAXPSAXParserFactory() {
        try {
            if (validatingFactoryClass != null) {
                this.validatingFactory = (SAXParserFactory)validatingFactoryClass.newInstance();
                this.validatingFactory.setNamespaceAware(false);
                this.validatingFactory.setValidating(true);
            }
        }
        catch (InstantiationException instantiationException) {
            this.validatingFactory = null;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.validatingFactory = null;
        }
        this.setNamespaceAware(false);
    }

    public boolean getFeature(String string) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        if (this.validating && this.validatingFactory != null) {
            return this.validatingFactory.getFeature(string);
        }
        return this.nvParser.getFeature(string);
    }

    public SAXParser newSAXParser() throws ParserConfigurationException, SAXException {
        if (this.validating) {
            if (this.validatingFactory == null) {
                throw new ParserConfigurationException("XML document validation is not supported");
            }
            if (this.pendingValidatingException != null) {
                throw this.pendingValidatingException;
            }
            return this.validatingFactory.newSAXParser();
        }
        if (this.pendingNonvalidatingException != null) {
            throw this.pendingNonvalidatingException;
        }
        return new JAXPSAXParser(new Piccolo(this.nvParser));
    }

    public void setFeature(String string, boolean bl) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        this.featureMap.put(string, bl ? TRUE : FALSE);
        if (this.validatingFactory != null) {
            if (this.pendingValidatingException != null) {
                this.reconfigureValidating();
            } else {
                try {
                    this.validatingFactory.setFeature(string, bl);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    this.pendingValidatingException = parserConfigurationException;
                }
            }
        }
        if (this.pendingNonvalidatingException != null) {
            this.reconfigureNonvalidating();
        }
        if (this.validating && this.pendingValidatingException != null) {
            throw this.pendingValidatingException;
        }
        if (!this.validating && this.pendingNonvalidatingException != null) {
            throw this.pendingNonvalidatingException;
        }
    }

    public void setNamespaceAware(boolean bl) {
        super.setNamespaceAware(bl);
        this.namespaceAware = bl;
        try {
            this.nvParser.setFeature("http://xml.org/sax/features/namespaces", bl);
            this.nvParser.setFeature("http://xml.org/sax/features/namespace-prefixes", !bl);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            this.pendingNonvalidatingException = new ParserConfigurationException("Error setting namespace feature: " + sAXNotSupportedException.toString());
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            this.pendingNonvalidatingException = new ParserConfigurationException("Error setting namespace feature: " + sAXNotRecognizedException.toString());
        }
        if (this.validatingFactory != null) {
            this.validatingFactory.setNamespaceAware(bl);
        }
    }

    public void setValidating(boolean bl) {
        super.setValidating(bl);
        this.validating = bl;
    }

    private static Class findValidatingFactory() {
        String string;
        Object object;
        try {
            object = System.getProperty(VALIDATING_PROPERTY);
            if (object != null) {
                return Class.forName((String)object);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            object = System.getProperty("java.home");
            string = (String)object + File.separator + "lib" + File.separator + "jaxp.properties";
            File file = new File(string);
            if (file.exists()) {
                Properties properties = new Properties();
                properties.load(new FileInputStream(file));
                String string2 = properties.getProperty(VALIDATING_PROPERTY);
                if (string2 != null) {
                    return Class.forName(string2);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object = FactoryServiceFinder.findServices("javax.xml.parsers.SAXParserFactory");
            while (object.hasMoreElements()) {
                try {
                    string = (String)object.nextElement();
                    if (string.equals("com.bluecast.xml.Piccolo")) continue;
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            return Class.forName("org.apache.crimson.jaxp.SAXParserFactoryImpl");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private void reconfigureValidating() {
        if (this.validatingFactory == null) {
            return;
        }
        try {
            Iterator iterator = this.featureMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.validatingFactory.setFeature((String)entry.getKey(), (Boolean)entry.getValue());
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.pendingValidatingException = parserConfigurationException;
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            this.pendingValidatingException = new ParserConfigurationException(sAXNotRecognizedException.toString());
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            this.pendingValidatingException = new ParserConfigurationException(sAXNotSupportedException.toString());
        }
    }

    private void reconfigureNonvalidating() {
        try {
            Iterator iterator = this.featureMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.nvParser.setFeature((String)entry.getKey(), (Boolean)entry.getValue());
            }
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            this.pendingNonvalidatingException = new ParserConfigurationException(sAXNotRecognizedException.toString());
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            this.pendingNonvalidatingException = new ParserConfigurationException(sAXNotSupportedException.toString());
        }
    }

    static class JAXPSAXParser
    extends SAXParser {
        Piccolo parser;

        JAXPSAXParser(Piccolo piccolo) {
            this.parser = piccolo;
        }

        public Parser getParser() {
            return this.parser;
        }

        public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
            return this.parser.getProperty(string);
        }

        public XMLReader getXMLReader() {
            return this.parser;
        }

        public boolean isNamespaceAware() {
            return this.parser.fNamespaces;
        }

        public boolean isValidating() {
            return false;
        }

        public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
            this.parser.setProperty(string, object);
        }
    }
}

