/*
 * Decompiled with CFR 0.152.
 */
package com.bluecast.xml;

import com.bluecast.util.IntStack;
import com.bluecast.util.StringStack;

public class FastNamespaceSupport {
    public static final String XMLNS = "http://www.w3.org/XML/1998/namespace";
    private String[] prefixes = new String[20];
    private String[] uris = new String[20];
    private int prefixPos;
    private String defaultURI;
    private StringStack defaultURIs = new StringStack(20);
    private int prefixCount;
    private IntStack contextPrefixCounts = new IntStack(20);
    private int defaultURIContexts;
    private IntStack defaultURIContextCounts = new IntStack(20);

    public FastNamespaceSupport() {
        this.reset();
    }

    public void reset() {
        this.defaultURIs.clear();
        this.contextPrefixCounts.clear();
        this.defaultURIContextCounts.clear();
        this.prefixPos = -1;
        this.defaultURI = "";
        this.prefixCount = 0;
        this.defaultURIContexts = 0;
    }

    public void pushContext() {
        ++this.defaultURIContexts;
        this.contextPrefixCounts.push(this.prefixCount);
        this.prefixCount = 0;
    }

    public void popContext() {
        if (this.defaultURIContexts <= 0) {
            this.defaultURIContexts = this.defaultURIContextCounts.pop();
            this.defaultURI = this.defaultURIs.pop();
        } else {
            --this.defaultURIContexts;
        }
        this.prefixPos -= this.prefixCount;
        this.prefixCount = this.contextPrefixCounts.pop();
    }

    public void declarePrefix(String string, String string2) {
        if (string.length() == 0) {
            if (this.defaultURIContexts > 0) {
                this.defaultURIContextCounts.push(this.defaultURIContexts);
                this.defaultURIs.push(this.defaultURI);
                this.defaultURIContexts = 0;
            }
            this.defaultURI = string2;
        } else {
            int n = 0;
            while (n < this.prefixCount) {
                if (string == this.prefixes[this.prefixPos - n]) {
                    this.uris[this.prefixPos - n] = string2;
                    return;
                }
                ++n;
            }
            ++this.prefixPos;
            ++this.prefixCount;
            if (this.prefixPos >= this.prefixes.length) {
                int n2 = this.prefixes.length;
                int n3 = n2 * 2;
                String[] stringArray = new String[n3];
                String[] stringArray2 = new String[n3];
                System.arraycopy(this.prefixes, 0, stringArray, 0, n2);
                System.arraycopy(this.uris, 0, stringArray2, 0, n2);
                this.prefixes = stringArray;
                this.uris = stringArray2;
            }
            this.prefixes[this.prefixPos] = string;
            this.uris[this.prefixPos] = string2;
        }
    }

    public String[] processName(String string, String[] stringArray, boolean bl) {
        int n = string.indexOf(58);
        stringArray[2] = string;
        if (n < 0) {
            stringArray[1] = string;
            stringArray[0] = bl ? "" : this.defaultURI;
            return stringArray;
        }
        String string2 = string.substring(0, n);
        stringArray[1] = string.substring(n + 1);
        stringArray[0] = this.getURI(string2);
        if (stringArray[0] == "") {
            return null;
        }
        return stringArray;
    }

    public String getDefaultURI() {
        return this.defaultURI;
    }

    public String getURI(String string) {
        if (string == null || string.length() == 0) {
            return this.defaultURI;
        }
        if (string == "xml") {
            return XMLNS;
        }
        int n = this.prefixPos;
        while (n >= 0) {
            if (string == this.prefixes[n]) {
                return this.uris[n];
            }
            --n;
        }
        return "";
    }

    public int getContextSize() {
        return this.prefixCount + (this.defaultURIContexts == 0 && this.defaultURI != "" ? 1 : 0);
    }

    public String getContextPrefix(int n) {
        if (n == this.prefixCount && this.defaultURIContexts == 0 && this.defaultURI != "") {
            return "";
        }
        return this.prefixes[this.prefixPos - n];
    }

    public String getContextURI(int n) {
        if (n == this.prefixCount && this.defaultURIContexts == 0 && this.defaultURI != "") {
            return this.defaultURI;
        }
        return this.uris[this.prefixPos - n];
    }
}

