/*
 * Decompiled with CFR 0.152.
 */
package com.bluecast.xml;

import com.bluecast.util.RecursionException;
import com.bluecast.xml.Entity;
import com.bluecast.xml.XMLInputReader;
import com.bluecast.xml.XMLReaderReader;
import com.bluecast.xml.XMLStreamReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EntityManager {
    public static final int GENERAL = 0;
    public static final int PARAMETER = 1;
    private EntityResolver resolver;
    private Map[] entityMaps = new HashMap[]{new HashMap(), new HashMap()};
    private Map entitiesByURI = new HashMap();

    public EntityManager() {
        this(null);
    }

    public EntityManager(EntityResolver entityResolver) {
        this.setResolver(entityResolver);
    }

    public void setResolver(EntityResolver entityResolver) {
        this.resolver = entityResolver;
    }

    public EntityResolver getResolver() {
        return this.resolver;
    }

    public boolean putInternal(String string, String string2, int n) {
        if (this.entityMaps[n].get(string) == null) {
            this.entityMaps[n].put(string, new Entry(string2));
            return true;
        }
        return false;
    }

    public boolean putExternal(Entity entity, String string, String string2, String string3, int n) throws MalformedURLException {
        if (this.entityMaps[n].get(string) == null) {
            string3 = EntityManager.resolveSystemID(entity.getSystemID(), string3);
            Entry entry = new Entry(string2, string3);
            this.entityMaps[n].put(string, entry);
            if (string2 != null && string2.length() > 0) {
                this.entitiesByURI.put(string2, entry);
            }
            this.entitiesByURI.put(string3, entry);
            return true;
        }
        return false;
    }

    public boolean putUnparsed(Entity entity, String string, String string2, String string3, String string4, int n) throws MalformedURLException {
        if (this.entityMaps[n].get(string) == null) {
            this.entityMaps[n].put(string, new Entry(string2, string3, string4));
            return true;
        }
        return false;
    }

    public void clear() {
        this.entityMaps[0].clear();
        this.entityMaps[1].clear();
        this.entitiesByURI.clear();
    }

    public Entity getByName(String string, int n) {
        return (Entry)this.entityMaps[n].get(string);
    }

    public Entity getByID(Entity entity, String string, String string2) throws MalformedURLException {
        Entity entity2 = null;
        string2 = EntityManager.resolveSystemID(entity.getSystemID(), string2);
        entity2 = (Entity)this.entitiesByURI.get(string2);
        if (entity2 != null) {
            return entity2;
        }
        if (string != null && string.length() > 0 && (entity2 = (Entity)this.entitiesByURI.get(string)) != null) {
            return entity2;
        }
        entity2 = new Entry(string, string2);
        if (string != null && string.length() > 0) {
            this.entitiesByURI.put(string, entity2);
        }
        this.entitiesByURI.put(string2, entity2);
        return entity2;
    }

    public static String resolveSystemID(String string, String string2) throws MalformedURLException {
        URL uRL = string != null ? new URL(new URL(string), string2) : new URL(string2);
        return uRL.toString();
    }

    private final class Entry
    implements Entity {
        boolean isOpen = false;
        char[] value;
        String pubID;
        String sysID;
        String ndata;
        XMLInputReader reader = null;
        boolean isStandalone = false;

        Entry(String string) {
            this.ndata = null;
            this.sysID = null;
            this.pubID = null;
            this.value = string.toCharArray();
        }

        Entry(String string, String string2) {
            this(string, string2, null);
        }

        Entry(String string, String string2, String string3) {
            this.pubID = string;
            this.sysID = string2;
            this.ndata = string3;
        }

        public void open() throws RecursionException, SAXException, IOException {
            if (this.isOpen) {
                throw new RecursionException();
            }
            if (!this.isInternal()) {
                InputStream inputStream;
                InputSource inputSource;
                Reader reader;
                this.reader = EntityManager.this.resolver == null ? new XMLStreamReader(new URL(this.sysID).openStream(), true) : ((reader = (inputSource = EntityManager.this.resolver.resolveEntity(this.pubID, this.sysID)).getCharacterStream()) != null ? new XMLReaderReader(reader, true) : ((inputStream = inputSource.getByteStream()) != null ? new XMLStreamReader(inputStream, true) : new XMLStreamReader(new URL(this.sysID).openStream(), true)));
                this.isStandalone = this.reader.isXMLStandalone();
            }
            this.isOpen = true;
        }

        public boolean isOpen() {
            return this.isOpen;
        }

        public void close() {
            this.isOpen = false;
            this.reader = null;
        }

        public String getSystemID() {
            return this.sysID;
        }

        public String getPublicID() {
            return this.pubID;
        }

        public boolean isStandalone() {
            return this.isStandalone;
        }

        public void setStandalone(boolean bl) {
            this.isStandalone = bl;
        }

        public boolean isInternal() {
            return this.sysID == null;
        }

        public boolean isParsed() {
            return this.ndata == null;
        }

        public String getDeclaredEncoding() {
            if (this.reader != null) {
                return this.reader.getXMLDeclaredEncoding();
            }
            return null;
        }

        public boolean isStandaloneDeclared() {
            if (this.reader != null) {
                return this.reader.isXMLStandaloneDeclared();
            }
            return false;
        }

        public String getXMLVersion() {
            if (this.reader != null) {
                return this.reader.getXMLVersion();
            }
            return null;
        }

        public Reader getReader() {
            if (this.isInternal()) {
                return new CharArrayReader(this.value);
            }
            return this.reader;
        }

        public String stringValue() {
            return new String(this.value);
        }

        public char[] charArrayValue() {
            return this.value;
        }
    }
}

