/*
 * Decompiled with CFR 0.152.
 */
package com.bluecast.xml;

import com.bluecast.util.RecursionException;
import com.bluecast.xml.Entity;
import com.bluecast.xml.XMLInputReader;
import com.bluecast.xml.XMLReaderReader;
import com.bluecast.xml.XMLStreamReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import org.xml.sax.InputSource;

public class DocumentEntity
implements Entity {
    private boolean isOpen = false;
    private URL url = null;
    private String sysID = null;
    private InputSource source = null;
    private static URL defaultContext;
    private boolean isStandalone = false;
    private XMLStreamReader streamReader = null;
    private XMLReaderReader readerReader = null;
    private XMLInputReader activeReader = null;

    public DocumentEntity() {
    }

    public DocumentEntity(String string) throws IOException {
        this.reset(string);
    }

    public DocumentEntity(InputSource inputSource) throws IOException {
        this.reset(inputSource);
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void open() throws IOException, RecursionException {
        String string = null;
        if (this.source != null) {
            Reader reader = this.source.getCharacterStream();
            if (reader != null) {
                this.isOpen = true;
                if (this.readerReader == null) {
                    this.readerReader = new XMLReaderReader();
                }
                this.readerReader.reset(reader, true);
                this.isStandalone = this.readerReader.isXMLStandalone();
                this.activeReader = this.readerReader;
                return;
            }
            InputStream inputStream = this.source.getByteStream();
            if (inputStream != null) {
                if (this.streamReader == null) {
                    this.streamReader = new XMLStreamReader();
                }
                this.streamReader.reset(inputStream, this.source.getEncoding(), true);
                this.isOpen = true;
                this.isStandalone = this.streamReader.isXMLStandalone();
                this.activeReader = this.streamReader;
                return;
            }
            this.url = new URL(defaultContext, this.source.getSystemId());
            this.sysID = this.url.toString();
            string = this.source.getEncoding();
        }
        if (this.streamReader == null) {
            this.streamReader = new XMLStreamReader();
        }
        this.streamReader.reset(this.url.openStream(), string, true);
        this.isStandalone = this.streamReader.isXMLStandalone();
        this.activeReader = this.streamReader;
        this.isOpen = true;
    }

    public String getDeclaredEncoding() {
        return this.activeReader.getXMLDeclaredEncoding();
    }

    public boolean isStandaloneDeclared() {
        return this.activeReader.isXMLStandaloneDeclared();
    }

    public String getXMLVersion() {
        return this.activeReader.getXMLVersion();
    }

    public void reset(String string) throws IOException {
        this.close();
        this.isStandalone = false;
        this.source = null;
        try {
            this.url = new URL(defaultContext, string);
        }
        catch (MalformedURLException malformedURLException) {
            this.url = new File(string).toURL();
        }
        this.sysID = this.url.toString();
    }

    public void reset(InputSource inputSource) throws IOException {
        this.close();
        this.isStandalone = false;
        this.source = inputSource;
        this.sysID = inputSource.getSystemId();
        if (this.sysID != null) {
            try {
                this.url = new URL(defaultContext, this.sysID);
            }
            catch (MalformedURLException malformedURLException) {
                this.url = new File(this.sysID).toURL();
            }
            this.sysID = this.url.toString();
        }
    }

    public void close() throws IOException {
        if (!this.isOpen) {
            return;
        }
        this.source = null;
        this.activeReader.close();
        this.activeReader = null;
        this.isOpen = false;
    }

    public String getPublicID() {
        return null;
    }

    public String getSystemID() {
        return this.sysID;
    }

    public boolean isStandalone() {
        return this.isStandalone;
    }

    public void setStandalone(boolean bl) {
        this.isStandalone = bl;
    }

    public boolean isInternal() {
        return false;
    }

    public boolean isParsed() {
        return true;
    }

    public Reader getReader() {
        return this.activeReader;
    }

    public String stringValue() {
        throw new UnsupportedOperationException();
    }

    public char[] charArrayValue() {
        throw new UnsupportedOperationException();
    }

    static {
        try {
            defaultContext = new URL("file", null, ".");
        }
        catch (IOException iOException) {
            defaultContext = null;
        }
    }
}

