/*
 * Decompiled with CFR 0.152.
 */
package com.bluecast.util;

public final class IntStack {
    private int[] stack;
    private int pos;

    public IntStack(int n) {
        this.stack = new int[n];
        this.pos = -1;
    }

    public int pop() {
        if (this.pos >= 0) {
            return this.stack[this.pos--];
        }
        throw new ArrayIndexOutOfBoundsException("stack underflow");
    }

    public void push(int n) {
        if (this.pos + 1 < this.stack.length) {
            this.stack[++this.pos] = n;
        } else {
            this.setSize(this.stack.length * 2);
            this.stack[++this.pos] = n;
        }
    }

    public void setSize(int n) {
        if (n != this.stack.length) {
            int[] nArray = new int[n];
            System.arraycopy(this.stack, 0, nArray, 0, Math.min(this.stack.length, n));
            this.stack = nArray;
        }
    }

    public void clear() {
        this.pos = -1;
    }

    public int size() {
        return this.pos + 1;
    }
}

