/*
 * Decompiled with CFR 0.152.
 */
package com.bluecast.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;

public class FactoryServiceFinder {
    static final String SERVICE = "META-INF/services/";

    public static String findService(String string) throws IOException {
        InputStream inputStream = ClassLoader.getSystemClassLoader().getResourceAsStream(SERVICE + string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        return bufferedReader.readLine();
    }

    public static Enumeration findServices(String string) throws IOException {
        return new FactoryEnumeration(ClassLoader.getSystemClassLoader().getResources(string));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class FactoryEnumeration
    implements Enumeration {
        Enumeration enum;
        Object next = null;

        FactoryEnumeration(Enumeration enumeration) {
            this.enum = enumeration;
            this.nextElement();
        }

        public boolean hasMoreElements() {
            return this.next != null;
        }

        public Object nextElement() {
            Object object = this.next;
            while (true) {
                try {
                    if (this.enum.hasMoreElements()) {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((URL)this.enum.nextElement()).openStream()));
                        this.next = bufferedReader.readLine();
                        break;
                    }
                    this.next = null;
                }
                catch (IOException iOException) {
                    continue;
                }
                break;
            }
            return object;
        }
    }
}

