/*
 * Decompiled with CFR 0.152.
 */
package com.bluecast.util;

public final class CharStringConverter {
    private static final float DEFAULT_LOAD = 0.7f;
    private float loadFactor;
    private int numEntries = 0;
    private int maxEntries;
    private int hashmask;
    private char[][] keys;
    private String[] values;

    public CharStringConverter(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + n);
        }
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Illegal load factor: " + f);
        }
        int n2 = (int)((float)n / f);
        int n3 = 16;
        while (n3 < n2) {
            n3 <<= 1;
        }
        this.hashmask = n3 - 1;
        this.maxEntries = (int)((float)n3 * f);
        this.keys = new char[n3][];
        this.values = new String[n3];
        this.loadFactor = f;
    }

    public CharStringConverter() {
        this(0, 0.7f);
    }

    public CharStringConverter(int n) {
        this(n, 0.7f);
    }

    public int getCacheSize() {
        return this.numEntries;
    }

    public String convert(char[] cArray) {
        return this.convert(cArray, 0, cArray.length);
    }

    public String convert(char[] cArray, int n, int n2) {
        if (this.numEntries >= this.maxEntries) {
            this.rehash();
        }
        int n3 = CharStringConverter.hashKey(cArray, n, n2) & this.hashmask;
        char[] cArray2 = null;
        while ((cArray2 = this.keys[n3]) != null && !CharStringConverter.keysAreEqual(cArray2, 0, cArray2.length, cArray, n, n2)) {
            n3 = n3 - 1 & this.hashmask;
        }
        if (cArray2 != null) {
            return this.values[n3];
        }
        cArray2 = new char[n2];
        System.arraycopy(cArray, n, cArray2, 0, n2);
        String string = new String(cArray2).intern();
        this.keys[n3] = cArray2;
        this.values[n3] = string;
        ++this.numEntries;
        return string;
    }

    private void rehash() {
        int n = this.keys.length << 1;
        char[][] cArrayArray = new char[n][];
        String[] stringArray = new String[n];
        int n2 = n - 1;
        int n3 = 0;
        while (n3 < this.keys.length) {
            char[] cArray = this.keys[n3];
            String string = this.values[n3];
            if (cArray != null) {
                int n4 = CharStringConverter.hashKey(cArray, 0, cArray.length) & n2;
                char[] cArray2 = null;
                while ((cArray2 = cArrayArray[n4]) != null && !CharStringConverter.keysAreEqual(cArray2, 0, cArray2.length, cArray, 0, cArray.length)) {
                    n4 = n4 - 1 & n2;
                }
                cArrayArray[n4] = cArray;
                stringArray[n4] = string;
            }
            ++n3;
        }
        this.keys = cArrayArray;
        this.values = stringArray;
        this.maxEntries = (int)((float)n * this.loadFactor);
        this.hashmask = n2;
    }

    public void clearCache() {
        int n = 0;
        while (n < this.keys.length) {
            this.keys[n] = null;
            this.values[n] = null;
            ++n;
        }
        this.numEntries = 0;
    }

    private static final boolean keysAreEqual(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4) {
        if (n2 != n4) {
            return false;
        }
        int n5 = 0;
        while (n5 < n2) {
            if (cArray[n + n5] != cArray2[n3 + n5]) {
                return false;
            }
            ++n5;
        }
        return true;
    }

    private static final int hashKey(char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 = (n3 << 5) + cArray[n + n4];
            ++n4;
        }
        return n3;
    }
}

