/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.metric;

import ciir.umass.edu.learning.RankList;
import ciir.umass.edu.metric.DCGScorer;
import ciir.umass.edu.metric.MetricScorer;
import ciir.umass.edu.utilities.FileUtils;
import ciir.umass.edu.utilities.RankLibError;
import ciir.umass.edu.utilities.Sorter;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class NDCGScorer
extends DCGScorer {
    protected HashMap<String, Double> idealGains = new HashMap();

    public NDCGScorer() {
    }

    public NDCGScorer(int k) {
        super(k);
    }

    @Override
    public MetricScorer copy() {
        return new NDCGScorer();
    }

    @Override
    public void loadExternalRelevanceJudgment(String qrelFile) {
        try (BufferedReader in = FileUtils.smartReader(qrelFile);){
            String content = "";
            String lastQID = "";
            ArrayList<Integer> rel = new ArrayList<Integer>();
            int nQueries = 0;
            while ((content = in.readLine()) != null) {
                if ((content = content.trim()).length() == 0) continue;
                String[] s2 = content.split(" ");
                String qid = s2[0].trim();
                int label = (int)Math.rint(Double.parseDouble(s2[3].trim()));
                if (lastQID.compareTo("") != 0 && lastQID.compareTo(qid) != 0) {
                    int size = rel.size() > this.k ? this.k : rel.size();
                    int[] r = new int[rel.size()];
                    for (int i = 0; i < rel.size(); ++i) {
                        r[i] = (Integer)rel.get(i);
                    }
                    double ideal = this.getIdealDCG(r, size);
                    this.idealGains.put(lastQID, ideal);
                    rel.clear();
                    ++nQueries;
                }
                lastQID = qid;
                rel.add(label);
            }
            if (rel.size() > 0) {
                int size = rel.size() > this.k ? this.k : rel.size();
                int[] r = new int[rel.size()];
                for (int i = 0; i < rel.size(); ++i) {
                    r[i] = (Integer)rel.get(i);
                }
                double ideal = this.getIdealDCG(r, size);
                this.idealGains.put(lastQID, ideal);
                rel.clear();
                ++nQueries;
            }
            System.out.println("Relevance judgment file loaded. [#q=" + nQueries + "]");
        }
        catch (IOException ex) {
            throw RankLibError.create("Error in NDCGScorer::loadExternalRelevanceJudgment(): ", ex);
        }
    }

    @Override
    public double score(RankList rl) {
        if (rl.size() == 0) {
            return 0.0;
        }
        int size = this.k;
        if (this.k > rl.size() || this.k <= 0) {
            size = rl.size();
        }
        int[] rel = this.getRelevanceLabels(rl);
        double ideal = 0.0;
        Double d = this.idealGains.get(rl.getID());
        if (d != null) {
            ideal = d;
        } else {
            ideal = this.getIdealDCG(rel, size);
            this.idealGains.put(rl.getID(), ideal);
        }
        if (ideal <= 0.0) {
            return 0.0;
        }
        return this.getDCG(rel, size) / ideal;
    }

    @Override
    public double[][] swapChange(RankList rl) {
        int i;
        int size = rl.size() > this.k ? this.k : rl.size();
        int[] rel = this.getRelevanceLabels(rl);
        double ideal = 0.0;
        Double d = this.idealGains.get(rl.getID());
        ideal = d != null ? d.doubleValue() : this.getIdealDCG(rel, size);
        double[][] changes = new double[rl.size()][];
        for (i = 0; i < rl.size(); ++i) {
            changes[i] = new double[rl.size()];
            Arrays.fill(changes[i], 0.0);
        }
        for (i = 0; i < size; ++i) {
            for (int j = i + 1; j < rl.size(); ++j) {
                if (!(ideal > 0.0)) continue;
                double d2 = (this.discount(i) - this.discount(j)) * (this.gain(rel[i]) - this.gain(rel[j])) / ideal;
                changes[i][j] = d2;
                changes[j][i] = d2;
            }
        }
        return changes;
    }

    @Override
    public String name() {
        return "NDCG@" + this.k;
    }

    private double getIdealDCG(int[] rel, int topK) {
        int[] idx = Sorter.sort(rel, false);
        double dcg = 0.0;
        for (int i = 0; i < topK; ++i) {
            dcg += this.gain(rel[idx[i]]) * this.discount(i);
        }
        return dcg;
    }
}

