/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.metric;

import ciir.umass.edu.learning.RankList;
import ciir.umass.edu.metric.MetricScorer;
import java.util.ArrayList;
import java.util.Arrays;

public class ERRScorer
extends MetricScorer {
    public static double MAX = 16.0;

    public ERRScorer() {
        this.k = 10;
    }

    public ERRScorer(int k) {
        this.k = k;
    }

    @Override
    public ERRScorer copy() {
        return new ERRScorer();
    }

    @Override
    public double score(RankList rl) {
        int size = this.k;
        if (this.k > rl.size() || this.k <= 0) {
            size = rl.size();
        }
        ArrayList<Integer> rel = new ArrayList<Integer>();
        for (int i = 0; i < rl.size(); ++i) {
            rel.add((int)rl.get(i).getLabel());
        }
        double s2 = 0.0;
        double p = 1.0;
        for (int i = 1; i <= size; ++i) {
            double R = this.R((Integer)rel.get(i - 1));
            s2 += p * R / (double)i;
            p *= 1.0 - R;
        }
        return s2;
    }

    @Override
    public String name() {
        return "ERR@" + this.k;
    }

    private double R(int rel) {
        return (double)((1 << rel) - 1) / MAX;
    }

    @Override
    public double[][] swapChange(RankList rl) {
        int i;
        int size = rl.size() > this.k ? this.k : rl.size();
        int[] labels = new int[rl.size()];
        double[] R = new double[rl.size()];
        double[] np = new double[rl.size()];
        double p = 1.0;
        for (int i2 = 0; i2 < size; ++i2) {
            labels[i2] = (int)rl.get(i2).getLabel();
            R[i2] = this.R(labels[i2]);
            np[i2] = p * (1.0 - R[i2]);
            p *= np[i2];
        }
        double[][] changes = new double[rl.size()][];
        for (i = 0; i < rl.size(); ++i) {
            changes[i] = new double[rl.size()];
            Arrays.fill(changes[i], 0.0);
        }
        for (i = 0; i < size; ++i) {
            double v1 = 1.0 / (double)(i + 1) * (i == 0 ? 1.0 : np[i - 1]);
            double change = 0.0;
            for (int j = i + 1; j < rl.size(); ++j) {
                if (labels[i] == labels[j]) {
                    change = 0.0;
                } else {
                    change = v1 * (R[j] - R[i]);
                    p = (i == 0 ? 1.0 : np[i - 1]) * (R[i] - R[j]);
                    for (int k = i + 1; k < j; ++k) {
                        change += p * R[k] / (double)(1 + k);
                        p *= 1.0 - R[k];
                    }
                    change += (np[j - 1] * (1.0 - R[j]) * R[i] / (1.0 - R[i]) - np[j - 1] * R[j]) / (double)(j + 1);
                }
                double d = change;
                changes[i][j] = d;
                changes[j][i] = d;
            }
        }
        return changes;
    }
}

