/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.learning.tree;

import ciir.umass.edu.learning.DataPoint;
import ciir.umass.edu.learning.tree.FeatureHistogram;
import java.util.ArrayList;
import java.util.List;

public class Split {
    private int featureID = -1;
    private float threshold = 0.0f;
    private double avgLabel = 0.0;
    private boolean isRoot = false;
    private double sumLabel = 0.0;
    private double sqSumLabel = 0.0;
    private Split left = null;
    private Split right = null;
    private double deviance = 0.0;
    private int[][] sortedSampleIDs = null;
    public int[] samples = null;
    public FeatureHistogram hist = null;

    public Split() {
    }

    public Split(int featureID, float threshold, double deviance) {
        this.featureID = featureID;
        this.threshold = threshold;
        this.deviance = deviance;
    }

    public Split(int[][] sortedSampleIDs, double deviance, double sumLabel, double sqSumLabel) {
        this.sortedSampleIDs = sortedSampleIDs;
        this.deviance = deviance;
        this.sumLabel = sumLabel;
        this.sqSumLabel = sqSumLabel;
        this.avgLabel = sumLabel / (double)sortedSampleIDs[0].length;
    }

    public Split(int[] samples, FeatureHistogram hist, double deviance, double sumLabel) {
        this.samples = samples;
        this.hist = hist;
        this.deviance = deviance;
        this.sumLabel = sumLabel;
        this.avgLabel = sumLabel / (double)samples.length;
    }

    public void set(int featureID, float threshold, double deviance) {
        this.featureID = featureID;
        this.threshold = threshold;
        this.deviance = deviance;
    }

    public void setLeft(Split s2) {
        this.left = s2;
    }

    public void setRight(Split s2) {
        this.right = s2;
    }

    public void setOutput(float output) {
        this.avgLabel = output;
    }

    public Split getLeft() {
        return this.left;
    }

    public Split getRight() {
        return this.right;
    }

    public double getDeviance() {
        return this.deviance;
    }

    public double getOutput() {
        return this.avgLabel;
    }

    public List<Split> leaves() {
        ArrayList<Split> list = new ArrayList<Split>();
        this.leaves(list);
        return list;
    }

    private void leaves(List<Split> leaves) {
        if (this.featureID == -1) {
            leaves.add(this);
        } else {
            this.left.leaves(leaves);
            this.right.leaves(leaves);
        }
    }

    public double eval(DataPoint dp) {
        Split n = this;
        while (n.featureID != -1) {
            if (dp.getFeatureValue(n.featureID) <= n.threshold) {
                n = n.left;
                continue;
            }
            n = n.right;
        }
        return n.avgLabel;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        String strOutput = indent + "<split>\n";
        strOutput = strOutput + this.getString(indent + "\t");
        strOutput = strOutput + indent + "</split>\n";
        return strOutput;
    }

    public String getString(String indent) {
        String strOutput = "";
        if (this.featureID == -1) {
            strOutput = strOutput + indent + "<output> " + this.avgLabel + " </output>\n";
        } else {
            strOutput = strOutput + indent + "<feature> " + this.featureID + " </feature>\n";
            strOutput = strOutput + indent + "<threshold> " + this.threshold + " </threshold>\n";
            strOutput = strOutput + indent + "<split pos=\"left\">\n";
            strOutput = strOutput + this.left.getString(indent + "\t");
            strOutput = strOutput + indent + "</split>\n";
            strOutput = strOutput + indent + "<split pos=\"right\">\n";
            strOutput = strOutput + this.right.getString(indent + "\t");
            strOutput = strOutput + indent + "</split>\n";
        }
        return strOutput;
    }

    public boolean split(double[] trainingLabels, int minLeafSupport) {
        return this.hist.findBestSplit(this, trainingLabels, minLeafSupport);
    }

    public int[] getSamples() {
        if (this.sortedSampleIDs != null) {
            return this.sortedSampleIDs[0];
        }
        return this.samples;
    }

    public int[][] getSampleSortedIndex() {
        return this.sortedSampleIDs;
    }

    public double getSumLabel() {
        return this.sumLabel;
    }

    public double getSqSumLabel() {
        return this.sqSumLabel;
    }

    public void clearSamples() {
        this.sortedSampleIDs = null;
        this.samples = null;
        this.hist = null;
    }

    public void setRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    public boolean isRoot() {
        return this.isRoot;
    }
}

