/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.learning.tree;

import ciir.umass.edu.learning.DataPoint;
import ciir.umass.edu.learning.tree.FeatureHistogram;
import ciir.umass.edu.learning.tree.Split;
import java.util.ArrayList;
import java.util.List;

public class RegressionTree {
    protected int nodes = 10;
    protected int minLeafSupport = 1;
    protected Split root = null;
    protected List<Split> leaves = null;
    protected DataPoint[] trainingSamples = null;
    protected double[] trainingLabels = null;
    protected int[] features = null;
    protected float[][] thresholds = null;
    protected int[] index = null;
    protected FeatureHistogram hist = null;

    public RegressionTree(Split root) {
        this.root = root;
        this.leaves = root.leaves();
    }

    public RegressionTree(int nLeaves, DataPoint[] trainingSamples, double[] labels, FeatureHistogram hist, int minLeafSupport) {
        this.nodes = nLeaves;
        this.trainingSamples = trainingSamples;
        this.trainingLabels = labels;
        this.hist = hist;
        this.minLeafSupport = minLeafSupport;
        this.index = new int[trainingSamples.length];
        for (int i = 0; i < trainingSamples.length; ++i) {
            this.index[i] = i;
        }
    }

    public void fit() {
        ArrayList<Split> queue = new ArrayList<Split>();
        this.root = new Split(this.index, this.hist, 3.4028234663852886E38, 0.0);
        this.root.setRoot(true);
        if (this.root.split(this.trainingLabels, this.minLeafSupport)) {
            this.insert(queue, this.root.getLeft());
            this.insert(queue, this.root.getRight());
        }
        int taken = 0;
        while ((this.nodes == -1 || taken + queue.size() < this.nodes) && queue.size() > 0) {
            Split leaf = (Split)queue.get(0);
            queue.remove(0);
            if (leaf.getSamples().length < 2 * this.minLeafSupport) {
                ++taken;
                continue;
            }
            if (!leaf.split(this.trainingLabels, this.minLeafSupport)) {
                ++taken;
                continue;
            }
            this.insert(queue, leaf.getLeft());
            this.insert(queue, leaf.getRight());
        }
        this.leaves = this.root.leaves();
    }

    public double eval(DataPoint dp) {
        return this.root.eval(dp);
    }

    public List<Split> leaves() {
        return this.leaves;
    }

    public void clearSamples() {
        this.trainingSamples = null;
        this.trainingLabels = null;
        this.features = null;
        this.thresholds = null;
        this.index = null;
        this.hist = null;
        for (int i = 0; i < this.leaves.size(); ++i) {
            this.leaves.get(i).clearSamples();
        }
    }

    public String toString() {
        if (this.root != null) {
            return this.root.toString();
        }
        return "";
    }

    public String toString(String indent) {
        if (this.root != null) {
            return this.root.toString(indent);
        }
        return "";
    }

    public double variance() {
        double var = 0.0;
        for (int i = 0; i < this.leaves.size(); ++i) {
            var += this.leaves.get(i).getDeviance();
        }
        return var;
    }

    protected void insert(List<Split> ls, Split s2) {
        int i;
        for (i = 0; i < ls.size() && ls.get(i).getDeviance() > s2.getDeviance(); ++i) {
        }
        ls.add(i, s2);
    }
}

