/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.learning.neuralnet;

import ciir.umass.edu.learning.neuralnet.Neuron;
import ciir.umass.edu.learning.neuralnet.PropParameter;
import ciir.umass.edu.learning.neuralnet.Synapse;

public class ListNeuron
extends Neuron {
    protected double[] d1;
    protected double[] d2;

    @Override
    public void computeDelta(PropParameter param) {
        int i;
        double sumLabelExp = 0.0;
        double sumScoreExp = 0.0;
        for (i = 0; i < this.outputs.size(); ++i) {
            sumLabelExp += Math.exp(param.labels[i]);
            sumScoreExp += Math.exp((Double)this.outputs.get(i));
        }
        this.d1 = new double[this.outputs.size()];
        this.d2 = new double[this.outputs.size()];
        for (i = 0; i < this.outputs.size(); ++i) {
            this.d1[i] = Math.exp(param.labels[i]) / sumLabelExp;
            this.d2[i] = Math.exp((Double)this.outputs.get(i)) / sumScoreExp;
        }
    }

    @Override
    public void updateWeight(PropParameter param) {
        Synapse s2 = null;
        for (int k = 0; k < this.inLinks.size(); ++k) {
            s2 = (Synapse)this.inLinks.get(k);
            double dw = 0.0;
            for (int l = 0; l < this.d1.length; ++l) {
                dw += (this.d1[l] - this.d2[l]) * s2.getSource().getOutput(l);
            }
            s2.setWeightAdjustment(dw *= learningRate);
            s2.updateWeight();
        }
    }
}

