/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.learning;

import ciir.umass.edu.learning.DataPoint;
import ciir.umass.edu.utilities.RankLibError;
import java.util.Arrays;
import java.util.stream.IntStream;

public class SparseDataPoint
extends DataPoint {
    private static accessPattern searchPattern = accessPattern.RANDOM;
    int[] fIds;
    int lastMinId = -1;
    int lastMinPos = -1;

    public SparseDataPoint(String text) {
        super(text);
    }

    public SparseDataPoint(float[] fVals, int[] fIds, int numKnownFeatures, String queryId, float relevanceLabel) {
        this.fVals = fVals;
        this.fIds = fIds;
        this.knownFeatures = numKnownFeatures;
        this.id = queryId;
        this.label = relevanceLabel;
    }

    public SparseDataPoint(SparseDataPoint dp) {
        this.label = dp.label;
        this.id = dp.id;
        this.description = dp.description;
        this.cached = dp.cached;
        this.fIds = new int[dp.fIds.length];
        this.fVals = new float[dp.fVals.length];
        System.arraycopy(dp.fIds, 0, this.fIds, 0, dp.fIds.length);
        System.arraycopy(dp.fVals, 0, this.fVals, 0, dp.fVals.length);
    }

    private int locate(int fid) {
        if (searchPattern == accessPattern.SEQUENTIAL) {
            if (this.lastMinId > fid) {
                this.lastMinId = -1;
                this.lastMinPos = -1;
            }
            while (this.lastMinPos < this.knownFeatures && this.lastMinId < fid) {
                this.lastMinId = this.fIds[++this.lastMinPos];
            }
            if (this.lastMinId == fid) {
                return this.lastMinPos;
            }
        } else if (searchPattern == accessPattern.RANDOM) {
            int pos = Arrays.binarySearch(this.fIds, fid);
            if (pos >= 0) {
                return pos;
            }
        } else {
            System.err.println("Invalid search pattern specified for sparse data points.");
        }
        return -1;
    }

    public boolean hasFeature(int fid) {
        return this.locate(fid) != -1;
    }

    @Override
    public float getFeatureValue(int fid) {
        if (fid <= 0 || fid > this.knownFeatures) {
            if (missingZero) {
                return 0.0f;
            }
            throw RankLibError.create("Error in SparseDataPoint::getFeatureValue(): requesting unspecified feature, fid=" + fid);
        }
        int pos = this.locate(fid);
        if (pos >= 0) {
            return this.fVals[pos];
        }
        return 0.0f;
    }

    @Override
    public void setFeatureValue(int fid, float fval) {
        if (fid <= 0 || fid > this.knownFeatures) {
            throw RankLibError.create("Error in SparseDataPoint::setFeatureValue(): feature (id=" + fid + ") out of range.");
        }
        int pos = this.locate(fid);
        if (pos >= 0) {
            this.fVals[pos] = fval;
        } else {
            System.err.println("Error in SparseDataPoint::setFeatureValue(): feature (id=" + fid + ") not found.");
            System.exit(1);
        }
    }

    @Override
    public float[] getFeatureVector() {
        float[] dfVals = new float[this.knownFeatures + 1];
        Arrays.fill(dfVals, UNKNOWN);
        for (int i = 0; i < this.fIds.length; ++i) {
            dfVals[this.fIds[i]] = this.fVals[i];
        }
        return dfVals;
    }

    @Override
    public void setFeatureVector(float[] dfVals) {
        int numPresentFeatures = (int)IntStream.range(0, dfVals.length).mapToDouble(i -> dfVals[i]).filter(val -> !Double.isNaN(val) && val != 0.0).count();
        this.fIds = new int[numPresentFeatures];
        this.fVals = new float[numPresentFeatures];
        int pos = 0;
        for (int i2 = 1; i2 < dfVals.length; ++i2) {
            if (SparseDataPoint.isUnknown(dfVals[i2])) continue;
            this.fIds[pos] = i2;
            this.fVals[pos] = dfVals[i2];
            ++pos;
        }
        assert (pos == numPresentFeatures);
    }

    private static enum accessPattern {
        SEQUENTIAL,
        RANDOM;

    }
}

