/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.features;

import ciir.umass.edu.features.Normalizer;
import ciir.umass.edu.learning.DataPoint;
import ciir.umass.edu.learning.RankList;
import ciir.umass.edu.utilities.RankLibError;
import java.util.Arrays;

public class LinearNormalizer
extends Normalizer {
    @Override
    public void normalize(RankList rl) {
        if (rl.size() == 0) {
            throw RankLibError.create("Error in LinearNormalizor::normalize(): The input ranked list is empty");
        }
        int nFeature = this.numFeatures(rl);
        int[] fids = new int[nFeature];
        for (int i = 1; i <= nFeature; ++i) {
            fids[i - 1] = i;
        }
        this.normalize(rl, fids);
    }

    @Override
    public void normalize(RankList rl, int[] fids) {
        int j;
        DataPoint dp;
        int i;
        if (rl.size() == 0) {
            throw RankLibError.create("Error in LinearNormalizor::normalize(): The input ranked list is empty");
        }
        fids = this.removeDuplicateFeatures(fids);
        float[] min2 = new float[fids.length];
        float[] max = new float[fids.length];
        Arrays.fill(min2, Float.MAX_VALUE);
        Arrays.fill(max, Float.MIN_VALUE);
        for (i = 0; i < rl.size(); ++i) {
            dp = rl.get(i);
            for (j = 0; j < fids.length; ++j) {
                min2[j] = Math.min(min2[j], dp.getFeatureValue(fids[j]));
                max[j] = Math.max(max[j], dp.getFeatureValue(fids[j]));
            }
        }
        for (i = 0; i < rl.size(); ++i) {
            dp = rl.get(i);
            for (j = 0; j < fids.length; ++j) {
                if (max[j] > min2[j]) {
                    float value = (dp.getFeatureValue(fids[j]) - min2[j]) / (max[j] - min2[j]);
                    dp.setFeatureValue(fids[j], value);
                    continue;
                }
                dp.setFeatureValue(fids[j], 0.0f);
            }
        }
    }

    @Override
    public String name() {
        return "linear";
    }
}

