/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.features;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class FeatureStats {
    private String modelName;
    private String modelFileName;
    private File f;
    private BufferedReader br;

    protected FeatureStats(String modelFileName) {
        try {
            this.f = new File(modelFileName);
            this.modelFileName = this.f.getAbsolutePath();
            this.br = new BufferedReader(new FileReader(this.f));
            String modelLine = this.br.readLine().trim();
            String[] nameparts = modelLine.split(" ");
            int len = nameparts.length;
            if (len == 2) {
                this.modelName = nameparts[1].trim();
            } else if (len == 3) {
                this.modelName = nameparts[1].trim() + " " + nameparts[2].trim();
            }
        }
        catch (IOException ioex) {
            System.out.println("IOException opening model file " + modelFileName + ". Quitting.");
            System.exit(1);
        }
    }

    private TreeMap<Integer, Integer> getFeatureWeightFeatureFrequencies() {
        TreeMap<Integer, Integer> tm = new TreeMap<Integer, Integer>();
        try {
            String line = null;
            while ((line = this.br.readLine()) != null) {
                if ((line = line.trim().toLowerCase()).length() == 0 || line.contains("##")) continue;
                String[] featureLines = line.split(" ");
                int featureFreq = 0;
                for (int i = 0; i < featureLines.length; ++i) {
                    Integer featureID = Integer.valueOf(featureLines[i].split(":")[0]);
                    if (tm.containsKey(featureID)) {
                        featureFreq = tm.get(featureID);
                        tm.put(featureID, ++featureFreq);
                        continue;
                    }
                    tm.put(featureID, 1);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex.toString());
            System.exit(1);
        }
        return tm;
    }

    private TreeMap<Integer, Integer> getTreeFeatureFrequencies() {
        TreeMap<Integer, Integer> tm = new TreeMap<Integer, Integer>();
        try {
            String line = null;
            while ((line = this.br.readLine()) != null) {
                int quote2;
                if ((line = line.trim().toLowerCase()).length() == 0 || line.contains("##") || !line.contains("<feature>")) continue;
                int quote1 = line.indexOf(62, 0);
                String featureIdStr = line.substring(quote1 + 1, quote2 = line.indexOf(60, quote1 + 1));
                Integer featureID = Integer.valueOf(featureIdStr.trim());
                if (tm.containsKey(featureID)) {
                    int featureFreq = tm.get(featureID);
                    tm.put(featureID, ++featureFreq);
                    continue;
                }
                tm.put(featureID, 1);
            }
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex.toString());
            System.exit(1);
        }
        return tm;
    }

    public void writeFeatureStats() {
        int featureMin = Integer.MAX_VALUE;
        boolean featureMax = false;
        int featuresUsed = 0;
        boolean featureFreq = false;
        String modelName = this.modelName;
        TreeMap<Integer, Integer> featureTM = null;
        try {
            if (modelName == null) {
                System.out.println("No model name defined.  Quitting.");
                System.exit(1);
            }
            if (modelName.equals("Coordinate Ascent") || modelName.equals("LambdaRank") || modelName.equals("Linear Regression") || modelName.equals("ListNet") || modelName.equals("RankNet")) {
                System.out.println(modelName + " uses all features.  Can't do selected model statistics for this algorithm.");
                System.exit(0);
            } else if (modelName.equals("AdaRank") || modelName.equals("RankBoost")) {
                featureTM = this.getFeatureWeightFeatureFrequencies();
            } else if (modelName.equals("LambdaMART") || modelName.equals("MART") || modelName.equals("Random Forests")) {
                featureTM = this.getTreeFeatureFrequencies();
            }
            this.br.close();
        }
        catch (IOException ioe) {
            System.out.println("IOException on file " + this.modelFileName);
            System.exit(1);
        }
        featuresUsed = featureTM.size();
        System.out.println("\nModel File: " + this.modelFileName);
        System.out.println("Algorithm : " + modelName);
        System.out.println("");
        System.out.println("Feature frequencies : ");
        Set<Map.Entry<Integer, Integer>> s2 = featureTM.entrySet();
        DescriptiveStatistics ds = new DescriptiveStatistics();
        for (Map.Entry<Integer, Integer> e : s2) {
            int freqID = e.getKey();
            int freq = e.getValue();
            System.out.printf("\tFeature[%d] : %7d\n", freqID, freq);
            ds.addValue(freq);
        }
        System.out.println(" ");
        System.out.printf("Total Features Used: %d\n\n", featuresUsed);
        System.out.printf("Min frequency    : %10.2f\n", ds.getMin());
        System.out.printf("Max frequency    : %10.2f\n", ds.getMax());
        System.out.printf("Median frequency : %10.2f\n", ds.getPercentile(50.0));
        System.out.printf("Avg frequency    : %10.2f\n", ds.getMean());
        System.out.printf("Variance         : %10.2f\n", ds.getVariance());
        System.out.printf("STD              : %10.2f\n", ds.getStandardDeviation());
    }
}

