/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.eval;

import ciir.umass.edu.features.FeatureManager;
import ciir.umass.edu.features.LinearNormalizer;
import ciir.umass.edu.features.Normalizer;
import ciir.umass.edu.features.SumNormalizor;
import ciir.umass.edu.features.ZScoreNormalizor;
import ciir.umass.edu.learning.CoorAscent;
import ciir.umass.edu.learning.DataPoint;
import ciir.umass.edu.learning.LinearRegRank;
import ciir.umass.edu.learning.RANKER_TYPE;
import ciir.umass.edu.learning.RankList;
import ciir.umass.edu.learning.Ranker;
import ciir.umass.edu.learning.RankerFactory;
import ciir.umass.edu.learning.RankerTrainer;
import ciir.umass.edu.learning.boosting.AdaRank;
import ciir.umass.edu.learning.boosting.RankBoost;
import ciir.umass.edu.learning.neuralnet.ListNet;
import ciir.umass.edu.learning.neuralnet.Neuron;
import ciir.umass.edu.learning.neuralnet.RankNet;
import ciir.umass.edu.learning.tree.LambdaMART;
import ciir.umass.edu.learning.tree.RFRanker;
import ciir.umass.edu.metric.ERRScorer;
import ciir.umass.edu.metric.METRIC;
import ciir.umass.edu.metric.MetricScorer;
import ciir.umass.edu.metric.MetricScorerFactory;
import ciir.umass.edu.utilities.FileUtils;
import ciir.umass.edu.utilities.MergeSorter;
import ciir.umass.edu.utilities.MyThreadPool;
import ciir.umass.edu.utilities.RankLibError;
import ciir.umass.edu.utilities.SimpleMath;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class Evaluator {
    public static boolean mustHaveRelDoc = false;
    public static boolean useSparseRepresentation = false;
    public static boolean normalize = false;
    public static Normalizer nml = new SumNormalizor();
    public static String modelFile = "";
    public static String qrelFile = "";
    public static String newFeatureFile = "";
    public static boolean keepOrigFeatures = false;
    public static int topNew = 2000;
    protected RankerFactory rFact = new RankerFactory();
    protected MetricScorerFactory mFact = new MetricScorerFactory();
    protected MetricScorer trainScorer = null;
    protected MetricScorer testScorer = null;
    protected RANKER_TYPE type = RANKER_TYPE.MART;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        String[] rType = new String[]{"MART", "RankNet", "RankBoost", "AdaRank", "Coordinate Ascent", "LambdaRank", "LambdaMART", "ListNet", "Random Forests", "Linear Regression"};
        RANKER_TYPE[] rType2 = new RANKER_TYPE[]{RANKER_TYPE.MART, RANKER_TYPE.RANKNET, RANKER_TYPE.RANKBOOST, RANKER_TYPE.ADARANK, RANKER_TYPE.COOR_ASCENT, RANKER_TYPE.LAMBDARANK, RANKER_TYPE.LAMBDAMART, RANKER_TYPE.LISTNET, RANKER_TYPE.RANDOM_FOREST, RANKER_TYPE.LINEAR_REGRESSION};
        String trainFile = "";
        String featureDescriptionFile = "";
        float ttSplit = 0.0f;
        float tvSplit = 0.0f;
        int foldCV = -1;
        String validationFile = "";
        String testFile = "";
        ArrayList<String> testFiles = new ArrayList<String>();
        int rankerType = 4;
        String trainMetric = "ERR@10";
        String testMetric = "";
        normalize = false;
        String savedModelFile = "";
        ArrayList<String> savedModelFiles = new ArrayList<String>();
        String kcvModelDir = "";
        String kcvModelFile = "";
        String rankFile = "";
        String prpFile = "";
        int nThread = -1;
        String indriRankingFile = "";
        String scoreFile = "";
        if (args.length < 2) {
            System.out.println("Usage: java -jar RankLib.jar <Params>");
            System.out.println("Params:");
            System.out.println("  [+] Training (+ tuning and evaluation)");
            System.out.println("\t-train <file>\t\tTraining data");
            System.out.println("\t-ranker <type>\t\tSpecify which ranking algorithm to use");
            System.out.println("\t\t\t\t0: MART (gradient boosted regression tree)");
            System.out.println("\t\t\t\t1: RankNet");
            System.out.println("\t\t\t\t2: RankBoost");
            System.out.println("\t\t\t\t3: AdaRank");
            System.out.println("\t\t\t\t4: Coordinate Ascent");
            System.out.println("\t\t\t\t6: LambdaMART");
            System.out.println("\t\t\t\t7: ListNet");
            System.out.println("\t\t\t\t8: Random Forests");
            System.out.println("\t\t\t\t9: Linear regression (L2 regularization)");
            System.out.println("\t[ -feature <file> ]\tFeature description file: list features to be considered by the learner, each on a separate line");
            System.out.println("\t\t\t\tIf not specified, all features will be used.");
            System.out.println("\t[ -metric2t <metric> ]\tMetric to optimize on the training data.  Supported: MAP, NDCG@k, DCG@k, P@k, RR@k, ERR@k (default=" + trainMetric + ")");
            System.out.println("\t[ -gmax <label> ]\tHighest judged relevance label. It affects the calculation of ERR (default=" + (int)SimpleMath.logBase2(ERRScorer.MAX) + ", i.e. 5-point scale {0,1,2,3,4})");
            System.out.println("\t[ -qrel <file> ]\tTREC-style relevance judgment file. It only affects MAP and NDCG (default=unspecified)");
            System.out.println("\t[ -silent ]\t\tDo not print progress messages (which are printed by default)");
            System.out.println("\t[ -missingZero ]\tSubstitute zero for missing feature values rather than throwing an exception.");
            System.out.println("");
            System.out.println("\t[ -validate <file> ]\tSpecify if you want to tune your system on the validation data (default=unspecified)");
            System.out.println("\t\t\t\tIf specified, the final model will be the one that performs best on the validation data");
            System.out.println("\t[ -tvs <x \\in [0..1]> ]\tIf you don't have separate validation data, use this to set train-validation split to be (x)(1.0-x)");
            System.out.println("\t[ -save <model> ]\tSave the model learned (default=not-save)");
            System.out.println("");
            System.out.println("\t[ -test <file> ]\tSpecify if you want to evaluate the trained model on this data (default=unspecified)");
            System.out.println("\t[ -tts <x \\in [0..1]> ]\tSet train-test split to be (x)(1.0-x). -tts will override -tvs");
            System.out.println("\t[ -metric2T <metric> ]\tMetric to evaluate on the test data (default to the same as specified for -metric2t)");
            System.out.println("");
            System.out.println("\t[ -norm <method>]\tNormalize all feature vectors (default=no-normalization). Method can be:");
            System.out.println("\t\t\t\tsum: normalize each feature by the sum of all its values");
            System.out.println("\t\t\t\tzscore: normalize each feature by its mean/standard deviation");
            System.out.println("\t\t\t\tlinear: normalize each feature by its min/max values");
            System.out.println("");
            System.out.println("\t[ -kcv <k> ]\t\tSpecify if you want to perform k-fold cross validation using the specified training data (default=NoCV)");
            System.out.println("\t\t\t\t-tvs can be used to further reserve a portion of the training data in each fold for validation");
            System.out.println("\t[ -kcvmd <dir> ]\tDirectory for models trained via cross-validation (default=not-save)");
            System.out.println("\t[ -kcvmn <model> ]\tName for model learned in each fold. It will be prefix-ed with the fold-number (default=empty)");
            System.out.println("");
            System.out.println("    [-] RankNet-specific parameters");
            System.out.println("\t[ -epoch <T> ]\t\tThe number of epochs to train (default=" + RankNet.nIteration + ")");
            System.out.println("\t[ -layer <layer> ]\tThe number of hidden layers (default=" + RankNet.nHiddenLayer + ")");
            System.out.println("\t[ -node <node> ]\tThe number of hidden nodes per layer (default=" + RankNet.nHiddenNodePerLayer + ")");
            System.out.println("\t[ -lr <rate> ]\t\tLearning rate (default=" + new DecimalFormat("###.########").format(RankNet.learningRate) + ")");
            System.out.println("");
            System.out.println("    [-] RankBoost-specific parameters");
            System.out.println("\t[ -round <T> ]\t\tThe number of rounds to train (default=" + RankBoost.nIteration + ")");
            System.out.println("\t[ -tc <k> ]\t\tNumber of threshold candidates to search. -1 to use all feature values (default=" + RankBoost.nThreshold + ")");
            System.out.println("");
            System.out.println("    [-] AdaRank-specific parameters");
            System.out.println("\t[ -round <T> ]\t\tThe number of rounds to train (default=" + AdaRank.nIteration + ")");
            System.out.println("\t[ -noeq ]\t\tTrain without enqueuing too-strong features (default=unspecified)");
            System.out.println("\t[ -tolerance <t> ]\tTolerance between two consecutive rounds of learning (default=" + AdaRank.tolerance + ")");
            System.out.println("\t[ -max <times> ]\tThe maximum number of times a feature can be consecutively selected without changing performance (default=" + AdaRank.maxSelCount + ")");
            System.out.println("");
            System.out.println("    [-] Coordinate Ascent-specific parameters");
            System.out.println("\t[ -r <k> ]\t\tThe number of random restarts (default=" + CoorAscent.nRestart + ")");
            System.out.println("\t[ -i <iteration> ]\tThe number of iterations to search in each dimension (default=" + CoorAscent.nMaxIteration + ")");
            System.out.println("\t[ -tolerance <t> ]\tPerformance tolerance between two solutions (default=" + CoorAscent.tolerance + ")");
            System.out.println("\t[ -reg <slack> ]\tRegularization parameter (default=no-regularization)");
            System.out.println("");
            System.out.println("    [-] {MART, LambdaMART}-specific parameters");
            System.out.println("\t[ -tree <t> ]\t\tNumber of trees (default=" + LambdaMART.nTrees + ")");
            System.out.println("\t[ -leaf <l> ]\t\tNumber of leaves for each tree (default=" + LambdaMART.nTreeLeaves + ")");
            System.out.println("\t[ -shrinkage <factor> ]\tShrinkage, or learning rate (default=" + LambdaMART.learningRate + ")");
            System.out.println("\t[ -tc <k> ]\t\tNumber of threshold candidates for tree spliting. -1 to use all feature values (default=" + LambdaMART.nThreshold + ")");
            System.out.println("\t[ -mls <n> ]\t\tMin leaf support -- minimum % of docs each leaf has to contain (default=" + LambdaMART.minLeafSupport + ")");
            System.out.println("\t[ -estop <e> ]\t\tStop early when no improvement is observed on validaton data in e consecutive rounds (default=" + LambdaMART.nRoundToStopEarly + ")");
            System.out.println("");
            System.out.println("    [-] ListNet-specific parameters");
            System.out.println("\t[ -epoch <T> ]\t\tThe number of epochs to train (default=" + ListNet.nIteration + ")");
            System.out.println("\t[ -lr <rate> ]\t\tLearning rate (default=" + new DecimalFormat("###.########").format(ListNet.learningRate) + ")");
            System.out.println("");
            System.out.println("    [-] Random Forests-specific parameters");
            System.out.println("\t[ -bag <r> ]\t\tNumber of bags (default=" + RFRanker.nBag + ")");
            System.out.println("\t[ -srate <r> ]\t\tSub-sampling rate (default=" + RFRanker.subSamplingRate + ")");
            System.out.println("\t[ -frate <r> ]\t\tFeature sampling rate (default=" + RFRanker.featureSamplingRate + ")");
            int type = RFRanker.rType.ordinal() - RANKER_TYPE.MART.ordinal();
            System.out.println("\t[ -rtype <type> ]\tRanker to bag (default=" + type + ", i.e. " + rType[type] + ")");
            System.out.println("\t[ -tree <t> ]\t\tNumber of trees in each bag (default=" + RFRanker.nTrees + ")");
            System.out.println("\t[ -leaf <l> ]\t\tNumber of leaves for each tree (default=" + RFRanker.nTreeLeaves + ")");
            System.out.println("\t[ -shrinkage <factor> ]\tShrinkage, or learning rate (default=" + RFRanker.learningRate + ")");
            System.out.println("\t[ -tc <k> ]\t\tNumber of threshold candidates for tree spliting. -1 to use all feature values (default=" + RFRanker.nThreshold + ")");
            System.out.println("\t[ -mls <n> ]\t\tMin leaf support -- minimum % of docs each leaf has to contain (default=" + RFRanker.minLeafSupport + ")");
            System.out.println("");
            System.out.println("    [-] Linear Regression-specific parameters");
            System.out.println("\t[ -L2 <reg> ]\t\tL2 regularization parameter (default=" + LinearRegRank.lambda + ")");
            System.out.println("");
            System.out.println("  [+] Testing previously saved models");
            System.out.println("\t-load <model>\t\tThe model to load");
            System.out.println("\t\t\t\tMultiple -load can be used to specify models from multiple folds (in increasing order),");
            System.out.println("\t\t\t\t  in which case the test/rank data will be partitioned accordingly.");
            System.out.println("\t-test <file>\t\tTest data to evaluate the model(s) (specify either this or -rank but not both)");
            System.out.println("\t-rank <file>\t\tRank the samples in the specified file (specify either this or -test but not both)");
            System.out.println("\t[ -metric2T <metric> ]\tMetric to evaluate on the test data (default=" + trainMetric + ")");
            System.out.println("\t[ -gmax <label> ]\tHighest judged relevance label. It affects the calculation of ERR (default=" + (int)SimpleMath.logBase2(ERRScorer.MAX) + ", i.e. 5-point scale {0,1,2,3,4})");
            System.out.println("\t[ -score <file>]\tStore ranker's score for each object being ranked (has to be used with -rank)");
            System.out.println("\t[ -qrel <file> ]\tTREC-style relevance judgment file. It only affects MAP and NDCG (default=unspecified)");
            System.out.println("\t[ -idv <file> ]\t\tSave model performance (in test metric) on individual ranked lists (has to be used with -test)");
            System.out.println("\t[ -norm ]\t\tNormalize feature vectors (similar to -norm for training/tuning)");
            System.out.println("");
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-train")) {
                trainFile = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-ranker")) {
                rankerType = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-feature")) {
                featureDescriptionFile = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-metric2t")) {
                trainMetric = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-metric2T")) {
                testMetric = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-gmax")) {
                ERRScorer.MAX = Math.pow(2.0, Double.parseDouble(args[++i]));
                continue;
            }
            if (args[i].equalsIgnoreCase("-qrel")) {
                qrelFile = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-tts")) {
                ttSplit = Float.parseFloat(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-tvs")) {
                tvSplit = Float.parseFloat(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-kcv")) {
                foldCV = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-validate")) {
                validationFile = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-test")) {
                testFile = args[++i];
                testFiles.add(testFile);
                continue;
            }
            if (args[i].equalsIgnoreCase("-norm")) {
                String n;
                normalize = true;
                if ((n = args[++i]).equalsIgnoreCase("sum")) {
                    nml = new SumNormalizor();
                    continue;
                }
                if (n.equalsIgnoreCase("zscore")) {
                    nml = new ZScoreNormalizor();
                    continue;
                }
                if (!n.equalsIgnoreCase("linear")) throw RankLibError.create("Unknown normalizor: " + n);
                nml = new LinearNormalizer();
                continue;
            }
            if (args[i].equalsIgnoreCase("-sparse")) {
                useSparseRepresentation = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-save")) {
                modelFile = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-kcvmd")) {
                kcvModelDir = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-kcvmn")) {
                kcvModelFile = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-silent")) {
                Ranker.verbose = false;
                continue;
            }
            if (args[i].equalsIgnoreCase("-missingZero")) {
                DataPoint.missingZero = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-load")) {
                savedModelFile = args[++i];
                savedModelFiles.add(args[i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-idv")) {
                prpFile = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-rank")) {
                rankFile = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-score")) {
                scoreFile = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-epoch")) {
                RankNet.nIteration = Integer.parseInt(args[++i]);
                ListNet.nIteration = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-layer")) {
                RankNet.nHiddenLayer = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-node")) {
                RankNet.nHiddenNodePerLayer = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-lr")) {
                RankNet.learningRate = Double.parseDouble(args[++i]);
                ListNet.learningRate = Neuron.learningRate;
                continue;
            }
            if (args[i].equalsIgnoreCase("-tc")) {
                RankBoost.nThreshold = Integer.parseInt(args[++i]);
                LambdaMART.nThreshold = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-noeq")) {
                AdaRank.trainWithEnqueue = false;
                continue;
            }
            if (args[i].equalsIgnoreCase("-max")) {
                AdaRank.maxSelCount = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-r")) {
                CoorAscent.nRestart = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-i")) {
                CoorAscent.nMaxIteration = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-round")) {
                RankBoost.nIteration = Integer.parseInt(args[++i]);
                AdaRank.nIteration = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-reg")) {
                CoorAscent.slack = Double.parseDouble(args[++i]);
                CoorAscent.regularized = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-tolerance")) {
                AdaRank.tolerance = Double.parseDouble(args[++i]);
                CoorAscent.tolerance = Double.parseDouble(args[i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-tree")) {
                LambdaMART.nTrees = Integer.parseInt(args[++i]);
                RFRanker.nTrees = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-leaf")) {
                LambdaMART.nTreeLeaves = Integer.parseInt(args[++i]);
                RFRanker.nTreeLeaves = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-shrinkage")) {
                LambdaMART.learningRate = Float.parseFloat(args[++i]);
                RFRanker.learningRate = Float.parseFloat(args[i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-mls")) {
                RFRanker.minLeafSupport = LambdaMART.minLeafSupport = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-estop")) {
                LambdaMART.nRoundToStopEarly = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-gcc")) {
                LambdaMART.gcCycle = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-bag")) {
                RFRanker.nBag = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-srate")) {
                RFRanker.subSamplingRate = Float.parseFloat(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-frate")) {
                RFRanker.featureSamplingRate = Float.parseFloat(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-rtype")) {
                int rt;
                if ((rt = Integer.parseInt(args[++i])) != 0 && rt != 6) throw RankLibError.create(rType[rt] + " cannot be bagged. Random Forests only supports MART/LambdaMART.");
                RFRanker.rType = rType2[rt];
                continue;
            }
            if (args[i].equalsIgnoreCase("-L2")) {
                LinearRegRank.lambda = Double.parseDouble(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-thread")) {
                nThread = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-nf")) {
                newFeatureFile = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-keep")) {
                keepOrigFeatures = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-t")) {
                topNew = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-indri")) {
                indriRankingFile = args[++i];
                continue;
            }
            if (!args[i].equalsIgnoreCase("-hr")) throw RankLibError.create("Unknown command-line parameter: " + args[i]);
            mustHaveRelDoc = true;
        }
        if (nThread == -1) {
            nThread = Runtime.getRuntime().availableProcessors();
        }
        MyThreadPool.init(nThread);
        if (testMetric.compareTo("") == 0) {
            testMetric = trainMetric;
        }
        System.out.println("");
        System.out.println(keepOrigFeatures ? "Keep orig. features" : "Discard orig. features");
        Evaluator e = new Evaluator(rType2[rankerType], trainMetric, testMetric);
        if (trainFile.compareTo("") != 0) {
            System.out.println("Training data:\t" + trainFile);
            if (foldCV != -1) {
                System.out.println("Cross validation: " + foldCV + " folds.");
                if (tvSplit > 0.0f) {
                    System.out.println("Train-Validation split: " + tvSplit);
                }
            } else {
                if (testFile.compareTo("") != 0) {
                    System.out.println("Test data:\t" + testFile);
                } else if (ttSplit > 0.0f) {
                    System.out.println("Train-Test split: " + ttSplit);
                }
                if (validationFile.compareTo("") != 0) {
                    System.out.println("Validation data:\t" + validationFile);
                } else if (ttSplit <= 0.0f && tvSplit > 0.0f) {
                    System.out.println("Train-Validation split: " + tvSplit);
                }
            }
            System.out.println("Feature vector representation: " + (useSparseRepresentation ? "Sparse" : "Dense") + ".");
            System.out.println("Ranking method:\t" + rType[rankerType]);
            if (featureDescriptionFile.compareTo("") != 0) {
                System.out.println("Feature description file:\t" + featureDescriptionFile);
            } else {
                System.out.println("Feature description file:\tUnspecified. All features will be used.");
            }
            System.out.println("Train metric:\t" + trainMetric);
            System.out.println("Test metric:\t" + testMetric);
            if (trainMetric.toUpperCase().startsWith("ERR") || testMetric.toUpperCase().startsWith("ERR")) {
                System.out.println("Highest relevance label (to compute ERR): " + (int)SimpleMath.logBase2(ERRScorer.MAX));
            }
            if (qrelFile.compareTo("") != 0) {
                System.out.println("TREC-format relevance judgment (only affects MAP and NDCG scores): " + qrelFile);
            }
            System.out.println("Feature normalization: " + (normalize ? nml.name() : "No"));
            if (kcvModelDir.compareTo("") != 0) {
                System.out.println("Models directory: " + kcvModelDir);
            }
            if (kcvModelFile.compareTo("") != 0) {
                System.out.println("Models' name: " + kcvModelFile);
            }
            if (modelFile.compareTo("") != 0) {
                System.out.println("Model file: " + modelFile);
            }
            System.out.println("");
            System.out.println("[+] " + rType[rankerType] + "'s Parameters:");
            RankerFactory rf = new RankerFactory();
            rf.createRanker(rType2[rankerType]).printParameters();
            System.out.println("");
            if (foldCV != -1) {
                if (kcvModelDir.compareTo("") != 0 && kcvModelFile.compareTo("") == 0) {
                    kcvModelFile = "kcv";
                } else if (kcvModelDir.compareTo("") == 0 && kcvModelFile.compareTo("") != 0) {
                    kcvModelDir = "kcvmodels";
                }
                e.evaluate(trainFile, featureDescriptionFile, foldCV, tvSplit, kcvModelDir, kcvModelFile);
            } else if ((double)ttSplit > 0.0) {
                e.evaluate(trainFile, validationFile, featureDescriptionFile, ttSplit);
            } else if ((double)tvSplit > 0.0) {
                e.evaluate(trainFile, tvSplit, testFile, featureDescriptionFile);
            } else {
                e.evaluate(trainFile, validationFile, testFile, featureDescriptionFile);
            }
        } else {
            System.out.println("Model file:\t" + savedModelFile);
            System.out.println("Feature normalization: " + (normalize ? nml.name() : "No"));
            if (rankFile.compareTo("") != 0) {
                if (scoreFile.compareTo("") != 0) {
                    if (savedModelFiles.size() > 1) {
                        e.score(savedModelFiles, rankFile, scoreFile);
                    } else {
                        e.score(savedModelFile, rankFile, scoreFile);
                    }
                } else {
                    if (indriRankingFile.compareTo("") == 0) throw RankLibError.create("This function has been removed.\nConsider using -score in addition to your current parameters, and do the ranking yourself based on these scores.");
                    if (savedModelFiles.size() > 1) {
                        e.rank(savedModelFiles, rankFile, indriRankingFile);
                    } else if (savedModelFiles.size() == 1) {
                        e.rank(savedModelFile, rankFile, indriRankingFile);
                    } else {
                        e.rank(rankFile, indriRankingFile);
                    }
                }
            } else {
                System.out.println("Test metric:\t" + testMetric);
                if (testMetric.startsWith("ERR")) {
                    System.out.println("Highest relevance label (to compute ERR): " + (int)SimpleMath.logBase2(ERRScorer.MAX));
                }
                if (savedModelFile.compareTo("") != 0) {
                    if (savedModelFiles.size() > 1) {
                        if (testFiles.size() > 1) {
                            e.test(savedModelFiles, testFiles, prpFile);
                        } else {
                            e.test(savedModelFiles, testFile, prpFile);
                        }
                    } else if (savedModelFiles.size() == 1) {
                        e.test(savedModelFile, testFile, prpFile);
                    }
                } else if (scoreFile.compareTo("") != 0) {
                    e.testWithScoreFile(testFile, scoreFile);
                } else {
                    e.test(testFile, prpFile);
                }
            }
        }
        MyThreadPool.getInstance().shutdown();
    }

    public Evaluator(RANKER_TYPE rType, METRIC trainMetric, METRIC testMetric) {
        this.type = rType;
        this.trainScorer = this.mFact.createScorer(trainMetric);
        this.testScorer = this.mFact.createScorer(testMetric);
        if (qrelFile.compareTo("") != 0) {
            this.trainScorer.loadExternalRelevanceJudgment(qrelFile);
            this.testScorer.loadExternalRelevanceJudgment(qrelFile);
        }
    }

    public Evaluator(RANKER_TYPE rType, METRIC trainMetric, int trainK, METRIC testMetric, int testK) {
        this.type = rType;
        this.trainScorer = this.mFact.createScorer(trainMetric, trainK);
        this.testScorer = this.mFact.createScorer(testMetric, testK);
        if (qrelFile.compareTo("") != 0) {
            this.trainScorer.loadExternalRelevanceJudgment(qrelFile);
            this.testScorer.loadExternalRelevanceJudgment(qrelFile);
        }
    }

    public Evaluator(RANKER_TYPE rType, METRIC trainMetric, METRIC testMetric, int k) {
        this.type = rType;
        this.trainScorer = this.mFact.createScorer(trainMetric, k);
        this.testScorer = this.mFact.createScorer(testMetric, k);
        if (qrelFile.compareTo("") != 0) {
            this.trainScorer.loadExternalRelevanceJudgment(qrelFile);
            this.testScorer.loadExternalRelevanceJudgment(qrelFile);
        }
    }

    public Evaluator(RANKER_TYPE rType, METRIC metric, int k) {
        this.type = rType;
        this.trainScorer = this.mFact.createScorer(metric, k);
        if (qrelFile.compareTo("") != 0) {
            this.trainScorer.loadExternalRelevanceJudgment(qrelFile);
        }
        this.testScorer = this.trainScorer;
    }

    public Evaluator(RANKER_TYPE rType, String trainMetric, String testMetric) {
        this.type = rType;
        this.trainScorer = this.mFact.createScorer(trainMetric);
        this.testScorer = this.mFact.createScorer(testMetric);
        if (qrelFile.compareTo("") != 0) {
            this.trainScorer.loadExternalRelevanceJudgment(qrelFile);
            this.testScorer.loadExternalRelevanceJudgment(qrelFile);
        }
    }

    public List<RankList> readInput(String inputFile) {
        return FeatureManager.readInput(inputFile, mustHaveRelDoc, useSparseRepresentation);
    }

    public void normalize(List<RankList> samples) {
        for (RankList sample : samples) {
            nml.normalize(sample);
        }
    }

    public void normalize(List<RankList> samples, int[] fids) {
        for (RankList sample : samples) {
            nml.normalize(sample, fids);
        }
    }

    public void normalizeAll(List<List<RankList>> samples, int[] fids) {
        for (List<RankList> sample : samples) {
            this.normalize(sample, fids);
        }
    }

    public int[] readFeature(String featureDefFile) {
        if (featureDefFile.isEmpty()) {
            return null;
        }
        return FeatureManager.readFeature(featureDefFile);
    }

    public double evaluate(Ranker ranker, List<RankList> rl) {
        List<RankList> l = rl;
        if (ranker != null) {
            l = ranker.rank(rl);
        }
        return this.testScorer.score(l);
    }

    public void evaluate(String trainFile, String validationFile, String testFile, String featureDefFile) {
        int[] features;
        List<RankList> train = this.readInput(trainFile);
        List<RankList> validation = null;
        if (!validationFile.isEmpty()) {
            validation = this.readInput(validationFile);
        }
        List<RankList> test = null;
        if (!testFile.isEmpty()) {
            test = this.readInput(testFile);
        }
        if ((features = this.readFeature(featureDefFile)) == null) {
            features = FeatureManager.getFeatureFromSampleVector(train);
        }
        if (normalize) {
            this.normalize(train, features);
            if (validation != null) {
                this.normalize(validation, features);
            }
            if (test != null) {
                this.normalize(test, features);
            }
        }
        RankerTrainer trainer = new RankerTrainer();
        Ranker ranker = trainer.train(this.type, train, validation, features, this.trainScorer);
        if (test != null) {
            double rankScore = this.evaluate(ranker, test);
            System.out.println(this.testScorer.name() + " on test data: " + SimpleMath.round(rankScore, 4));
        }
        if (modelFile.compareTo("") != 0) {
            System.out.println("");
            ranker.save(modelFile);
            System.out.println("Model saved to: " + modelFile);
        }
    }

    public void evaluate(String sampleFile, String validationFile, String featureDefFile, double percentTrain) {
        ArrayList<RankList> trainingData = new ArrayList<RankList>();
        ArrayList<RankList> testData = new ArrayList<RankList>();
        int[] features = this.prepareSplit(sampleFile, featureDefFile, percentTrain, normalize, trainingData, testData);
        List<RankList> validation = null;
        if (!validationFile.isEmpty()) {
            validation = this.readInput(validationFile);
            if (normalize) {
                this.normalize(validation, features);
            }
        }
        RankerTrainer trainer = new RankerTrainer();
        Ranker ranker = trainer.train(this.type, trainingData, validation, features, this.trainScorer);
        double rankScore = this.evaluate(ranker, testData);
        System.out.println(this.testScorer.name() + " on test data: " + SimpleMath.round(rankScore, 4));
        if (modelFile.compareTo("") != 0) {
            System.out.println("");
            ranker.save(modelFile);
            System.out.println("Model saved to: " + modelFile);
        }
    }

    public void evaluate(String trainFile, double percentTrain, String testFile, String featureDefFile) {
        ArrayList<RankList> train = new ArrayList<RankList>();
        ArrayList<RankList> validation = new ArrayList<RankList>();
        int[] features = this.prepareSplit(trainFile, featureDefFile, percentTrain, normalize, train, validation);
        List<RankList> test = null;
        if (!testFile.isEmpty()) {
            test = this.readInput(testFile);
            if (normalize) {
                this.normalize(test, features);
            }
        }
        RankerTrainer trainer = new RankerTrainer();
        Ranker ranker = trainer.train(this.type, train, validation, features, this.trainScorer);
        if (test != null) {
            double rankScore = this.evaluate(ranker, test);
            System.out.println(this.testScorer.name() + " on test data: " + SimpleMath.round(rankScore, 4));
        }
        if (modelFile.compareTo("") != 0) {
            System.out.println("");
            ranker.save(modelFile);
            System.out.println("Model saved to: " + modelFile);
        }
    }

    public void evaluate(String sampleFile, String featureDefFile, int nFold, String modelDir, String modelFile) {
        this.evaluate(sampleFile, featureDefFile, nFold, -1.0f, modelDir, modelFile);
    }

    public void evaluate(String sampleFile, String featureDefFile, int nFold, float tvs, String modelDir, String modelFile) {
        int i;
        ArrayList<List<RankList>> trainingData = new ArrayList<List<RankList>>();
        ArrayList<List<RankList>> validationData = new ArrayList<List<RankList>>();
        ArrayList<List<RankList>> testData = new ArrayList<List<RankList>>();
        List<RankList> samples = this.readInput(sampleFile);
        int[] features = this.readFeature(featureDefFile);
        if (features == null) {
            features = FeatureManager.getFeatureFromSampleVector(samples);
        }
        FeatureManager.prepareCV(samples, nFold, tvs, trainingData, validationData, testData);
        if (normalize) {
            for (int i2 = 0; i2 < nFold; ++i2) {
                this.normalizeAll(trainingData, features);
                this.normalizeAll(validationData, features);
                this.normalizeAll(testData, features);
            }
        }
        Ranker ranker = null;
        double scoreOnTrain = 0.0;
        double scoreOnTest = 0.0;
        double totalScoreOnTest = 0.0;
        int totalTestSampleSize = 0;
        double[][] scores = new double[nFold][];
        for (i = 0; i < nFold; ++i) {
            scores[i] = new double[]{0.0, 0.0};
        }
        for (i = 0; i < nFold; ++i) {
            List train = (List)trainingData.get(i);
            List vali = null;
            if (tvs > 0.0f) {
                vali = (List)validationData.get(i);
            }
            List test = (List)testData.get(i);
            RankerTrainer trainer = new RankerTrainer();
            ranker = trainer.train(this.type, train, vali, features, this.trainScorer);
            double s2 = this.evaluate(ranker, test);
            scoreOnTrain += ranker.getScoreOnTrainingData();
            scoreOnTest += s2;
            totalScoreOnTest += s2 * (double)test.size();
            totalTestSampleSize += test.size();
            scores[i][0] = ranker.getScoreOnTrainingData();
            scores[i][1] = s2;
            if (modelDir.isEmpty()) continue;
            ranker.save(FileUtils.makePathStandard(modelDir) + "f" + (i + 1) + "." + modelFile);
            System.out.println("Fold-" + (i + 1) + " model saved to: " + modelFile);
        }
        System.out.println("Summary:");
        System.out.println(this.testScorer.name() + "\t|   Train\t| Test");
        System.out.println("----------------------------------");
        for (i = 0; i < nFold; ++i) {
            System.out.println("Fold " + (i + 1) + "\t|   " + SimpleMath.round(scores[i][0], 4) + "\t|  " + SimpleMath.round(scores[i][1], 4) + "\t");
        }
        System.out.println("----------------------------------");
        System.out.println("Avg.\t|   " + SimpleMath.round(scoreOnTrain / (double)nFold, 4) + "\t|  " + SimpleMath.round(scoreOnTest / (double)nFold, 4) + "\t");
        System.out.println("----------------------------------");
        System.out.println("Total\t|   \t\t|  " + SimpleMath.round(totalScoreOnTest / (double)totalTestSampleSize, 4) + "\t");
    }

    public void test(String testFile) {
        List<RankList> test = this.readInput(testFile);
        double rankScore = this.evaluate(null, test);
        System.out.println(this.testScorer.name() + " on test data: " + SimpleMath.round(rankScore, 4));
    }

    public void test(String testFile, String prpFile) {
        List<RankList> test = this.readInput(testFile);
        double rankScore = 0.0;
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<Double> scores = new ArrayList<Double>();
        for (RankList l : test) {
            double score = this.testScorer.score(l);
            ids.add(l.getID());
            scores.add(score);
            rankScore += score;
        }
        ids.add("all");
        scores.add(rankScore /= (double)test.size());
        System.out.println(this.testScorer.name() + " on test data: " + SimpleMath.round(rankScore, 4));
        if (!prpFile.isEmpty()) {
            this.savePerRankListPerformanceFile(ids, scores, prpFile);
            System.out.println("Per-ranked list performance saved to: " + prpFile);
        }
    }

    public void test(String modelFile, String testFile, String prpFile) {
        Ranker ranker = this.rFact.loadRankerFromFile(modelFile);
        int[] features = ranker.getFeatures();
        List<RankList> test = this.readInput(testFile);
        if (normalize) {
            this.normalize(test, features);
        }
        double rankScore = 0.0;
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<Double> scores = new ArrayList<Double>();
        for (RankList aTest : test) {
            RankList l = ranker.rank(aTest);
            double score = this.testScorer.score(l);
            ids.add(l.getID());
            scores.add(score);
            rankScore += score;
        }
        ids.add("all");
        scores.add(rankScore /= (double)test.size());
        System.out.println(this.testScorer.name() + " on test data: " + SimpleMath.round(rankScore, 4));
        if (!prpFile.isEmpty()) {
            this.savePerRankListPerformanceFile(ids, scores, prpFile);
            System.out.println("Per-ranked list performance saved to: " + prpFile);
        }
    }

    public void test(List<String> modelFiles, String testFile, String prpFile) {
        ArrayList<List<RankList>> trainingData = new ArrayList<List<RankList>>();
        ArrayList<List<RankList>> testData = new ArrayList<List<RankList>>();
        int nFold = modelFiles.size();
        List<RankList> samples = this.readInput(testFile);
        System.out.print("Preparing " + nFold + "-fold test data... ");
        FeatureManager.prepareCV(samples, nFold, trainingData, testData);
        System.out.println("[Done.]");
        double rankScore = 0.0;
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<Double> scores = new ArrayList<Double>();
        for (int f = 0; f < nFold; ++f) {
            List test = (List)testData.get(f);
            Ranker ranker = this.rFact.loadRankerFromFile(modelFiles.get(f));
            int[] features = ranker.getFeatures();
            if (normalize) {
                this.normalize(test, features);
            }
            for (RankList aTest : test) {
                RankList l = ranker.rank(aTest);
                double score = this.testScorer.score(l);
                ids.add(l.getID());
                scores.add(score);
                rankScore += score;
            }
        }
        ids.add("all");
        scores.add(rankScore /= (double)ids.size());
        System.out.println(this.testScorer.name() + " on test data: " + SimpleMath.round(rankScore, 4));
        if (!prpFile.isEmpty()) {
            this.savePerRankListPerformanceFile(ids, scores, prpFile);
            System.out.println("Per-ranked list performance saved to: " + prpFile);
        }
    }

    public void test(List<String> modelFiles, List<String> testFiles, String prpFile) {
        int nFold = modelFiles.size();
        double rankScore = 0.0;
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<Double> scores = new ArrayList<Double>();
        for (int f = 0; f < nFold; ++f) {
            List<RankList> test = this.readInput(testFiles.get(f));
            Ranker ranker = this.rFact.loadRankerFromFile(modelFiles.get(f));
            int[] features = ranker.getFeatures();
            if (normalize) {
                this.normalize(test, features);
            }
            for (RankList aTest : test) {
                RankList l = ranker.rank(aTest);
                double score = this.testScorer.score(l);
                ids.add(l.getID());
                scores.add(score);
                rankScore += score;
            }
        }
        ids.add("all");
        scores.add(rankScore /= (double)ids.size());
        System.out.println(this.testScorer.name() + " on test data: " + SimpleMath.round(rankScore, 4));
        if (!prpFile.isEmpty()) {
            this.savePerRankListPerformanceFile(ids, scores, prpFile);
            System.out.println("Per-ranked list performance saved to: " + prpFile);
        }
    }

    public void testWithScoreFile(String testFile, String scoreFile) {
        try (BufferedReader in = FileUtils.smartReader(scoreFile);){
            List<RankList> test = this.readInput(testFile);
            String content = "";
            ArrayList<Double> scores = new ArrayList<Double>();
            while ((content = in.readLine()) != null) {
                if ((content = content.trim()).compareTo("") == 0) continue;
                scores.add(Double.parseDouble(content));
            }
            in.close();
            int k = 0;
            for (int i = 0; i < test.size(); ++i) {
                RankList rl = test.get(i);
                double[] s2 = new double[rl.size()];
                for (int j = 0; j < rl.size(); ++j) {
                    s2[j] = (Double)scores.get(k++);
                }
                rl = new RankList(rl, MergeSorter.sort(s2, false));
                test.set(i, rl);
            }
            double rankScore = this.evaluate(null, test);
            System.out.println(this.testScorer.name() + " on test data: " + SimpleMath.round(rankScore, 4));
        }
        catch (IOException e) {
            throw RankLibError.create(e);
        }
    }

    public void score(String modelFile, String testFile, String outputFile) {
        Ranker ranker = this.rFact.loadRankerFromFile(modelFile);
        int[] features = ranker.getFeatures();
        List<RankList> test = this.readInput(testFile);
        if (normalize) {
            this.normalize(test, features);
        }
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8"));
            for (RankList l : test) {
                for (int j = 0; j < l.size(); ++j) {
                    out.write(l.getID() + "\t" + j + "\t" + ranker.eval(l.get(j)) + "");
                    out.newLine();
                }
            }
            out.close();
        }
        catch (IOException ex) {
            throw RankLibError.create("Error in Evaluator::rank(): ", ex);
        }
    }

    public void score(List<String> modelFiles, String testFile, String outputFile) {
        ArrayList<List<RankList>> trainingData = new ArrayList<List<RankList>>();
        ArrayList<List<RankList>> testData = new ArrayList<List<RankList>>();
        int nFold = modelFiles.size();
        List<RankList> samples = this.readInput(testFile);
        System.out.print("Preparing " + nFold + "-fold test data... ");
        FeatureManager.prepareCV(samples, nFold, trainingData, testData);
        System.out.println("[Done.]");
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8"));
            for (int f = 0; f < nFold; ++f) {
                List test = (List)testData.get(f);
                Ranker ranker = this.rFact.loadRankerFromFile(modelFiles.get(f));
                int[] features = ranker.getFeatures();
                if (normalize) {
                    this.normalize(test, features);
                }
                for (RankList l : test) {
                    for (int j = 0; j < l.size(); ++j) {
                        out.write(l.getID() + "\t" + j + "\t" + ranker.eval(l.get(j)) + "");
                        out.newLine();
                    }
                }
            }
            out.close();
        }
        catch (IOException ex) {
            throw RankLibError.create("Error in Evaluator::score(): ", ex);
        }
    }

    public void score(List<String> modelFiles, List<String> testFiles, String outputFile) {
        int nFold = modelFiles.size();
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8"));){
            for (int f = 0; f < nFold; ++f) {
                List<RankList> test = this.readInput(testFiles.get(f));
                Ranker ranker = this.rFact.loadRankerFromFile(modelFiles.get(f));
                int[] features = ranker.getFeatures();
                if (normalize) {
                    this.normalize(test, features);
                }
                for (RankList l : test) {
                    for (int j = 0; j < l.size(); ++j) {
                        out.write(l.getID() + "\t" + j + "\t" + ranker.eval(l.get(j)) + "");
                        out.newLine();
                    }
                }
            }
        }
        catch (IOException ex) {
            throw RankLibError.create("Error in Evaluator::score(): ", ex);
        }
    }

    public void rank(String modelFile, String testFile, String indriRanking) {
        Ranker ranker = this.rFact.loadRankerFromFile(modelFile);
        int[] features = ranker.getFeatures();
        List<RankList> test = this.readInput(testFile);
        if (normalize) {
            this.normalize(test, features);
        }
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(indriRanking), "UTF-8"));
            for (RankList l : test) {
                double[] scores = new double[l.size()];
                for (int j = 0; j < l.size(); ++j) {
                    scores[j] = ranker.eval(l.get(j));
                }
                int[] idx = MergeSorter.sort(scores, false);
                for (int j = 0; j < idx.length; ++j) {
                    int k = idx[j];
                    String str = l.getID() + " Q0 " + l.get(k).getDescription().replace("#", "").trim() + " " + (j + 1) + " " + SimpleMath.round(scores[k], 5) + " indri";
                    out.write(str);
                    out.newLine();
                }
            }
            out.close();
        }
        catch (IOException ex) {
            throw RankLibError.create("Error in Evaluator::rank(): ", ex);
        }
    }

    public void rank(String testFile, String indriRanking) {
        List<RankList> test = this.readInput(testFile);
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(indriRanking), "UTF-8"));
            for (RankList l : test) {
                for (int j = 0; j < l.size(); ++j) {
                    String str = l.getID() + " Q0 " + l.get(j).getDescription().replace("#", "").trim() + " " + (j + 1) + " " + SimpleMath.round(1.0 - 1.0E-4 * (double)j, 5) + " indri";
                    out.write(str);
                    out.newLine();
                }
            }
            out.close();
        }
        catch (IOException ex) {
            throw RankLibError.create("Error in Evaluator::rank(): ", ex);
        }
    }

    public void rank(List<String> modelFiles, String testFile, String indriRanking) {
        ArrayList<List<RankList>> trainingData = new ArrayList<List<RankList>>();
        ArrayList<List<RankList>> testData = new ArrayList<List<RankList>>();
        int nFold = modelFiles.size();
        List<RankList> samples = this.readInput(testFile);
        System.out.print("Preparing " + nFold + "-fold test data... ");
        FeatureManager.prepareCV(samples, nFold, trainingData, testData);
        System.out.println("[Done.]");
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(indriRanking), "UTF-8"));
            for (int f = 0; f < nFold; ++f) {
                List test = (List)testData.get(f);
                Ranker ranker = this.rFact.loadRankerFromFile(modelFiles.get(f));
                int[] features = ranker.getFeatures();
                if (normalize) {
                    this.normalize(test, features);
                }
                for (RankList l : test) {
                    double[] scores = new double[l.size()];
                    for (int j = 0; j < l.size(); ++j) {
                        scores[j] = ranker.eval(l.get(j));
                    }
                    int[] idx = MergeSorter.sort(scores, false);
                    for (int j = 0; j < idx.length; ++j) {
                        int k = idx[j];
                        String str = l.getID() + " Q0 " + l.get(k).getDescription().replace("#", "").trim() + " " + (j + 1) + " " + SimpleMath.round(scores[k], 5) + " indri";
                        out.write(str);
                        out.newLine();
                    }
                }
            }
            out.close();
        }
        catch (Exception ex) {
            throw RankLibError.create("Error in Evaluator::rank(): ", ex);
        }
    }

    public void rank(List<String> modelFiles, List<String> testFiles, String indriRanking) {
        int nFold = modelFiles.size();
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(indriRanking), "UTF-8"));
            for (int f = 0; f < nFold; ++f) {
                List<RankList> test = this.readInput(testFiles.get(f));
                Ranker ranker = this.rFact.loadRankerFromFile(modelFiles.get(f));
                int[] features = ranker.getFeatures();
                if (normalize) {
                    this.normalize(test, features);
                }
                for (RankList l : test) {
                    double[] scores = new double[l.size()];
                    for (int j = 0; j < l.size(); ++j) {
                        scores[j] = ranker.eval(l.get(j));
                    }
                    int[] idx = MergeSorter.sort(scores, false);
                    for (int j = 0; j < idx.length; ++j) {
                        int k = idx[j];
                        String str = l.getID() + " Q0 " + l.get(k).getDescription().replace("#", "").trim() + " " + (j + 1) + " " + SimpleMath.round(scores[k], 5) + " indri";
                        out.write(str);
                        out.newLine();
                    }
                }
            }
            out.close();
        }
        catch (IOException ex) {
            throw RankLibError.create("Error in Evaluator::rank(): ", ex);
        }
    }

    private int[] prepareSplit(String sampleFile, String featureDefFile, double percentTrain, boolean normalize, List<RankList> trainingData, List<RankList> testData) {
        List<RankList> data = this.readInput(sampleFile);
        int[] features = this.readFeature(featureDefFile);
        if (features == null) {
            features = FeatureManager.getFeatureFromSampleVector(data);
        }
        if (normalize) {
            this.normalize(data, features);
        }
        FeatureManager.prepareSplit(data, percentTrain, trainingData, testData);
        return features;
    }

    public void savePerRankListPerformanceFile(List<String> ids, List<Double> scores, String prpFile) {
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(prpFile)));){
            for (int i = 0; i < ids.size(); ++i) {
                out.write(this.testScorer.name() + "   " + ids.get(i) + "   " + scores.get(i));
                out.newLine();
            }
        }
        catch (Exception ex) {
            throw RankLibError.create("Error in Evaluator::savePerRankListPerformanceFile(): ", ex);
        }
    }
}

