/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.eval;

import ciir.umass.edu.stats.RandomPermutationTest;
import ciir.umass.edu.utilities.FileUtils;
import ciir.umass.edu.utilities.RankLibError;
import ciir.umass.edu.utilities.SimpleMath;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class Analyzer {
    private RandomPermutationTest randomizedTest = new RandomPermutationTest();
    private static double[] improvementRatioThreshold = new double[]{-1.0, -0.75, -0.5, -0.25, 0.0, 0.25, 0.5, 0.75, 1.0, 1000.0};
    private int indexOfZero = 4;

    public static void main(String[] args) {
        String directory = "";
        String baseline = "";
        if (args.length < 2) {
            System.out.println("Usage: java -cp bin/RankLib.jar ciir.umass.edu.eval.Analyzer <Params>");
            System.out.println("Params:");
            System.out.println("\t-all <directory>\tDirectory of performance files (one per system)");
            System.out.println("\t-base <file>\t\tPerformance file for the baseline (MUST be in the same directory)");
            System.out.println("\t[ -np ] \t\tNumber of permutation (Fisher randomization test) [default=" + RandomPermutationTest.nPermutation + "]");
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].compareTo("-all") == 0) {
                directory = args[++i];
                continue;
            }
            if (args[i].compareTo("-base") == 0) {
                baseline = args[++i];
                continue;
            }
            if (args[i].compareTo("-np") != 0) continue;
            RandomPermutationTest.nPermutation = Integer.parseInt(args[++i]);
        }
        Analyzer a = new Analyzer();
        a.compare(directory, baseline);
    }

    private int locateSegment(double value) {
        block3: {
            block2: {
                if (!(value > 0.0)) break block2;
                for (int i = this.indexOfZero; i < improvementRatioThreshold.length; ++i) {
                    if (!(value <= improvementRatioThreshold[i])) continue;
                    return i;
                }
                break block3;
            }
            if (!(value < 0.0)) break block3;
            for (int i = 0; i <= this.indexOfZero; ++i) {
                if (!(value < improvementRatioThreshold[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public HashMap<String, Double> read(String filename) {
        HashMap<String, Double> performance = new HashMap<String, Double>();
        try (BufferedReader in = FileUtils.smartReader(filename);){
            String content = "";
            while ((content = in.readLine()) != null) {
                if ((content = content.trim()).length() == 0) continue;
                while (content.contains("  ")) {
                    content = content.replace("  ", " ");
                }
                content = content.replace(" ", "\t");
                String[] s2 = content.split("\t");
                String id = s2[1];
                double p = Double.parseDouble(s2[2]);
                performance.put(id, p);
            }
            in.close();
            System.out.println("Reading " + filename + "... " + performance.size() + " ranked lists [Done]");
        }
        catch (IOException ex) {
            throw RankLibError.create(ex);
        }
        return performance;
    }

    public void compare(String directory, String baseFile) {
        directory = FileUtils.makePathStandard(directory);
        List<String> targets = FileUtils.getAllFiles2(directory);
        for (int i = 0; i < targets.size(); ++i) {
            if (targets.get(i).compareTo(baseFile) == 0) {
                targets.remove(i);
                --i;
                continue;
            }
            targets.set(i, directory + targets.get(i));
        }
        this.compare(targets, directory + baseFile);
    }

    public void compare(List<String> targetFiles, String baseFile) {
        int i;
        HashMap<String, Double> base = this.read(baseFile);
        ArrayList<HashMap<String, Double>> targets = new ArrayList<HashMap<String, Double>>();
        for (int i2 = 0; i2 < targetFiles.size(); ++i2) {
            HashMap<String, Double> hm = this.read(targetFiles.get(i2));
            targets.add(hm);
        }
        Result[] rs = this.compare(base, targets);
        System.out.println("");
        System.out.println("");
        System.out.println("Overall comparison");
        System.out.println("------------------------------------------------------------------------");
        System.out.println("System\tPerformance\tImprovement\tWin\tLoss\tp-value");
        System.out.println(FileUtils.getFileName(baseFile) + " [baseline]\t" + SimpleMath.round(base.get("all"), 4));
        for (int i3 = 0; i3 < rs.length; ++i3) {
            if (rs[i3].status == 0) {
                double delta = (Double)((HashMap)targets.get(i3)).get("all") - base.get("all");
                double dp = delta * 100.0 / base.get("all");
                String msg = FileUtils.getFileName(targetFiles.get(i3)) + "\t" + SimpleMath.round((Double)((HashMap)targets.get(i3)).get("all"), 4);
                msg = msg + "\t" + (delta > 0.0 ? "+" : "") + SimpleMath.round(delta, 4) + " (" + (delta > 0.0 ? "+" : "") + SimpleMath.round(dp, 2) + "%)";
                msg = msg + "\t" + rs[i3].win + "\t" + rs[i3].loss;
                msg = msg + "\t" + this.randomizedTest.test((HashMap)targets.get(i3), base) + "";
                System.out.println(msg);
                continue;
            }
            System.out.println("WARNING: [" + targetFiles.get(i3) + "] skipped: NOT comparable to the baseline due to different ranked list IDs.");
        }
        System.out.println("");
        System.out.println("");
        System.out.println("Detailed break down");
        System.out.println("------------------------------------------------------------------------");
        String header = "";
        String[] tmp = new String[improvementRatioThreshold.length];
        for (i = 0; i < improvementRatioThreshold.length; ++i) {
            String t = (int)(improvementRatioThreshold[i] * 100.0) + "%";
            if (improvementRatioThreshold[i] > 0.0) {
                t = "+" + t;
            }
            tmp[i] = t;
        }
        header = header + "[ < " + tmp[0] + ")\t";
        for (i = 0; i < improvementRatioThreshold.length - 2; ++i) {
            header = i >= this.indexOfZero ? header + "(" + tmp[i] + ", " + tmp[i + 1] + "]\t" : header + "[" + tmp[i] + ", " + tmp[i + 1] + ")\t";
        }
        header = header + "( > " + tmp[improvementRatioThreshold.length - 2] + "]";
        System.out.println("\t" + header);
        for (i = 0; i < targets.size(); ++i) {
            String msg = FileUtils.getFileName(targetFiles.get(i));
            for (int j = 0; j < rs[i].countByImprovementRange.length; ++j) {
                msg = msg + "\t" + rs[i].countByImprovementRange[j];
            }
            System.out.println(msg);
        }
    }

    public Result[] compare(HashMap<String, Double> base, List<HashMap<String, Double>> targets) {
        Result[] rs = new Result[targets.size()];
        for (int i = 0; i < targets.size(); ++i) {
            rs[i] = this.compare(base, targets.get(i));
        }
        return rs;
    }

    public Result compare(HashMap<String, Double> base, HashMap<String, Double> target) {
        Result r = new Result();
        if (base.size() != target.size()) {
            r.status = -1;
            return r;
        }
        r.countByImprovementRange = new int[improvementRatioThreshold.length];
        Arrays.fill(r.countByImprovementRange, 0);
        for (String key : base.keySet()) {
            double change;
            if (!target.containsKey(key)) {
                r.status = -2;
                return r;
            }
            if (key.compareTo("all") == 0) continue;
            double p = base.get(key);
            double pt = target.get(key);
            if (pt > p) {
                ++r.win;
            } else if (pt < p) {
                ++r.loss;
            }
            if ((change = pt - p) == 0.0) continue;
            int n = this.locateSegment(change);
            r.countByImprovementRange[n] = r.countByImprovementRange[n] + 1;
        }
        return r;
    }

    static class Result {
        int status = 0;
        int win = 0;
        int loss = 0;
        int[] countByImprovementRange = null;

        Result() {
        }
    }
}

