/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util.search;

import cc.mallet.util.search.QueueElement;
import cc.mallet.util.search.SearchState;
import java.util.Iterator;

public class SearchNode
implements QueueElement {
    private int position = -1;
    private double priority = Double.POSITIVE_INFINITY;
    private double cost;
    private SearchNode parent;
    private SearchState state;

    public SearchNode(SearchState state, SearchNode parent, double cost) {
        this.state = state;
        this.parent = parent;
        this.cost = cost;
    }

    @Override
    public double getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(double priority) {
        this.priority = priority;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(int position) {
        this.position = position;
    }

    public SearchNode getParent() {
        return this.parent;
    }

    public double getCost() {
        return this.cost;
    }

    public SearchState getState() {
        return this.state;
    }

    public boolean isFinal() {
        return this.state.isFinal();
    }

    public NextNodeIterator getNextNodes() {
        return new NextNodeIterator();
    }

    public String toString() {
        return String.valueOf(this.state.toString()) + "/" + this.priority;
    }

    public class NextNodeIterator
    implements Iterator {
        private SearchState.NextStateIterator stateIter;

        protected NextNodeIterator() {
            this.stateIter = SearchNode.this.state.getNextStates();
        }

        @Override
        public boolean hasNext() {
            return this.stateIter.hasNext();
        }

        public Object next() {
            return this.nextNode();
        }

        public SearchNode nextNode() {
            SearchNode p = SearchNode.this;
            SearchState s2 = this.stateIter.nextState();
            return new SearchNode(s2, p, p.getCost() + this.cost());
        }

        public double cost() {
            return this.stateIter.cost();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected SearchState.NextStateIterator getStateIter() {
            return this.stateIter;
        }
    }
}

