/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class MalletLogger
extends Logger {
    public static Level[] LoggingLevels = new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.ALL};

    static {
        if (System.getProperty("java.util.logging.config.file") == null && System.getProperty("java.util.logging.config.class") == null) {
            try {
                InputStream s2 = MalletLogger.class.getResourceAsStream("resources/logging.properties");
                if (s2 == null) {
                    throw new IOException();
                }
                LogManager.getLogManager().readConfiguration(s2);
                Logger.global.config("Set java.util.logging properties from " + MalletLogger.class.getPackage().getName() + "/resources/logging.properties");
            }
            catch (IOException e) {
                System.err.println("Couldn't open " + MalletLogger.class.getName() + " resources/logging.properties file.\n" + " Perhaps the 'resources' directories weren't copied into the 'class' directory.\n" + " Continuing.");
            }
        }
    }

    protected MalletLogger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
    }

    public static Logger getLogger(String name) {
        return Logger.getLogger(name);
    }

    public Logger getRootLogger() {
        Logger rootLogger = this;
        while (rootLogger.getParent() != null) {
            rootLogger = rootLogger.getParent();
        }
        return rootLogger;
    }
}

