/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class DoubleList
implements Serializable {
    double[] data;
    int size;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public DoubleList() {
        this(2);
    }

    public DoubleList(int capacity) {
        if (capacity < 2) {
            capacity = 2;
        }
        this.data = new double[capacity];
        this.size = 0;
    }

    public DoubleList(int size, double fillValue) {
        int capacity = size;
        if (capacity < 2) {
            capacity = 2;
        }
        this.data = new double[capacity];
        Arrays.fill(this.data, fillValue);
        this.size = size;
    }

    public DoubleList(double[] initialValues, int size) {
        this.data = new double[initialValues.length];
        System.arraycopy(initialValues, 0, this.data, 0, initialValues.length);
        this.size = size;
    }

    public DoubleList(double[] initialValues) {
        this(initialValues, initialValues.length);
    }

    public DoubleList cloneDoubleList() {
        return new DoubleList(this.data, this.size);
    }

    public Object clone() {
        return this.cloneDoubleList();
    }

    private void growIfNecessary(int index) {
        int newDataLength = this.data.length;
        while (index >= newDataLength) {
            if (newDataLength < 100) {
                newDataLength *= 2;
                continue;
            }
            newDataLength = newDataLength * 3 / 2;
        }
        if (newDataLength != this.data.length) {
            double[] newData = new double[newDataLength];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
    }

    public void add(double value) {
        this.growIfNecessary(this.size);
        this.data[this.size++] = value;
    }

    public double get(int index) {
        if (index >= this.size) {
            throw new IllegalArgumentException("Index " + index + " out of bounds; size=" + this.size);
        }
        return this.data[index];
    }

    public void set(int index, double value) {
        this.growIfNecessary(index);
        this.data[index] = value;
        if (index >= this.size) {
            this.size = index + 1;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        int size = this.data.length;
        out.writeInt(size);
        int i = 1;
        while (i < size) {
            out.writeDouble(this.data[i]);
            ++i;
        }
        out.writeInt(this.size);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version2 = in.readInt();
        int len = in.readInt();
        this.data = new double[len];
        int i = 1;
        while (i < len) {
            this.data[i] = in.readDouble();
            ++i;
        }
        this.size = in.readInt();
    }
}

