/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util;

import bsh.EvalError;
import cc.mallet.util.BshInterpreter;
import java.io.FileInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Logger;

public abstract class CommandOption {
    static BshInterpreter interpreter;
    static HashMap class2options;
    Class owner;
    java.lang.String name;
    java.lang.String argName;
    Class argType;
    boolean argRequired;
    java.lang.String shortdoc;
    java.lang.String longdoc;
    java.lang.String fullName;
    boolean invoked = false;

    static {
        class2options = new HashMap();
    }

    public CommandOption(Class owner, java.lang.String name, java.lang.String argName, Class argType, boolean argRequired, java.lang.String shortdoc, java.lang.String longdoc) {
        this.owner = owner;
        this.name = name;
        this.argName = argName;
        this.argType = argType;
        this.argRequired = argRequired;
        this.shortdoc = shortdoc;
        this.longdoc = longdoc;
        Package p = owner.getPackage();
        this.fullName = java.lang.String.valueOf(p != null ? p.toString() : "") + name;
        if (interpreter == null) {
            interpreter = new BshInterpreter();
        }
        if (owner != CommandOption.class) {
            List options = (List)class2options.get(owner);
            if (options == null) {
                options = new List("");
                class2options.put(owner, options);
            }
            options.add(this);
        }
    }

    public CommandOption(Class owner, java.lang.String name, java.lang.String argName, Class argType, boolean argRequired, java.lang.String shortdoc) {
        this(owner, name, argName, argType, argRequired, shortdoc, null);
    }

    public int process(java.lang.String[] args, int index) {
        if (args.length == 0) {
            return index;
        }
        if (index >= args.length || args[index] == null || args[index].length() < 2 || args[index].charAt(0) != '-' || args[index].charAt(1) != '-') {
            return index;
        }
        java.lang.String optFullName = args[index].substring(2);
        int dotIndex = optFullName.lastIndexOf(46);
        java.lang.String optName = optFullName;
        if (dotIndex != -1) {
            java.lang.String optPackageName = optFullName.substring(0, dotIndex);
            if (this.owner.getPackage() != null && !this.owner.getPackage().toString().endsWith(optPackageName)) {
                return index;
            }
            optName = optFullName.substring(dotIndex + 1);
        }
        if (!this.name.equals(optName)) {
            return index;
        }
        this.invoked = true;
        if (args.length > ++index && (args[index].length() < 2 || args[index].charAt(0) != '-' && args[index].charAt(1) != '-')) {
            index = this.parseArg(args, index);
        } else {
            if (this.argRequired) {
                throw new IllegalArgumentException("Missing argument for option " + optName);
            }
            this.parseArg(args, -index);
        }
        return index;
    }

    public static BshInterpreter getInterpreter() {
        return interpreter;
    }

    public static java.lang.String[] process(Class owner, java.lang.String[] args) {
        List options = (List)class2options.get(owner);
        if (options == null) {
            throw new IllegalArgumentException("No CommandOptions registered for class " + owner);
        }
        return options.process(args);
    }

    public static List getList(Class owner) {
        List options = (List)class2options.get(owner);
        if (options == null) {
            throw new IllegalArgumentException("No CommandOptions registered for class " + owner);
        }
        return options;
    }

    public static void setSummary(Class owner, java.lang.String summary) {
        List options = (List)class2options.get(owner);
        if (options == null) {
            throw new IllegalArgumentException("No CommandOption.List registered for class " + owner);
        }
        options.setSummary(summary);
    }

    public java.lang.String getFullName() {
        return this.fullName;
    }

    public java.lang.String getName() {
        return this.name;
    }

    public abstract java.lang.String defaultValueToString();

    public abstract java.lang.String valueToString();

    public boolean wasInvoked() {
        return this.invoked;
    }

    public int parseArg(java.lang.String[] args, int index) {
        if (index < 0) {
            this.parseArg(null);
            return index;
        }
        this.parseArg(args[index]);
        return index + 1;
    }

    public void parseArg(java.lang.String arg) {
    }

    public void postParsing(List list) {
    }

    public static void printOptionValues(Class owner) {
        List options = (List)class2options.get(owner);
        int i = 0;
        while (i < options.size()) {
            CommandOption option = options.getCommandOption(i);
            System.out.println(java.lang.String.valueOf(option.getName()) + "\t=\t" + option.valueToString());
            ++i;
        }
    }

    public static class Boolean
    extends CommandOption {
        public boolean value;
        public boolean defaultValue;

        public Boolean(Class owner, java.lang.String name, java.lang.String argName, boolean argRequired, boolean defaultValue, java.lang.String shortdoc, java.lang.String longdoc) {
            super(owner, name, argName, Boolean.class, argRequired, shortdoc, longdoc);
            this.defaultValue = this.value = defaultValue;
        }

        public boolean value() {
            return this.value;
        }

        @Override
        public void parseArg(java.lang.String arg) {
            if (arg == null || arg.equalsIgnoreCase("true") || arg.equals("1")) {
                this.value = true;
            } else if (arg.equalsIgnoreCase("false") || arg.equals("0")) {
                this.value = false;
            } else {
                throw new IllegalArgumentException("Boolean option should be true|false|0|1.  Instead found " + arg);
            }
        }

        @Override
        public java.lang.String defaultValueToString() {
            return java.lang.Boolean.toString(this.defaultValue);
        }

        @Override
        public java.lang.String valueToString() {
            return java.lang.Boolean.toString(this.value);
        }
    }

    public static class Double
    extends CommandOption {
        public double value;
        public double defaultValue;

        public Double(Class owner, java.lang.String name, java.lang.String argName, boolean argRequired, double defaultValue, java.lang.String shortdoc, java.lang.String longdoc) {
            super(owner, name, argName, Double.class, argRequired, shortdoc, longdoc);
            this.defaultValue = this.value = defaultValue;
        }

        public double value() {
            return this.value;
        }

        @Override
        public void parseArg(java.lang.String arg) {
            this.value = java.lang.Double.parseDouble(arg);
        }

        @Override
        public java.lang.String defaultValueToString() {
            return java.lang.Double.toString(this.defaultValue);
        }

        @Override
        public java.lang.String valueToString() {
            return java.lang.Double.toString(this.value);
        }
    }

    public static class DoubleArray
    extends CommandOption {
        public double[] value;
        public double[] defaultValue;

        public DoubleArray(Class owner, java.lang.String name, java.lang.String argName, boolean argRequired, double[] defaultValue, java.lang.String shortdoc, java.lang.String longdoc) {
            super(owner, name, argName, IntegerArray.class, argRequired, shortdoc, longdoc);
            this.value = defaultValue;
            this.defaultValue = defaultValue;
        }

        public double[] value() {
            return this.value;
        }

        @Override
        public void parseArg(java.lang.String arg) {
            java.lang.String[] elts = arg.split(",");
            this.value = new double[elts.length];
            int i = 0;
            while (i < elts.length) {
                this.value[i] = java.lang.Double.parseDouble(elts[i]);
                ++i;
            }
        }

        @Override
        public java.lang.String defaultValueToString() {
            StringBuffer b = new StringBuffer();
            java.lang.String sep = "";
            int i = 0;
            while (i < this.defaultValue.length) {
                b.append(sep).append(java.lang.Double.toString(this.defaultValue[i]));
                sep = ",";
                ++i;
            }
            return b.toString();
        }

        @Override
        public java.lang.String valueToString() {
            StringBuffer b = new StringBuffer();
            java.lang.String sep = "";
            int i = 0;
            while (i < this.value.length) {
                b.append(sep).append(java.lang.Double.toString(this.value[i]));
                sep = ",";
                ++i;
            }
            return b.toString();
        }
    }

    public static class File
    extends CommandOption {
        public java.io.File value;
        public java.io.File defaultValue;

        public File(Class owner, java.lang.String name, java.lang.String argName, boolean argRequired, java.io.File defaultValue, java.lang.String shortdoc, java.lang.String longdoc) {
            super(owner, name, argName, java.io.File.class, argRequired, shortdoc, longdoc);
            this.defaultValue = this.value = defaultValue;
        }

        public java.io.File value() {
            return this.value;
        }

        @Override
        public void parseArg(java.lang.String arg) {
            this.value = new java.io.File(arg);
        }

        @Override
        public java.lang.String defaultValueToString() {
            return this.defaultValue == null ? null : this.defaultValue.toString();
        }

        @Override
        public java.lang.String valueToString() {
            return this.value == null ? null : this.value.toString();
        }
    }

    public static class Integer
    extends CommandOption {
        public int value;
        public int defaultValue;

        public Integer(Class owner, java.lang.String name, java.lang.String argName, boolean argRequired, int defaultValue, java.lang.String shortdoc, java.lang.String longdoc) {
            super(owner, name, argName, Integer.class, argRequired, shortdoc, longdoc);
            this.defaultValue = this.value = defaultValue;
        }

        public int value() {
            return this.value;
        }

        @Override
        public void parseArg(java.lang.String arg) {
            this.value = java.lang.Integer.parseInt(arg);
        }

        @Override
        public java.lang.String defaultValueToString() {
            return java.lang.Integer.toString(this.defaultValue);
        }

        @Override
        public java.lang.String valueToString() {
            return java.lang.Integer.toString(this.value);
        }
    }

    public static class IntegerArray
    extends CommandOption {
        public int[] value;
        public int[] defaultValue;

        public IntegerArray(Class owner, java.lang.String name, java.lang.String argName, boolean argRequired, int[] defaultValue, java.lang.String shortdoc, java.lang.String longdoc) {
            super(owner, name, argName, IntegerArray.class, argRequired, shortdoc, longdoc);
            this.value = defaultValue;
            this.defaultValue = defaultValue;
        }

        public int[] value() {
            return this.value;
        }

        @Override
        public void parseArg(java.lang.String arg) {
            java.lang.String[] elts = arg.split(",");
            this.value = new int[elts.length];
            int i = 0;
            while (i < elts.length) {
                this.value[i] = java.lang.Integer.parseInt(elts[i]);
                ++i;
            }
        }

        @Override
        public java.lang.String defaultValueToString() {
            StringBuffer b = new StringBuffer();
            java.lang.String sep = "";
            int i = 0;
            while (i < this.defaultValue.length) {
                b.append(sep).append(java.lang.Integer.toString(this.defaultValue[i]));
                sep = ",";
                ++i;
            }
            return b.toString();
        }

        @Override
        public java.lang.String valueToString() {
            StringBuffer b = new StringBuffer();
            java.lang.String sep = "";
            int i = 0;
            while (i < this.value.length) {
                b.append(sep).append(java.lang.Integer.toString(this.value[i]));
                sep = ",";
                ++i;
            }
            return b.toString();
        }
    }

    public static class List {
        ArrayList options = new ArrayList();
        HashMap map = new HashMap();
        java.lang.String summary;

        private List(java.lang.String summary) {
            this.summary = summary;
            this.add(new Boolean(CommandOption.class, "help", "TRUE|FALSE", false, false, "Print this command line option usage information.  Give argument of TRUE for longer documentation", null){

                @Override
                public void postParsing(List list) {
                    List.this.printUsage(this.value);
                    System.exit(-1);
                }
            });
            this.add(new Object(CommandOption.class, "prefix-code", "'JAVA CODE'", true, null, "Java code you want run before any other interpreted code.  Note that the text is interpreted without modification, so unlike some other Java code options, you need to include any necessary 'new's when creating objects.", null));
            this.add(new File(CommandOption.class, "config", "FILE", false, null, "Read command option values from a file", null){

                @Override
                public void postParsing(List list) {
                    List.this.readFromFile(this.value);
                }
            });
        }

        public List(java.lang.String summary, CommandOption[] options) {
            this(summary);
            this.add(options);
        }

        public void setSummary(java.lang.String s2) {
            this.summary = s2;
        }

        public int size() {
            return this.options.size();
        }

        public CommandOption getCommandOption(int index) {
            return (CommandOption)this.options.get(index);
        }

        public void add(CommandOption opt) {
            this.options.add(opt);
            this.map.put(opt.getFullName(), opt);
        }

        public void add(CommandOption[] opts) {
            int i = 0;
            while (i < opts.length) {
                this.add(opts[i]);
                ++i;
            }
        }

        public void add(List opts) {
            int i = 0;
            while (i < opts.size()) {
                this.add(opts.getCommandOption(i));
                ++i;
            }
        }

        public void add(Class owner) {
            List options = (List)class2options.get(owner);
            if (options == null) {
                throw new IllegalArgumentException("No CommandOptions registered for class " + owner);
            }
            this.add(options);
        }

        public void readFromFile(java.io.File configurationFile) {
            try {
                Properties properties = new Properties();
                if (configurationFile.getName().endsWith(".xml")) {
                    properties.loadFromXML(new FileInputStream(configurationFile));
                } else {
                    properties.load(new FileInputStream(configurationFile));
                }
                Enumeration<?> keys = properties.propertyNames();
                block2: while (keys.hasMoreElements()) {
                    java.lang.String key = (java.lang.String)keys.nextElement();
                    java.lang.String[] values = properties.getProperty(key).split("\\s+");
                    boolean foundValue = false;
                    int i = 0;
                    while (i < this.options.size()) {
                        CommandOption option = (CommandOption)this.options.get(i);
                        if (option.name.equals(key)) {
                            foundValue = true;
                            option.parseArg(values, 0);
                            option.invoked = true;
                            continue block2;
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Unable to process configuration file: " + e.getMessage());
            }
        }

        public java.lang.String[] process(java.lang.String[] args) {
            int index = 0;
            while (index < args.length) {
                int newIndex = index;
                int i = 0;
                while (i < this.options.size()) {
                    CommandOption o = (CommandOption)this.options.get(i);
                    newIndex = o.process(args, index);
                    if (newIndex != index) {
                        o.postParsing(this);
                        break;
                    }
                    ++i;
                }
                if (newIndex == index) {
                    this.printUsage(false);
                    throw new IllegalArgumentException("Unrecognized option " + index + ": " + args[index]);
                }
                index = newIndex;
            }
            return new java.lang.String[0];
        }

        public int processOptions(java.lang.String[] args) {
            int index = 0;
            while (index < args.length) {
                int newIndex = index;
                int i = 0;
                while (i < this.options.size()) {
                    CommandOption o = (CommandOption)this.options.get(i);
                    newIndex = o.process(args, index);
                    if (newIndex != index) {
                        o.postParsing(this);
                        break;
                    }
                    ++i;
                }
                if (newIndex == index) {
                    if (index < args.length && args[index].length() > 1 && args[index].charAt(0) == '-' && args[index].charAt(1) == '-') {
                        this.printUsage(false);
                        throw new IllegalArgumentException("Unrecognized option " + args[index]);
                    }
                    return index;
                }
                index = newIndex;
            }
            return args.length;
        }

        public void printUsage(boolean printLongDoc) {
            System.err.println(this.summary);
            int i = 0;
            while (i < this.options.size()) {
                CommandOption o = (CommandOption)this.options.get(i);
                System.err.println("--" + o.name + " " + o.argName + "\n  " + o.shortdoc);
                if (o.longdoc != null && printLongDoc) {
                    System.err.println("  " + o.longdoc);
                }
                System.err.println("  Default is " + o.defaultValueToString());
                ++i;
            }
        }

        public void logOptions(Logger logger) {
            int i = 0;
            while (i < this.options.size()) {
                CommandOption o = (CommandOption)this.options.get(i);
                logger.info(java.lang.String.valueOf(o.name) + " = " + o.valueToString());
                ++i;
            }
        }
    }

    public static interface ListProviding {
        public List getCommandOptionList();
    }

    public static class Object
    extends CommandOption {
        public java.lang.Object value;
        public java.lang.Object defaultValue;

        public Object(Class owner, java.lang.String name, java.lang.String argName, boolean argRequired, java.lang.Object defaultValue, java.lang.String shortdoc, java.lang.String longdoc) {
            super(owner, name, argName, java.lang.Object.class, argRequired, shortdoc, longdoc);
            this.defaultValue = this.value = defaultValue;
        }

        public java.lang.Object value() {
            return this.value;
        }

        @Override
        public void parseArg(java.lang.String arg) {
            try {
                this.value = interpreter.eval(arg);
            }
            catch (EvalError e) {
                throw new IllegalArgumentException("Java interpreter eval error\n" + e);
            }
        }

        @Override
        public java.lang.String defaultValueToString() {
            return this.defaultValue == null ? null : this.defaultValue.toString();
        }

        @Override
        public java.lang.String valueToString() {
            return this.value == null ? null : this.value.toString();
        }
    }

    public static class ObjectFromBean
    extends Object {
        public ObjectFromBean(Class owner, java.lang.String name, java.lang.String argName, boolean argRequired, java.lang.Object defValue, java.lang.String shortdoc, java.lang.String longdoc) {
            super(owner, name, argName, argRequired, java.lang.Object.class, shortdoc, longdoc);
            this.defaultValue = this.value = defValue;
        }

        @Override
        public java.lang.Object value() {
            return this.value;
        }

        @Override
        public void parseArg(java.lang.String arg) {
            java.lang.String[] fields = arg.split(",");
            java.lang.String constructorName = fields[0];
            if (constructorName.contains("(") || constructorName.contains(";")) {
                super.parseArg(arg);
            } else {
                super.parseArg("new " + constructorName + "()");
            }
            Method[] methods = this.value.getClass().getMethods();
            int i = 1;
            while (i < fields.length) {
                java.lang.Object parameterValueObject;
                java.lang.String[] nameValuePair = fields[i].split("=");
                java.lang.String parameterName = nameValuePair[0];
                java.lang.String parameterValue = nameValuePair[1];
                try {
                    parameterValueObject = ObjectFromBean.getInterpreter().eval(parameterValue);
                }
                catch (EvalError e) {
                    throw new IllegalArgumentException("Java interpreter eval error on parameter " + parameterName + "\n" + e);
                }
                boolean foundSetter = false;
                int j = 0;
                while (j < methods.length) {
                    if (("set" + Character.toUpperCase(parameterName.charAt(0)) + parameterName.substring(1)).equals(methods[j].getName()) && methods[j].getParameterTypes().length == 1) {
                        try {
                            java.lang.Object[] parameterList = new java.lang.Object[]{parameterValueObject};
                            methods[j].invoke(this.value, parameterList);
                        }
                        catch (IllegalAccessException e) {
                            System.out.println("IllegalAccessException " + e);
                            throw new IllegalArgumentException("Java access error calling setter\n" + e);
                        }
                        catch (InvocationTargetException e) {
                            System.out.println("IllegalTargetException " + e);
                            throw new IllegalArgumentException("Java target error calling setter\n" + e);
                        }
                        foundSetter = true;
                        break;
                    }
                    ++j;
                }
                if (!foundSetter) {
                    System.out.println("Parameter " + parameterName + " not found on trainer " + constructorName);
                    System.out.println("Available parameters for " + constructorName);
                    j = 0;
                    while (j < methods.length) {
                        if (methods[j].getName().startsWith("set") && methods[j].getParameterTypes().length == 1) {
                            System.out.println(java.lang.String.valueOf(Character.toLowerCase(methods[j].getName().charAt(3))) + methods[j].getName().substring(4));
                        }
                        ++j;
                    }
                    throw new IllegalArgumentException("no setter found for parameter " + parameterName);
                }
                ++i;
            }
        }

        @Override
        public java.lang.String defaultValueToString() {
            return this.defaultValue == null ? null : this.defaultValue.toString();
        }

        @Override
        public java.lang.String valueToString() {
            return this.value == null ? null : this.value.toString();
        }
    }

    public static class Set
    extends CommandOption {
        public java.lang.String value;
        public java.lang.String defaultValue;
        java.lang.String[] setContents;
        java.lang.String contentsString;

        public Set(Class owner, java.lang.String name, java.lang.String argName, boolean argRequired, java.lang.String[] setContents, int defaultIndex, java.lang.String shortdoc, java.lang.String longdoc) {
            super(owner, name, argName, java.io.File.class, argRequired, shortdoc, longdoc);
            this.defaultValue = this.value = setContents[defaultIndex];
            this.setContents = setContents;
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < setContents.length) {
                sb.append(setContents[i]);
                sb.append(",");
                ++i;
            }
            this.contentsString = sb.toString();
        }

        public java.lang.String value() {
            return this.value;
        }

        @Override
        public void parseArg(java.lang.String arg) {
            this.value = null;
            int i = 0;
            while (i < this.setContents.length) {
                if (this.setContents[i].equals(arg)) {
                    this.value = this.setContents[i];
                }
                ++i;
            }
            if (this.value == null) {
                throw new IllegalArgumentException("Unrecognized option argument \"" + arg + "\" not in set " + this.contentsString);
            }
        }

        @Override
        public java.lang.String defaultValueToString() {
            return this.defaultValue;
        }

        @Override
        public java.lang.String valueToString() {
            return this.value;
        }
    }

    public static class SpacedStrings
    extends CommandOption {
        public java.lang.String[] value;
        public java.lang.String[] defaultValue;

        public SpacedStrings(Class owner, java.lang.String name, java.lang.String argName, boolean argRequired, java.lang.String[] defaultValue, java.lang.String shortdoc, java.lang.String longdoc) {
            super(owner, name, argName, java.lang.String.class, argRequired, shortdoc, longdoc);
            this.value = defaultValue;
            this.defaultValue = defaultValue;
        }

        public java.lang.String[] value() {
            return this.value;
        }

        @Override
        public int parseArg(java.lang.String[] args, int index) {
            int count = 0;
            this.value = null;
            while (index < args.length && (args[index].length() < 2 || args[index].charAt(0) != '-' && args[index].charAt(1) != '-')) {
                java.lang.String[] oldValue = this.value;
                this.value = new java.lang.String[++count];
                if (oldValue != null) {
                    System.arraycopy(oldValue, 0, this.value, 0, oldValue.length);
                }
                this.value[count - 1] = args[index];
                ++index;
            }
            return index;
        }

        @Override
        public java.lang.String defaultValueToString() {
            if (this.defaultValue == null) {
                return "(null)";
            }
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.defaultValue.length) {
                sb.append(this.defaultValue[i]);
                if (i < this.defaultValue.length - 1) {
                    sb.append(" ");
                }
                ++i;
            }
            return sb.toString();
        }

        @Override
        public java.lang.String valueToString() {
            if (this.value == null) {
                return "(null)";
            }
            java.lang.String val = "";
            int i = 0;
            while (i < this.value.length) {
                val = java.lang.String.valueOf(val) + this.value[i] + " ";
                ++i;
            }
            return val;
        }
    }

    public static class String
    extends CommandOption {
        public java.lang.String value;
        public java.lang.String defaultValue;

        public String(Class owner, java.lang.String name, java.lang.String argName, boolean argRequired, java.lang.String defaultValue, java.lang.String shortdoc, java.lang.String longdoc) {
            super(owner, name, argName, java.lang.String.class, argRequired, shortdoc, longdoc);
            this.defaultValue = this.value = defaultValue;
        }

        public java.lang.String value() {
            return this.value;
        }

        @Override
        public void parseArg(java.lang.String arg) {
            this.value = arg;
        }

        @Override
        public java.lang.String defaultValueToString() {
            return this.defaultValue;
        }

        @Override
        public java.lang.String valueToString() {
            return this.value;
        }
    }
}

