/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureSequence;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Sequence;
import cc.mallet.types.Token;
import cc.mallet.util.PropertyList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

public class TokenSequence
extends ArrayList<Token>
implements Sequence,
Serializable {
    PropertyList properties = null;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public TokenSequence(Collection<Token> tokens) {
        super(tokens);
    }

    public TokenSequence() {
    }

    public TokenSequence(int capacity) {
        super(capacity);
    }

    public TokenSequence(Token[] tokens) {
        this(tokens.length);
        int i = 0;
        while (i < tokens.length) {
            this.add(tokens[i]);
            ++i;
        }
    }

    public TokenSequence(Object[] tokens) {
        this(tokens.length);
        int i = 0;
        while (i < tokens.length) {
            this.add(new Token(tokens[i].toString()));
            ++i;
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TokenSequence " + super.toString() + "\n");
        int i = 0;
        while (i < this.size()) {
            String tt = ((Token)this.get(i)).toString();
            sb.append("Token#" + i + ":");
            sb.append(tt);
            if (!tt.endsWith("\n")) {
                sb.append("\n");
            }
            ++i;
        }
        return sb.toString();
    }

    public String toStringShort() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.size()) {
            String tt = ((Token)this.get(i)).toString();
            tt.replaceAll("\n", "");
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(tt);
            ++i;
        }
        return sb.toString();
    }

    public void add(String string) {
        this.add(new Token(string));
    }

    @Override
    public Object removeLast() {
        if (this.size() > 0) {
            return this.remove(this.size() - 1);
        }
        return null;
    }

    public void addAll(Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof Token) {
                this.add((Token)objects[i]);
            } else {
                this.add(new Token(objects[i].toString()));
            }
            ++i;
        }
    }

    public FeatureSequence toFeatureSequence(Alphabet dict) {
        FeatureSequence fs = new FeatureSequence(dict, this.size());
        int i = 0;
        while (i < this.size()) {
            fs.add(dict.lookupIndex(((Token)this.get(i)).getText()));
            ++i;
        }
        return fs;
    }

    public FeatureVector toFeatureVector(Alphabet dict) {
        return new FeatureVector(this.toFeatureSequence(dict));
    }

    public void setNumericProperty(String key, double value) {
        this.properties = PropertyList.add(key, value, this.properties);
    }

    public void setProperty(String key, Object value) {
        this.properties = PropertyList.add(key, value, this.properties);
    }

    public double getNumericProperty(String key) {
        return this.properties.lookupNumber(key);
    }

    public Object getProperty(String key) {
        return this.properties.lookupObject(key);
    }

    public boolean hasProperty(String key) {
        return this.properties.hasProperty(key);
    }

    public PropertyList getProperties() {
        return this.properties;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version2 = in.readInt();
        in.defaultReadObject();
    }
}

