/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.util.CommandOption;
import java.util.LinkedHashMap;

public class StringKernel
extends LinkedHashMap {
    static final boolean DEFAULT_NORMALIZE_CASE = true;
    static final double DEFAULT_LAMBDA = 0.5;
    static final int DEFAULT_LENGTH = 3;
    static final boolean DEFAULT_CACHE = true;
    boolean normalizeCase;
    double lambda;
    int n;
    boolean cache;
    static CommandOption.String string1Option = new CommandOption.String(StringKernel.class, "string1", "FILE", true, null, "String one", null);
    static CommandOption.String string2Option = new CommandOption.String(StringKernel.class, "string2", "FILE", true, null, "String two", null);
    static final CommandOption.List commandOptions = new CommandOption.List("String Kernel.", new CommandOption[]{string1Option, string2Option});

    public StringKernel(boolean norm, double lam, int length, boolean cache) {
        this.normalizeCase = norm;
        this.lambda = lam;
        this.n = length;
        this.cache = cache;
    }

    public StringKernel() {
        this(true, 0.5, 3, true);
    }

    public StringKernel(boolean norm, double lam, int length) {
        this(norm, lam, length, true);
    }

    public double K(String s2, String t) {
        double tt;
        double ss;
        Double sstmp = (Double)this.get(s2);
        Double tttmp = (Double)this.get(t);
        if (sstmp == null) {
            ss = this.sK(s2, s2, this.n);
            if (this.cache) {
                this.put(s2, new Double(ss));
            }
        } else {
            ss = sstmp;
        }
        if (tttmp == null) {
            tt = this.sK(t, t, this.n);
            if (this.cache) {
                this.put(t, new Double(tt));
            }
        } else {
            tt = tttmp;
        }
        double st = this.sK(s2, t, this.n);
        return st / Math.sqrt(ss * tt);
    }

    private double sK(String s2, String t, int n) {
        int k;
        double r = 0.0;
        int slen = s2.length();
        int tlen = t.length();
        double[][] K2 = new double[n + 1][(slen + 1) * (tlen + 1)];
        int j = 0;
        while (j < slen + 1) {
            k = 0;
            while (k < tlen + 1) {
                K2[0][k * (slen + 1) + j] = 1.0;
                ++k;
            }
            ++j;
        }
        int i = 0;
        while (i < n) {
            j = 0;
            while (j < slen) {
                double sum = 0.0;
                k = 0;
                while (k < tlen) {
                    if (t.charAt(k) == s2.charAt(j)) {
                        sum += K2[i][k * (slen + 1) + j];
                    }
                    K2[i + 1][(k + 1) * (slen + 1) + j + 1] = K2[i + 1][(k + 1) * (slen + 1) + j] + sum;
                    ++k;
                }
                ++j;
            }
            r += K2[i + 1][tlen * (slen + 1) + slen];
            ++i;
        }
        return r;
    }

    public static void main(String[] args) throws Exception {
        commandOptions.process(args);
        StringKernel sk = new StringKernel();
        System.err.println("String Kernel for " + StringKernel.string1Option.value + " and " + StringKernel.string2Option.value + " is " + sk.K(StringKernel.string1Option.value, StringKernel.string2Option.value));
    }
}

