/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.Alphabet;
import cc.mallet.types.AugmentableFeatureVector;
import cc.mallet.types.DenseVector;
import cc.mallet.types.FeatureSelection;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.InstanceList;
import cc.mallet.types.SparseVector;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedList;

public class RankedFeatureVector
extends FeatureVector {
    int[] rankOrder;
    private static final int SORTINIT = -1;
    int sortedTo = -1;

    public RankedFeatureVector(Alphabet dict, int[] indices, double[] values) {
        super(dict, indices, values);
    }

    public RankedFeatureVector(Alphabet dict, double[] values) {
        super(dict, values);
    }

    private static double[] subArray(double[] a, int begin, int length) {
        double[] ret = new double[length];
        System.arraycopy(a, begin, ret, 0, length);
        return ret;
    }

    public RankedFeatureVector(Alphabet dict, double[] values, int begin, int length) {
        super(dict, RankedFeatureVector.subArray(values, begin, length));
    }

    public RankedFeatureVector(Alphabet dict, DenseVector v) {
        this(dict, v.values);
    }

    public RankedFeatureVector(Alphabet dict, AugmentableFeatureVector v) {
        super(dict, v.indices, v.values, v.size, v.size, true, true, true);
    }

    public RankedFeatureVector(Alphabet dict, SparseVector v) {
        super(dict, v.indices, v.values);
    }

    protected void setRankOrder() {
        this.rankOrder = new int[this.values.length];
        LinkedList<EntryWithOriginalIndex> rankedEntries = new LinkedList<EntryWithOriginalIndex>();
        int i = 0;
        while (i < this.rankOrder.length) {
            assert (!Double.isNaN(this.values[i]));
            rankedEntries.add(new EntryWithOriginalIndex(this.values[i], i));
            ++i;
        }
        Collections.sort(rankedEntries);
        i = 0;
        for (EntryWithOriginalIndex entry : rankedEntries) {
            this.rankOrder[i++] = entry._originalIndex;
        }
    }

    protected void setRankOrder(int extent, boolean reset) {
        int i;
        int sortExtent;
        int n = sortExtent = extent >= this.values.length ? this.values.length - 1 : extent;
        if (this.sortedTo == -1 || reset) {
            this.rankOrder = new int[this.values.length];
            i = 0;
            while (i < this.rankOrder.length) {
                this.rankOrder[i] = i;
                assert (!Double.isNaN(this.values[i]));
                ++i;
            }
        }
        i = this.sortedTo + 1;
        while (i <= sortExtent) {
            double max = this.values[this.rankOrder[i]];
            int maxIndex = i;
            int j = i + 1;
            while (j < this.rankOrder.length) {
                if (this.values[this.rankOrder[j]] > max) {
                    max = this.values[this.rankOrder[j]];
                    maxIndex = j;
                }
                ++j;
            }
            int r = this.rankOrder[maxIndex];
            this.rankOrder[maxIndex] = this.rankOrder[i];
            this.rankOrder[i] = r;
            this.sortedTo = i++;
        }
    }

    protected void setReverseRankOrder(int extent, boolean reset) {
        int i;
        int sortExtent;
        int n = sortExtent = extent >= this.values.length ? this.values.length - 1 : extent;
        if (this.sortedTo == -1 || reset) {
            this.rankOrder = new int[this.values.length];
            i = 0;
            while (i < this.rankOrder.length) {
                this.rankOrder[i] = i;
                assert (!Double.isNaN(this.values[i]));
                ++i;
            }
        }
        i = this.sortedTo + 1;
        while (i <= sortExtent) {
            double min2 = this.values[this.rankOrder[i]];
            int minIndex = i;
            int j = i + 1;
            while (j < this.rankOrder.length) {
                if (this.values[this.rankOrder[j]] < min2) {
                    min2 = this.values[this.rankOrder[j]];
                    minIndex = j;
                }
                ++j;
            }
            int r = this.rankOrder[minIndex];
            this.rankOrder[minIndex] = this.rankOrder[i];
            this.rankOrder[i] = r;
            this.sortedTo = i++;
        }
    }

    protected void setRankOrder(int extent) {
        this.setRankOrder(extent, false);
    }

    public int getMaxValuedIndex() {
        if (this.rankOrder == null) {
            this.setRankOrder(0);
        }
        return this.getIndexAtRank(0);
    }

    public Object getMaxValuedObject() {
        return this.dictionary.lookupObject(this.getMaxValuedIndex());
    }

    public int getMaxValuedIndexIn(FeatureSelection fs) {
        if (fs == null) {
            return this.getMaxValuedIndex();
        }
        assert (fs.getAlphabet() == this.dictionary);
        int i = 0;
        while (!fs.contains(this.rankOrder[i])) {
            this.setRankOrder(i);
            ++i;
        }
        return this.getIndexAtRank(i);
    }

    public Object getMaxValuedObjectIn(FeatureSelection fs) {
        return this.dictionary.lookupObject(this.getMaxValuedIndexIn(fs));
    }

    public double getMaxValue() {
        if (this.rankOrder == null) {
            this.setRankOrder(0);
        }
        return this.values[this.rankOrder[0]];
    }

    public double getMaxValueIn(FeatureSelection fs) {
        if (fs == null) {
            return this.getMaxValue();
        }
        int i = 0;
        while (!fs.contains(i)) {
            this.setRankOrder(i);
            ++i;
        }
        return this.values[this.rankOrder[i]];
    }

    public int getIndexAtRank(int rank) {
        this.setRankOrder(rank);
        return this.indexAtLocation(this.rankOrder[rank]);
    }

    public Object getObjectAtRank(int rank) {
        this.setRankOrder(rank);
        return this.dictionary.lookupObject(this.getIndexAtRank(rank));
    }

    public double getValueAtRank(int rank) {
        if (this.values == null) {
            return 1.0;
        }
        this.setRankOrder(rank);
        if (rank >= this.rankOrder.length) {
            rank = this.rankOrder.length - 1;
            System.err.println("rank larger than rankOrder.length. rank = " + rank + "rankOrder.length = " + this.rankOrder.length);
        }
        if (this.rankOrder[rank] >= this.values.length) {
            System.err.println("rankOrder[rank] out of range.");
            return 1.0;
        }
        return this.values[this.rankOrder[rank]];
    }

    public void printByRank(OutputStream out) {
        this.printByRank(new PrintWriter((Writer)new OutputStreamWriter(out), true));
    }

    public void printByRank(PrintWriter out) {
        int rank = 0;
        while (rank < this.numLocations()) {
            int idx = this.getIndexAtRank(rank);
            double val = this.getValueAtRank(rank);
            Object obj = this.dictionary.lookupObject(idx);
            out.print(obj + ":" + val + " ");
            ++rank;
        }
    }

    public void printTopK(PrintWriter out, int num) {
        int length = this.numLocations();
        if (num > length) {
            num = length;
        }
        int rank = 0;
        while (rank < num) {
            int idx = this.getIndexAtRank(rank);
            double val = this.getValueAtRank(rank);
            Object obj = this.dictionary.lookupObject(idx);
            out.print(obj + ":" + val + " ");
            ++rank;
        }
    }

    public void printLowerK(PrintWriter out, int num) {
        int length = this.numLocations();
        assert (num < length);
        int rank = length - num;
        while (rank < length) {
            int idx = this.getIndexAtRank(rank);
            double val = this.getValueAtRank(rank);
            Object obj = this.dictionary.lookupObject(idx);
            out.print(obj + ":" + val + " ");
            ++rank;
        }
    }

    public int getRank(Object o) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public int getRank(int index) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void set(int i, double v) {
        throw new UnsupportedOperationException(String.valueOf(RankedFeatureVector.class.getName()) + " is immutable");
    }

    private static class EntryWithOriginalIndex
    implements Comparable<EntryWithOriginalIndex> {
        private final double _value;
        private final int _originalIndex;

        public EntryWithOriginalIndex(double value, int originalIndex) {
            this._value = value;
            this._originalIndex = originalIndex;
        }

        @Override
        public int compareTo(EntryWithOriginalIndex other) {
            return Double.compare(other._value, this._value);
        }
    }

    public static interface Factory {
        public RankedFeatureVector newRankedFeatureVector(InstanceList var1);
    }

    public static interface PerLabelFactory {
        public RankedFeatureVector[] newRankedFeatureVectors(InstanceList var1);
    }
}

