/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.pipe.Noop;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.Label;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.MatrixOps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.dgc.VMID;
import java.util.BitSet;
import java.util.Random;

public class PagedInstanceList
extends InstanceList {
    private static final char TYPE_FEATURE_VECTOR = 'F';
    private static final char TYPE_LABEL = 'L';
    private static final char TYPE_OBJECT = 'O';
    int instancesPerPage;
    File swapDir;
    int[] inMemoryPageIds;
    InstanceList[] inMemoryPages;
    BitSet dirty = new BitSet();
    int size = 0;
    boolean collectGarbage = true;
    int swapIns = 0;
    long swapInTime = 0L;
    int swapOuts = 0;
    long swapOutTime = 0L;
    VMID id = new VMID();
    Pipe noopPipe;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public PagedInstanceList(Pipe pipe, int numPages, int instancesPerPage, File swapDir) {
        super(pipe, numPages * instancesPerPage);
        this.instancesPerPage = instancesPerPage;
        this.swapDir = swapDir;
        this.inMemoryPageIds = new int[numPages];
        this.inMemoryPages = new InstanceList[numPages];
        this.noopPipe = new Noop(pipe.getDataAlphabet(), pipe.getTargetAlphabet());
        int i = 0;
        while (i < numPages) {
            this.inMemoryPageIds[i] = -1;
            ++i;
        }
        try {
            if (!swapDir.exists()) {
                swapDir.mkdir();
            }
        }
        catch (SecurityException e) {
            System.err.println("No permission to make directory " + swapDir);
            System.exit(-1);
        }
    }

    public PagedInstanceList(Pipe pipe, int numPages, int instancesPerPage) {
        this(pipe, numPages, instancesPerPage, new File("."));
    }

    private void shuffleArray(Random r, int[] a) {
        int size = a.length;
        int i = size - 1;
        while (i > 0) {
            int swap = r.nextInt(i + 1);
            int tmp = a[i];
            a[i] = a[swap];
            a[swap] = tmp;
            --i;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public InstanceList[] split(Random r, double[] proportions) {
        ret = new InstanceList[proportions.length];
        maxind = (double[])proportions.clone();
        size = this.size();
        shuffled = new int[size];
        splits = new int[size];
        i = 0;
        while (i < size) {
            shuffled[i] = i;
            ++i;
        }
        this.shuffleArray(r, shuffled);
        MatrixOps.normalize(maxind);
        i = 0;
        while (i < maxind.length) {
            ret[i] = this.cloneEmpty();
            if (i > 0) {
                v0 = i;
                maxind[v0] = maxind[v0] + maxind[i - 1];
            }
            ++i;
        }
        i = 0;
        while (i < maxind.length) {
            maxind[i] = Math.rint(maxind[i] * (double)size);
            ++i;
        }
        i = 0;
        j = 0;
        ** GOTO lbl35
        {
            ++j;
            do {
                if ((double)i >= maxind[j] && j < ret.length) continue block3;
                splits[shuffled[i]] = j;
                ++i;
lbl35:
                // 2 sources

            } while (i < size);
        }
        i = 0;
        while (i < size) {
            ret[splits[i]].add(this.get(i));
            ++i;
        }
        return ret;
    }

    private File getFileForPage(int page) {
        return new File(this.swapDir, this.id + "." + page);
    }

    private InstanceList getPageForIndex(int index, boolean dirty) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.swapIn(index / this.instancesPerPage, dirty);
    }

    private InstanceList swapIn(int pageId, boolean dirty) {
        int bin = pageId % this.inMemoryPages.length;
        if (this.inMemoryPageIds[bin] != pageId) {
            long startTime;
            block16: {
                this.swapOut(this.inMemoryPageIds[bin]);
                startTime = System.currentTimeMillis();
                File pageFile = this.getFileForPage(pageId);
                ObjectInputStream in = null;
                try {
                    try {
                        in = new ObjectInputStream(new FileInputStream(pageFile));
                        InstanceList page = this.deserializePage(in);
                        this.inMemoryPageIds[bin] = pageId;
                        this.inMemoryPages[bin] = page;
                    }
                    catch (Exception e) {
                        System.err.println(e);
                        System.exit(-1);
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception e2) {
                                System.err.println(e2);
                                System.exit(-1);
                            }
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception e) {
                            System.err.println(e);
                            System.exit(-1);
                        }
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {
                        System.err.println(e);
                        System.exit(-1);
                    }
                }
            }
            ++this.swapIns;
            this.swapInTime += System.currentTimeMillis() - startTime;
        }
        if (dirty) {
            this.dirty.set(bin);
        }
        return this.inMemoryPages[bin];
    }

    private void swapOut(int pageId) {
        int bin = pageId % this.inMemoryPages.length;
        if (pageId != -1 && this.dirty.get(bin)) {
            long startTime;
            block16: {
                startTime = System.currentTimeMillis();
                File pageFile = this.getFileForPage(pageId);
                ObjectOutputStream out = null;
                try {
                    try {
                        out = new ObjectOutputStream(new FileOutputStream(pageFile));
                        InstanceList page = this.inMemoryPages[bin];
                        this.inMemoryPageIds[bin] = -1;
                        this.inMemoryPages[bin] = null;
                        this.serializePage(out, page);
                        this.dirty.set(bin, false);
                    }
                    catch (Exception e) {
                        System.err.println(e);
                        System.exit(-1);
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Exception e2) {
                                System.err.println(e2);
                                System.exit(-1);
                            }
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception e) {
                            System.err.println(e);
                            System.exit(-1);
                        }
                    }
                    throw throwable;
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception e) {
                        System.err.println(e);
                        System.exit(-1);
                    }
                }
            }
            if (this.collectGarbage) {
                System.gc();
            }
            ++this.swapOuts;
            this.swapOutTime += System.currentTimeMillis() - startTime;
        }
    }

    @Override
    public boolean add(Instance instance) {
        InstanceList page;
        if (this.size % this.instancesPerPage == 0) {
            int pageId = this.size / this.instancesPerPage;
            int bin = pageId % this.inMemoryPages.length;
            this.swapOut(this.inMemoryPageIds[bin]);
            page = new InstanceList(this.noopPipe);
            this.inMemoryPageIds[bin] = pageId;
            this.inMemoryPages[bin] = page;
        } else {
            page = this.getPageForIndex(this.size, true);
        }
        boolean ret = page.add(instance);
        if (ret) {
            ++this.size;
        }
        return ret;
    }

    @Override
    public Instance get(int index) {
        InstanceList page = this.getPageForIndex(index, false);
        return (Instance)page.get(index % this.instancesPerPage);
    }

    @Override
    public Instance set(int index, Instance instance) {
        InstanceList page = this.getPageForIndex(index, true);
        return page.set(index % this.instancesPerPage, instance);
    }

    public boolean getCollectGarbage() {
        return this.collectGarbage;
    }

    public void setCollectGarbage(boolean b) {
        this.collectGarbage = b;
    }

    @Override
    public InstanceList shallowClone() {
        InstanceList ret = this.cloneEmpty();
        int i = 0;
        while (i < this.size()) {
            ret.add(this.get(i));
            ++i;
        }
        return ret;
    }

    @Override
    public InstanceList cloneEmpty() {
        return super.cloneEmptyInto(new PagedInstanceList(this.pipe, this.inMemoryPages.length, this.instancesPerPage, this.swapDir));
    }

    @Override
    public void clear() {
        int numPages = this.size / this.instancesPerPage;
        int i = 0;
        while (i <= numPages) {
            this.getFileForPage(i).delete();
            ++i;
        }
        i = 0;
        while (i < this.inMemoryPages.length) {
            this.inMemoryPages[i] = null;
            this.inMemoryPageIds[i] = -1;
            ++i;
        }
        this.size = 0;
        this.swapIns = 0;
        this.swapInTime = 0L;
        this.swapOuts = 0;
        this.swapOutTime = 0L;
        this.dirty.clear();
        super.clear();
    }

    public int getSwapIns() {
        return this.swapIns;
    }

    public long getSwapInTime() {
        return this.swapInTime;
    }

    public int getSwapOuts() {
        return this.swapOuts;
    }

    public long getSwapOutTime() {
        return this.swapOutTime;
    }

    @Override
    public int size() {
        return this.size;
    }

    private void serializeObject(ObjectOutputStream out, Object obj) throws IOException {
        if (obj instanceof FeatureVector) {
            FeatureVector features = (FeatureVector)obj;
            out.writeChar(70);
            out.writeObject(features.getIndices());
            out.writeObject(features.getValues());
        } else if (obj instanceof Label) {
            out.writeChar(76);
            out.writeObject(((Label)obj).toString());
        } else {
            out.writeChar(79);
            out.writeObject(obj);
        }
    }

    private void serializePage(ObjectOutputStream out, InstanceList page) throws IOException {
        out.writeInt(page.size());
        for (Instance inst : page) {
            this.serializeObject(out, inst.getData());
            this.serializeObject(out, inst.getTarget());
            out.writeObject(inst.getName());
            out.writeObject(inst.getSource());
            if (this.instWeights != null) {
                Double weight = (Double)this.instWeights.get(inst);
                if (weight != null) {
                    out.writeDouble((Double)this.instWeights.get(inst));
                    continue;
                }
                out.writeDouble(1.0);
                continue;
            }
            out.writeDouble(1.0);
        }
    }

    private Object deserializeObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object obj;
        char type = in.readChar();
        switch (type) {
            case 'L': {
                LabelAlphabet ldict = (LabelAlphabet)this.getTargetAlphabet();
                String name = (String)in.readObject();
                obj = ldict.lookupLabel(name);
                break;
            }
            case 'F': {
                int[] indices = (int[])in.readObject();
                double[] values = (double[])in.readObject();
                obj = new FeatureVector(this.getDataAlphabet(), indices, values);
                break;
            }
            case 'O': {
                obj = in.readObject();
                break;
            }
            default: {
                throw new IOException("Unknown object type " + type);
            }
        }
        return obj;
    }

    private InstanceList deserializePage(ObjectInputStream in) throws IOException, ClassNotFoundException {
        InstanceList page = new InstanceList(this.noopPipe);
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            Object data = this.deserializeObject(in);
            Object target = this.deserializeObject(in);
            Object name = in.readObject();
            Object source = in.readObject();
            double weight = in.readDouble();
            page.add(new Instance(data, target, name, source), weight);
            ++i;
        }
        return page;
    }

    public static InstanceList load(File file) {
        try {
            ObjectInputStream ois = file.toString().equals("-") ? new ObjectInputStream(System.in) : new ObjectInputStream(new FileInputStream(file));
            PagedInstanceList ilist = (PagedInstanceList)ois.readObject();
            ois.close();
            return ilist;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Couldn't read PagedInstanceList from file " + file);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.id);
        out.writeObject(this.pipe);
        out.writeInt(this.instancesPerPage);
        out.writeObject(this.swapDir);
        out.writeObject(this.inMemoryPageIds);
        out.writeObject(this.dirty);
        int i = 0;
        while (i < this.inMemoryPages.length) {
            this.serializePage(out, this.inMemoryPages[i]);
            ++i;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.id = (VMID)in.readObject();
        this.pipe = (Pipe)in.readObject();
        this.instancesPerPage = in.readInt();
        this.swapDir = (File)in.readObject();
        this.inMemoryPageIds = (int[])in.readObject();
        this.dirty = (BitSet)in.readObject();
        this.inMemoryPages = new InstanceList[this.inMemoryPageIds.length];
        int i = 0;
        while (i < this.inMemoryPageIds.length) {
            this.inMemoryPages[i] = this.deserializePage(in);
            ++i;
        }
    }
}

