/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.FeatureSelection;
import cc.mallet.types.Vector;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Random;

public final class MatrixOps {
    public static void setAll(double[] m3, double v) {
        Arrays.fill(m3, v);
    }

    public static void set(double[] dest, double[] source) {
        if (source.length != dest.length) {
            dest = new double[source.length];
        }
        System.arraycopy(source, 0, dest, 0, source.length);
    }

    public static void timesEquals(double[] m3, double factor) {
        int i = 0;
        while (i < m3.length) {
            int n = i++;
            m3[n] = m3[n] * factor;
        }
    }

    public static void timesEquals(double[] m1, double[] m22) {
        assert (m1.length == m22.length) : "unequal lengths\n";
        int i = 0;
        while (i < m1.length) {
            int n = i;
            m1[n] = m1[n] * m22[i];
            ++i;
        }
    }

    public static void plusEquals(double[] m3, double toadd) {
        int i = 0;
        while (i < m3.length) {
            int n = i++;
            m3[n] = m3[n] + toadd;
        }
    }

    public static void plusEquals(double[] m1, double[] m22) {
        assert (m1.length == m22.length) : "unequal lengths\n";
        int i = 0;
        while (i < m1.length) {
            if (Double.isInfinite(m1[i]) && Double.isInfinite(m22[i]) && m1[i] * m22[i] < 0.0) {
                m1[i] = 0.0;
            } else {
                int n = i;
                m1[n] = m1[n] + m22[i];
            }
            ++i;
        }
    }

    public static void plusEquals(double[] m1, double[] m22, double factor) {
        assert (m1.length == m22.length) : "unequal lengths\n";
        int i = 0;
        while (i < m1.length) {
            double m1i = m1[i];
            double m2i = m22[i];
            if (Double.isInfinite(m1i) && Double.isInfinite(m2i) && m1[i] * m22[i] < 0.0) {
                m1[i] = 0.0;
            } else {
                int n = i;
                m1[n] = m1[n] + m22[i] * factor;
            }
            ++i;
        }
    }

    public static void plusEquals(double[][] m1, double[][] m22, double factor) {
        assert (m1.length == m22.length) : "unequal lengths\n";
        int i = 0;
        while (i < m1.length) {
            int j = 0;
            while (j < m1[i].length) {
                double[] dArray = m1[i];
                int n = j;
                dArray[n] = dArray[n] + m22[i][j] * factor;
                ++j;
            }
            ++i;
        }
    }

    public static void log(double[] m3) {
        int i = 0;
        while (i < m3.length) {
            m3[i] = Math.log(m3[i]);
            ++i;
        }
    }

    public static double dot(double[] m1, double[] m22) {
        assert (m1.length == m22.length) : "m1.length != m2.length\n";
        double ret = 0.0;
        int i = 0;
        while (i < m1.length) {
            ret += m1[i] * m22[i];
            ++i;
        }
        return ret;
    }

    public static double dotProduct(double[] m1, double[] m22) {
        assert (m1.length == m22.length) : "m1.length != m2.length\n";
        double ret = 0.0;
        int i = 0;
        while (i < m1.length) {
            ret += m1[i] * m22[i];
            ++i;
        }
        return ret;
    }

    public static double absNorm(double[] m3) {
        double ret = 0.0;
        int i = 0;
        while (i < m3.length) {
            ret += Math.abs(m3[i]);
            ++i;
        }
        return ret;
    }

    public static double twoNorm(double[] m3) {
        double ret = 0.0;
        int i = 0;
        while (i < m3.length) {
            ret += m3[i] * m3[i];
            ++i;
        }
        return Math.sqrt(ret);
    }

    public static double twoNormSquared(double[] m3) {
        double ret = 0.0;
        int i = 0;
        while (i < m3.length) {
            ret += m3[i] * m3[i];
            ++i;
        }
        return ret;
    }

    public static double oneNorm(double[] m3) {
        double ret = 0.0;
        int i = 0;
        while (i < m3.length) {
            ret += m3[i];
            ++i;
        }
        return ret;
    }

    public static double oneNormalize(double[] m3) {
        double sum = MatrixOps.oneNorm(m3);
        int i = 0;
        while (i < m3.length) {
            int n = i++;
            m3[n] = m3[n] / sum;
        }
        return sum;
    }

    public static double normalize(double[] m3) {
        return MatrixOps.oneNormalize(m3);
    }

    public static double infinityNorm(double[] m3) {
        double ret = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < m3.length) {
            if (Math.abs(m3[i]) > ret) {
                ret = Math.abs(m3[i]);
            }
            ++i;
        }
        return ret;
    }

    public static double absNormalize(double[] m3) {
        double norm = MatrixOps.absNorm(m3);
        if (norm > 0.0) {
            int i = 0;
            while (i < m3.length) {
                int n = i++;
                m3[n] = m3[n] / norm;
            }
        }
        return norm;
    }

    public static double twoNormalize(double[] m3) {
        double norm = MatrixOps.twoNorm(m3);
        if (norm > 0.0) {
            int i = 0;
            while (i < m3.length) {
                int n = i++;
                m3[n] = m3[n] / norm;
            }
        }
        return norm;
    }

    public static void substitute(double[] m3, double oldValue, double newValue) {
        int i = m3.length - 1;
        while (i >= 0) {
            if (m3[i] == oldValue) {
                m3[i] = newValue;
            }
            --i;
        }
    }

    public static final void rowSetAll(double[] m3, int nc, int ri, double v, FeatureSelection fselection, boolean ifSelected) {
        block4: {
            block3: {
                if (fselection != null) break block3;
                if (!ifSelected) break block4;
                int ci = 0;
                while (ci < nc) {
                    m3[ri * nc + ci] = v;
                    ++ci;
                }
                break block4;
            }
            int ci = 0;
            while (ci < nc) {
                if (fselection.contains(ci) ^ !ifSelected) {
                    m3[ri * nc + ci] = v;
                }
                ++ci;
            }
        }
    }

    public static double rowDotProduct(double[] m3, int nc, int ri, Vector v, int maxCi, FeatureSelection selection) {
        return MatrixOps.rowDotProduct(m3, nc, ri, v, 1.0, maxCi, selection);
    }

    public static double rowDotProduct(double[] m3, int nc, int ri, Vector v, double factor, int maxCi, FeatureSelection selection) {
        double ret = 0.0;
        if (selection != null) {
            int size = v.numLocations();
            int cil = 0;
            while (cil < size) {
                int ci = v.indexAtLocation(cil);
                if (selection.contains(ci) && ci < nc && ci <= maxCi) {
                    ret += m3[ri * nc + ci] * v.valueAtLocation(cil) * factor;
                }
                ++cil;
            }
        } else {
            int size = v.numLocations();
            int cil = 0;
            while (cil < size) {
                int ci = v.indexAtLocation(cil);
                if (ci <= maxCi) {
                    ret += m3[ri * nc + ci] * v.valueAtLocation(cil) * factor;
                }
                ++cil;
            }
        }
        return ret;
    }

    public static final void rowPlusEquals(double[] m3, int nc, int ri, Vector v, double factor) {
        int vli = 0;
        while (vli < v.numLocations()) {
            int n = ri * nc + v.indexAtLocation(vli);
            m3[n] = m3[n] + v.valueAtLocation(vli) * factor;
            ++vli;
        }
    }

    public static boolean isNaN(double[] m3) {
        int i = 0;
        while (i < m3.length) {
            if (Double.isNaN(m3[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isInfinite(double[] m3) {
        int i = 0;
        while (i < m3.length) {
            if (Double.isInfinite(m3[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isNaNOrInfinite(double[] m3) {
        int i = 0;
        while (i < m3.length) {
            if (Double.isInfinite(m3[i]) || Double.isNaN(m3[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isNonZero(double[] m3) {
        int i = 0;
        while (i < m3.length) {
            if (Math.abs(m3[i]) > 0.0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isZero(double[] m3) {
        int i = 0;
        while (i < m3.length) {
            if (Math.abs(m3[i]) == 0.0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static double sum(double[] m3) {
        double sum = 0.0;
        int i = 0;
        while (i < m3.length) {
            sum += m3[i];
            ++i;
        }
        return sum;
    }

    public static double sum(double[][] m3) {
        double sum = 0.0;
        int i = 0;
        while (i < m3.length) {
            int j = 0;
            while (j < m3[i].length) {
                sum += m3[i][j];
                ++j;
            }
            ++i;
        }
        return sum;
    }

    public static int sum(int[] m3) {
        int sum = 0;
        int i = 0;
        while (i < m3.length) {
            sum += m3[i];
            ++i;
        }
        return sum;
    }

    public static double sum(Vector v) {
        double sum = 0.0;
        int vli = 0;
        while (vli < v.numLocations()) {
            sum += v.valueAtLocation(vli);
            ++vli;
        }
        return sum;
    }

    public static double mean(double[] m3) {
        double sum = 0.0;
        int i = 0;
        while (i < m3.length) {
            sum += m3[i];
            ++i;
        }
        return sum / (double)m3.length;
    }

    public static double stddev(double[] m3) {
        double mean = MatrixOps.mean(m3);
        double s2 = 0.0;
        int i = 0;
        while (i < m3.length) {
            s2 += (m3[i] - mean) * (m3[i] - mean);
            ++i;
        }
        return Math.sqrt(s2 / (double)m3.length);
    }

    public static double stderr(double[] m3) {
        return MatrixOps.stddev(m3) / Math.sqrt(m3.length);
    }

    public static double variance(double[] m3) {
        double mean = MatrixOps.mean(m3);
        double s2 = 0.0;
        int i = 0;
        while (i < m3.length) {
            s2 += (m3[i] - mean) * (m3[i] - mean);
            ++i;
        }
        return s2 / (double)m3.length;
    }

    public static final void print(double[] m3) {
        MatrixOps.print(new PrintWriter((Writer)new OutputStreamWriter(System.out), true), m3);
    }

    public static final void print(PrintWriter out, double[] m3) {
        int i = 0;
        while (i < m3.length) {
            out.print(" " + m3[i]);
            ++i;
        }
        out.println("");
    }

    public static final void print(double[][] arr) {
        int i = 0;
        while (i < arr.length) {
            double[] doubles = arr[i];
            MatrixOps.print(doubles);
            ++i;
        }
    }

    public static final String toString(Object m3) {
        StringBuffer sb = new StringBuffer();
        int n = Array.getLength(m3) - 1;
        int i = 0;
        while (i < n) {
            sb.append(Array.get(m3, i));
            sb.append(" ");
            ++i;
        }
        if (n >= 0) {
            sb.append(Array.get(m3, n));
        }
        return sb.toString();
    }

    public static final void printInRows(double[] arr) {
        int i = 0;
        while (i < arr.length) {
            double v = arr[i];
            System.out.println("[" + i + "]  " + arr[i]);
            ++i;
        }
    }

    public static void setAll(double[][][] m3, double v) {
        int i = 0;
        while (i < m3.length) {
            int j = 0;
            while (j < m3[i].length) {
                int k = 0;
                while (k < m3[i][j].length) {
                    m3[i][j][k] = v;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static void setAll(double[][] m3, double v) {
        int i = 0;
        while (i < m3.length) {
            int j = 0;
            while (j < m3[i].length) {
                m3[i][j] = v;
                ++j;
            }
            ++i;
        }
    }

    public static void print(int[][] arr) {
        int i = 0;
        while (i < arr.length) {
            MatrixOps.print(arr[i]);
            ++i;
        }
    }

    public static void print(int[] m3) {
        int i = 0;
        while (i < m3.length) {
            System.out.print(" " + m3[i]);
            ++i;
        }
        System.out.println("");
    }

    public static double[] randomVector(int n, Random r) {
        double[] ret = new double[n];
        int i = 0;
        while (i < n) {
            ret[i] = r.nextDouble();
            ++i;
        }
        return ret;
    }

    public static void timesEquals(double[][] m3, double factor) {
        int i = 0;
        while (i < m3.length) {
            int j = 0;
            while (j < m3[i].length) {
                double[] dArray = m3[i];
                int n = j++;
                dArray[n] = dArray[n] * factor;
            }
            ++i;
        }
    }

    public static double maxAbsdiff(double[] v1, double[] v2) {
        double max = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < v1.length) {
            double val = Math.abs(v1[i] - v2[i]);
            if (val > max) {
                max = val;
            }
            ++i;
        }
        return max;
    }

    public static int max(int[][] m3) {
        int maxval = m3[0][0];
        int i = 0;
        while (i < m3.length) {
            int j = 0;
            while (j < m3[i].length) {
                if (m3[i][j] > maxval) {
                    maxval = m3[i][j];
                }
                ++j;
            }
            ++i;
        }
        return maxval;
    }

    public static int max(int[] elems) {
        int max = Integer.MIN_VALUE;
        int i = 0;
        while (i < elems.length) {
            int elem = elems[i];
            if (elem > max) {
                max = elem;
            }
            ++i;
        }
        return max;
    }

    public static double max(double[] elems) {
        double max = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < elems.length) {
            double elem = elems[i];
            if (elem > max) {
                max = elem;
            }
            ++i;
        }
        return max;
    }

    public static double min(double[] elems) {
        double min2 = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < elems.length) {
            double elem = elems[i];
            if (elem < min2) {
                min2 = elem;
            }
            ++i;
        }
        return min2;
    }

    public static int maxIndex(double[] elems) {
        double max = Double.NEGATIVE_INFINITY;
        int maxIndex = -1;
        int i = 0;
        while (i < elems.length) {
            double elem = elems[i];
            if (elem > max) {
                max = elem;
                maxIndex = i;
            }
            ++i;
        }
        return maxIndex;
    }

    public static int minIndex(double[] elems) {
        double min2 = Double.POSITIVE_INFINITY;
        int minIndex = -1;
        int i = 0;
        while (i < elems.length) {
            double elem = elems[i];
            if (elem < min2) {
                min2 = elem;
                minIndex = i;
            }
            ++i;
        }
        return minIndex;
    }

    public static double[] append(double[] original, double newValue) {
        double[] ret = new double[original.length + 1];
        System.arraycopy(original, 0, ret, 0, original.length);
        ret[original.length] = newValue;
        return ret;
    }

    public static double max(double[][] ds) {
        double max = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < ds.length) {
            int j = 0;
            while (j < ds[i].length) {
                if (ds[i][j] > max) {
                    max = ds[i][j];
                }
                ++j;
            }
            ++i;
        }
        return max;
    }

    public static int[] maxIndex(double[][] ds) {
        int[] maxIndices = new int[]{-1, -1};
        double max = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < ds.length) {
            int j = 0;
            while (j < ds[i].length) {
                if (ds[i][j] > max) {
                    max = ds[i][j];
                    maxIndices[0] = i;
                    maxIndices[1] = j;
                }
                ++j;
            }
            ++i;
        }
        return maxIndices;
    }

    public static void expNormalize(double[] scores) {
        double max = MatrixOps.max(scores);
        double sum = 0.0;
        int i = 0;
        while (i < scores.length) {
            scores[i] = Math.exp(scores[i] - max);
            sum += scores[i];
            ++i;
        }
        i = 0;
        while (i < scores.length) {
            int n = i++;
            scores[n] = scores[n] / sum;
        }
    }
}

