/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.Alphabet;
import cc.mallet.types.AlphabetCarrying;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.LabelVector;
import cc.mallet.types.Labeling;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Label
implements Labeling,
Serializable,
AlphabetCarrying {
    Object entry;
    LabelAlphabet dictionary;
    int index;
    static final double weightOfLabel = 1.0;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    protected Label() {
        throw new IllegalStateException("Label objects can only be created by their Alphabet.");
    }

    Label(Object entry, LabelAlphabet dict, int index) {
        this.entry = entry;
        this.dictionary = dict;
        assert (dict.lookupIndex(entry, false) == index);
        this.index = index;
    }

    @Override
    public LabelAlphabet getLabelAlphabet() {
        return this.dictionary;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public Alphabet getAlphabet() {
        return this.dictionary;
    }

    @Override
    public Alphabet[] getAlphabets() {
        return new Alphabet[]{this.dictionary};
    }

    public Object getEntry() {
        return this.entry;
    }

    public String toString() {
        return this.entry.toString();
    }

    public int compareTo(Object o) {
        Label os = (Label)o;
        if (this.index < os.index) {
            return -1;
        }
        if (this.index == os.index) {
            return 0;
        }
        return 1;
    }

    @Override
    public Label getBestLabel() {
        return this;
    }

    @Override
    public int getBestIndex() {
        return this.index;
    }

    @Override
    public double getBestValue() {
        return 1.0;
    }

    @Override
    public double value(Label label) {
        assert (label.dictionary.equals(this.dictionary));
        return 1.0;
    }

    @Override
    public double value(int labelIndex) {
        return labelIndex == this.index ? 1.0 : 0.0;
    }

    @Override
    public int getRank(Label label) {
        assert (label.dictionary.equals(this.dictionary));
        return label == this ? 0 : -1;
    }

    @Override
    public int getRank(int labelIndex) {
        return labelIndex == this.index ? 0 : -1;
    }

    @Override
    public Label getLabelAtRank(int rank) {
        assert (rank == 0);
        return this;
    }

    @Override
    public double getValueAtRank(int rank) {
        assert (rank == 0);
        return 1.0;
    }

    @Override
    public void addTo(double[] weights) {
        int n = this.index;
        weights[n] = weights[n] + 1.0;
    }

    @Override
    public void addTo(double[] weights, double scale) {
        int n = this.index;
        weights[n] = weights[n] + 1.0 * scale;
    }

    @Override
    public int numLocations() {
        return 1;
    }

    @Override
    public Label labelAtLocation(int loc) {
        assert (loc == 0);
        return this;
    }

    @Override
    public double valueAtLocation(int loc) {
        assert (loc == 0);
        return 1.0;
    }

    @Override
    public int indexAtLocation(int loc) {
        assert (loc == 0);
        return this.index;
    }

    @Override
    public LabelVector toLabelVector() {
        return new LabelVector(this.dictionary, new int[]{this.index}, new double[]{1.0});
    }

    public boolean equals(Object l) {
        if (l instanceof Label) {
            return ((Label)l).compareTo(this) == 0;
        }
        throw new IllegalArgumentException("Cannot compare a Label object with a " + l.getClass().getName() + " object.");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeObject(this.dictionary);
        out.writeInt(this.index);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version2 = in.readInt();
        this.dictionary = (LabelAlphabet)in.readObject();
        this.index = in.readInt();
        this.entry = this.dictionary.lookupObject(this.index);
    }
}

