/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.pipe.FeatureSequence2FeatureVector;
import cc.mallet.pipe.Noop;
import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.SerialPipes;
import cc.mallet.pipe.Target2Label;
import cc.mallet.pipe.TokenSequence2FeatureSequence;
import cc.mallet.pipe.iterator.RandomTokenSequenceIterator;
import cc.mallet.types.Alphabet;
import cc.mallet.types.AlphabetCarrying;
import cc.mallet.types.Dirichlet;
import cc.mallet.types.FeatureSelection;
import cc.mallet.types.Instance;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.LabelVector;
import cc.mallet.types.Labeling;
import cc.mallet.types.MatrixOps;
import cc.mallet.types.SingleInstanceIterator;
import cc.mallet.util.MalletLogger;
import cc.mallet.util.Randoms;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Logger;

public class InstanceList
extends ArrayList<Instance>
implements Serializable,
Iterable<Instance>,
AlphabetCarrying {
    private static Logger logger = MalletLogger.getLogger(InstanceList.class.getName());
    HashMap<Instance, Double> instWeights = null;
    FeatureSelection featureSelection = null;
    FeatureSelection[] perLabelFeatureSelection = null;
    Pipe pipe;
    Alphabet dataAlphabet;
    Alphabet targetAlphabet;
    Class dataClass = null;
    Class targetClass = null;
    static final Pipe notYetSetPipe = new NotYetSetPipe();
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;
    public static final String TARGET_PROPERTY = "target";

    public InstanceList(Pipe pipe, int capacity) {
        super(capacity);
        this.pipe = pipe;
    }

    public InstanceList(Pipe pipe) {
        this(pipe, 10);
    }

    public InstanceList(Alphabet dataAlphabet, Alphabet targetAlphabet) {
        this(new Noop(dataAlphabet, targetAlphabet), 10);
        this.dataAlphabet = dataAlphabet;
        this.targetAlphabet = targetAlphabet;
    }

    @Deprecated
    public InstanceList() {
        this(notYetSetPipe);
    }

    public InstanceList(Randoms r, Dirichlet classCentroidDistribution, double classCentroidAverageAlphaMean, double classCentroidAverageAlphaVariance, double featureVectorSizePoissonLambda, double classInstanceCountPoissonLambda, String[] classNames) {
        this(new SerialPipes(new Pipe[]{new TokenSequence2FeatureSequence(), new FeatureSequence2FeatureVector(), new Target2Label()}));
        RandomTokenSequenceIterator iter = new RandomTokenSequenceIterator(r, classCentroidDistribution, classCentroidAverageAlphaMean, classCentroidAverageAlphaVariance, featureVectorSizePoissonLambda, classInstanceCountPoissonLambda, classNames);
        this.addThruPipe(iter);
    }

    private static Alphabet dictOfSize(int size) {
        Alphabet ret = new Alphabet();
        int i = 0;
        while (i < size) {
            ret.lookupIndex("feature" + i);
            ++i;
        }
        return ret;
    }

    private static String[] classNamesOfSize(int size) {
        String[] ret = new String[size];
        int i = 0;
        while (i < size) {
            ret[i] = "class" + i;
            ++i;
        }
        return ret;
    }

    public InstanceList(Randoms r, Alphabet vocab, String[] classNames, int meanInstancesPerLabel) {
        this(r, new Dirichlet(vocab, 2.0), 30.0, 0.0, 10.0, meanInstancesPerLabel, classNames);
    }

    public InstanceList(Randoms r, int vocabSize, int numClasses) {
        this(r, new Dirichlet(InstanceList.dictOfSize(vocabSize), 2.0), 30.0, 0.0, 10.0, 20.0, InstanceList.classNamesOfSize(numClasses));
    }

    public InstanceList shallowClone() {
        InstanceList ret = new InstanceList(this.pipe, this.size());
        int i = 0;
        while (i < this.size()) {
            ret.add((Instance)this.get(i));
            ++i;
        }
        ret.instWeights = this.instWeights == null ? null : (HashMap)this.instWeights.clone();
        ret.featureSelection = this.featureSelection;
        ret.perLabelFeatureSelection = this.perLabelFeatureSelection;
        ret.pipe = this.pipe;
        ret.dataAlphabet = this.dataAlphabet;
        ret.targetAlphabet = this.targetAlphabet;
        ret.dataClass = this.dataClass;
        ret.targetClass = this.targetClass;
        return ret;
    }

    @Override
    public Object clone() {
        return this.shallowClone();
    }

    public InstanceList subList(int start, int end) {
        InstanceList other = this.cloneEmpty();
        int i = start;
        while (i < end) {
            other.add((Instance)this.get(i));
            ++i;
        }
        return other;
    }

    public InstanceList subList(double proportion) {
        if (proportion > 1.0) {
            throw new IllegalArgumentException("proportion must by <= 1.0");
        }
        InstanceList other = (InstanceList)this.clone();
        other.shuffle(new Random());
        proportion *= (double)other.size();
        int i = 0;
        while ((double)i < proportion) {
            other.add((Instance)this.get(i));
            ++i;
        }
        return other;
    }

    public void addThruPipe(Iterator<Instance> ii) {
        Iterator<Instance> pipedInstanceIterator = this.pipe.newIteratorFrom(ii);
        while (pipedInstanceIterator.hasNext()) {
            this.add(pipedInstanceIterator.next());
        }
    }

    public void addThruPipe(Instance inst) {
        this.addThruPipe(new SingleInstanceIterator(inst));
    }

    @Deprecated
    public boolean add(Object data, Object target, Object name, Object source, double instanceWeight) {
        Instance inst = new Instance(data, target, name, source);
        Iterator<Instance> ii = this.pipe.newIteratorFrom(new SingleInstanceIterator(inst));
        if (ii.hasNext()) {
            this.add(ii.next(), instanceWeight);
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean add(Object data, Object target, Object name, Object source) {
        return this.add(data, target, name, source, 1.0);
    }

    @Override
    public boolean add(Instance instance) {
        if (this.dataAlphabet == null) {
            this.dataAlphabet = instance.getDataAlphabet();
        }
        if (this.targetAlphabet == null) {
            this.targetAlphabet = instance.getTargetAlphabet();
        }
        if (!Alphabet.alphabetsMatch(this, instance)) {
            Alphabet data_alphabet = instance.getDataAlphabet();
            Alphabet target_alphabet = instance.getTargetAlphabet();
            StringBuilder sb = new StringBuilder();
            sb.append("Alphabets don't match: ");
            sb.append("Instance: [" + (data_alphabet == null ? null : Integer.valueOf(data_alphabet.size())) + ", " + (target_alphabet == null ? null : Integer.valueOf(target_alphabet.size())) + "], ");
            data_alphabet = this.getDataAlphabet();
            target_alphabet = this.getTargetAlphabet();
            sb.append("InstanceList: [" + (data_alphabet == null ? null : Integer.valueOf(data_alphabet.size())) + ", " + (target_alphabet == null ? null : Integer.valueOf(target_alphabet.size())) + "]\n");
            throw new IllegalArgumentException(sb.toString());
        }
        if (this.dataClass == null) {
            this.dataClass = instance.data.getClass();
            if (this.pipe != null && this.pipe.isTargetProcessing() && instance.target != null) {
                this.targetClass = instance.target.getClass();
            }
        }
        instance.lock();
        return super.add(instance);
    }

    public boolean add(Instance instance, double instanceWeight) {
        boolean ret = this.add(instance);
        if (!ret) {
            return ret;
        }
        if (instanceWeight != 1.0) {
            if (this.instWeights == null) {
                this.instWeights = new HashMap();
            } else if (this.instWeights.get(instance) != null) {
                throw new IllegalArgumentException("You cannot add the same instance twice to an InstanceList when it has non-1.0 weight.  Trying adding instance.shallowCopy() instead.");
            }
            this.instWeights.put(instance, instanceWeight);
        }
        return ret;
    }

    private void prepareToRemove(Instance instance) {
        if (this.instWeights != null) {
            this.instWeights.remove(instance);
        }
    }

    @Override
    public Instance set(int index, Instance instance) {
        this.prepareToRemove((Instance)this.get(index));
        return super.set(index, instance);
    }

    @Override
    public void add(int index, Instance element) {
        throw new IllegalStateException("Not yet implemented.");
    }

    @Override
    public Instance remove(int index) {
        this.prepareToRemove((Instance)this.get(index));
        return (Instance)super.remove(index);
    }

    public boolean remove(Instance instance) {
        this.prepareToRemove(instance);
        return super.remove(instance);
    }

    @Override
    public boolean addAll(Collection<? extends Instance> instances) {
        for (Instance instance : instances) {
            this.add(instance);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Instance> c) {
        throw new IllegalStateException("addAll(int,Collection) not supported by InstanceList.n");
    }

    @Override
    public void clear() {
        super.clear();
        this.instWeights.clear();
    }

    @Deprecated
    public double noisify(double ratio) {
        assert (ratio >= 0.0 && ratio <= 1.0);
        int instance_size = this.size();
        int noise_instance_num = (int)(ratio * (double)instance_size);
        Random r = new Random();
        ArrayList<Integer> randnumlist = new ArrayList<Integer>(noise_instance_num);
        int i = 0;
        while (i < noise_instance_num) {
            int randIndex = r.nextInt(instance_size);
            Integer nn = new Integer(randIndex);
            if (randnumlist.indexOf(nn) != -1) {
                --i;
            } else {
                randnumlist.add(nn);
            }
            ++i;
        }
        LabelAlphabet targets = (LabelAlphabet)this.pipe.getTargetAlphabet();
        int realRandNum = 0;
        for (Integer index : randnumlist) {
            String newTargetStr;
            Instance inst = (Instance)this.get(index);
            int randIndex = r.nextInt(targets.size());
            String oldTargetStr = inst.getTarget().toString();
            if (!oldTargetStr.equals(newTargetStr = targets.lookupLabel(randIndex).toString())) {
                inst.unLock();
                inst.setTarget(targets.lookupLabel(randIndex));
                inst.lock();
                ++realRandNum;
            }
            this.setInstance(index, inst);
        }
        double realRatio = (double)realRandNum / (double)instance_size;
        return realRatio;
    }

    public InstanceList cloneEmpty() {
        return this.cloneEmptyInto(new InstanceList(this.pipe));
    }

    protected InstanceList cloneEmptyInto(InstanceList ret) {
        ret.instWeights = null;
        ret.featureSelection = this.featureSelection;
        ret.perLabelFeatureSelection = this.perLabelFeatureSelection;
        ret.dataClass = this.dataClass;
        ret.targetClass = this.targetClass;
        ret.dataAlphabet = this.dataAlphabet;
        ret.targetAlphabet = this.targetAlphabet;
        return ret;
    }

    public void shuffle(Random r) {
        Collections.shuffle(this, r);
    }

    public InstanceList[] split(Random r, double[] proportions) {
        InstanceList shuffled = this.shallowClone();
        shuffled.shuffle(r);
        return shuffled.splitInOrder(proportions);
    }

    public InstanceList[] split(double[] proportions) {
        return this.split(new Random(System.currentTimeMillis()), proportions);
    }

    /*
     * Unable to fully structure code
     */
    public InstanceList[] splitInOrder(double[] proportions) {
        ret = new InstanceList[proportions.length];
        maxind = (double[])proportions.clone();
        MatrixOps.normalize(maxind);
        i = 0;
        while (i < maxind.length) {
            ret[i] = this.cloneEmpty();
            if (i > 0) {
                v0 = i;
                maxind[v0] = maxind[v0] + maxind[i - 1];
            }
            ++i;
        }
        i = 0;
        while (i < maxind.length) {
            maxind[i] = Math.rint(maxind[i] * (double)this.size());
            ++i;
        }
        i = 0;
        j = 0;
        ** GOTO lbl27
        {
            ++j;
            do {
                if ((double)i >= maxind[j] && j < ret.length) continue block2;
                ret[j].add((Instance)this.get(i));
                ++i;
lbl27:
                // 2 sources

            } while (i < this.size());
        }
        return ret;
    }

    public InstanceList[] splitInOrder(int[] counts) {
        InstanceList[] ret = new InstanceList[counts.length];
        int idx = 0;
        int num = 0;
        while (num < counts.length) {
            ret[num] = this.cloneEmpty();
            int i = 0;
            while (i < counts[num]) {
                ret[num].add((Instance)this.get(idx));
                ++idx;
                ++i;
            }
            ++num;
        }
        return ret;
    }

    public InstanceList[] splitInTwoByModulo(int m3) {
        InstanceList[] ret = new InstanceList[]{this.cloneEmpty(), this.cloneEmpty()};
        int i = 0;
        while (i < this.size()) {
            if (i % m3 == 0) {
                ret[0].add((Instance)this.get(i));
            } else {
                ret[1].add((Instance)this.get(i));
            }
            ++i;
        }
        return ret;
    }

    public InstanceList sampleWithReplacement(Random r, int numSamples) {
        InstanceList ret = this.cloneEmpty();
        int i = 0;
        while (i < numSamples) {
            ret.add((Instance)this.get(r.nextInt(this.size())));
            ++i;
        }
        return ret;
    }

    @Deprecated
    public InstanceList sampleWithInstanceWeights(Random r) {
        double[] weights = new double[this.size()];
        int i = 0;
        while (i < weights.length) {
            weights[i] = this.getInstanceWeight(i);
            ++i;
        }
        return this.sampleWithWeights(r, weights);
    }

    public InstanceList sampleWithWeights(Random r, double[] weights) {
        if (weights.length != this.size()) {
            throw new IllegalArgumentException("length of weight vector must equal number of instances");
        }
        if (this.size() == 0) {
            return this.cloneEmpty();
        }
        double sumOfWeights = 0.0;
        int i = 0;
        while (i < this.size()) {
            if (weights[i] < 0.0) {
                throw new IllegalArgumentException("weight vector must be non-negative");
            }
            sumOfWeights += weights[i];
            ++i;
        }
        if (sumOfWeights <= 0.0) {
            throw new IllegalArgumentException("weights must sum to positive value");
        }
        InstanceList newList = new InstanceList(this.getPipe(), this.size());
        double[] probabilities = new double[this.size()];
        double sumProbs = 0.0;
        int i2 = 0;
        while (i2 < this.size()) {
            probabilities[i2] = sumProbs += r.nextDouble();
            ++i2;
        }
        MatrixOps.timesEquals(probabilities, sumOfWeights / sumProbs);
        probabilities[this.size() - 1] = sumOfWeights;
        int a = 0;
        int b = 0;
        sumProbs = 0.0;
        while (a < this.size() && b < this.size()) {
            sumProbs += weights[b];
            while (a < this.size() && probabilities[a] <= sumProbs) {
                newList.add((Instance)this.get(b));
                newList.setInstanceWeight(a, 1.0);
                ++a;
            }
            ++b;
        }
        return newList;
    }

    public Class getDataClass() {
        return this.dataClass;
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    public void setInstance(int index, Instance instance) {
        assert (this.getDataAlphabet().equals(instance.getDataAlphabet()));
        assert (this.getTargetAlphabet().equals(instance.getTargetAlphabet()));
        this.set(index, instance);
    }

    public double getInstanceWeight(Instance instance) {
        Double value;
        if (this.instWeights != null && (value = this.instWeights.get(instance)) != null) {
            return value;
        }
        return 1.0;
    }

    public double getInstanceWeight(int index) {
        Double value;
        if (index > this.size()) {
            throw new IllegalArgumentException("Index out of bounds: index=" + index + " size=" + this.size());
        }
        if (this.instWeights != null && (value = this.instWeights.get(this.get(index))) != null) {
            return value;
        }
        return 1.0;
    }

    public void setInstanceWeight(int index, double weight) {
        this.setInstanceWeight((Instance)this.get(index), weight);
    }

    public void setInstanceWeight(Instance instance, double weight) {
        if (weight == 1.0) {
            if (this.instWeights == null) {
                return;
            }
            Double value = this.instWeights.get(instance);
            if (value == null || value == weight) {
                return;
            }
            this.instWeights.remove(instance);
        } else {
            if (this.instWeights == null) {
                this.instWeights = new HashMap();
            }
            this.instWeights.put(instance, weight);
        }
    }

    public void setFeatureSelection(FeatureSelection selectedFeatures) {
        if (selectedFeatures != null && selectedFeatures.getAlphabet() != null && selectedFeatures.getAlphabet() != this.getDataAlphabet()) {
            throw new IllegalArgumentException("Vocabularies do not match");
        }
        this.featureSelection = selectedFeatures;
    }

    public FeatureSelection getFeatureSelection() {
        return this.featureSelection;
    }

    public void setPerLabelFeatureSelection(FeatureSelection[] selectedFeatures) {
        if (selectedFeatures != null) {
            int i = 0;
            while (i < selectedFeatures.length) {
                if (selectedFeatures[i].getAlphabet() != this.getDataAlphabet()) {
                    throw new IllegalArgumentException("Vocabularies do not match");
                }
                ++i;
            }
        }
        this.perLabelFeatureSelection = selectedFeatures;
    }

    public FeatureSelection[] getPerLabelFeatureSelection() {
        return this.perLabelFeatureSelection;
    }

    public void removeTargets() {
        for (Instance instance : this) {
            instance.setTarget(null);
        }
    }

    public void removeSources() {
        int i = 0;
        while (i < this.size()) {
            ((Instance)this.get(i)).clearSource();
            ++i;
        }
    }

    public static InstanceList load(File file) {
        try {
            ObjectInputStream ois = file.toString().equals("-") ? new ObjectInputStream(System.in) : new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            InstanceList ilist = (InstanceList)ois.readObject();
            ois.close();
            return ilist;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Couldn't read InstanceList from file " + file);
        }
    }

    public void save(File file) {
        try {
            ObjectOutputStream ois = file.toString().equals("-") ? new ObjectOutputStream(System.out) : new ObjectOutputStream(new FileOutputStream(file));
            ois.writeObject(this);
            ois.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Couldn't save InstanceList to file " + file);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.instWeights);
        out.writeObject(this.pipe);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Instance instance;
        int version2 = in.readInt();
        this.instWeights = (HashMap)in.readObject();
        this.pipe = (Pipe)in.readObject();
        if (this.dataAlphabet == null) {
            if (this.size() > 0) {
                instance = (Instance)this.get(0);
                this.dataAlphabet = instance.getDataAlphabet();
            } else if (this.pipe.getDataAlphabet() != null) {
                this.dataAlphabet = this.pipe.getDataAlphabet();
            }
        }
        if (this.targetAlphabet == null) {
            if (this.size() > 0) {
                instance = (Instance)this.get(0);
                this.targetAlphabet = instance.getTargetAlphabet();
            } else if (this.pipe.getTargetAlphabet() != null) {
                this.targetAlphabet = this.pipe.getTargetAlphabet();
            }
        }
    }

    public Pipe getPipe() {
        return this.pipe;
    }

    public void setPipe(Pipe p) {
        assert (Alphabet.alphabetsMatch(this, p));
        this.pipe = p;
    }

    public Alphabet getDataAlphabet() {
        if (this.dataAlphabet == null && this.pipe != null) {
            this.dataAlphabet = this.pipe.getDataAlphabet();
        }
        assert (this.pipe == null || this.pipe.getDataAlphabet() == null || this.pipe.getDataAlphabet() == this.dataAlphabet);
        return this.dataAlphabet;
    }

    public Alphabet getTargetAlphabet() {
        if (this.targetAlphabet == null && this.pipe != null) {
            this.targetAlphabet = this.pipe.getTargetAlphabet();
        }
        assert (this.pipe == null || this.pipe.getTargetAlphabet() == null || this.pipe.getTargetAlphabet() == this.targetAlphabet);
        return this.targetAlphabet;
    }

    @Override
    public Alphabet getAlphabet() {
        return this.getDataAlphabet();
    }

    @Override
    public Alphabet[] getAlphabets() {
        return new Alphabet[]{this.getDataAlphabet(), this.getTargetAlphabet()};
    }

    public LabelVector targetLabelDistribution() {
        if (this.size() == 0) {
            return null;
        }
        if (!(((Instance)this.get(0)).getTarget() instanceof Labeling)) {
            throw new IllegalStateException("Target is not a labeling.");
        }
        double[] counts = new double[this.getTargetAlphabet().size()];
        int i = 0;
        while (i < this.size()) {
            Instance instance = (Instance)this.get(i);
            Labeling l = (Labeling)instance.getTarget();
            l.addTo(counts, this.getInstanceWeight(i));
            ++i;
        }
        return new LabelVector((LabelAlphabet)this.getTargetAlphabet(), counts);
    }

    public CrossValidationIterator crossValidationIterator(int nfolds, int seed) {
        return new CrossValidationIterator(nfolds, seed);
    }

    public CrossValidationIterator crossValidationIterator(int nfolds) {
        return new CrossValidationIterator(nfolds);
    }

    public void hideSomeLabels(double proportionToHide, Randoms r) {
        int i = 0;
        while (i < this.size()) {
            if (r.nextBoolean(proportionToHide)) {
                Instance instance = (Instance)this.get(i);
                instance.unLock();
                if (instance.getProperty(TARGET_PROPERTY) != instance.getTarget()) {
                    instance.setProperty(TARGET_PROPERTY, instance.getTarget());
                }
                instance.setTarget(null);
                instance.lock();
            }
            ++i;
        }
    }

    public void hideSomeLabels(BitSet bs) {
        int i = 0;
        while (i < this.size()) {
            if (bs.get(i)) {
                Instance instance = (Instance)this.get(i);
                instance.unLock();
                if (instance.getProperty(TARGET_PROPERTY) != instance.getTarget()) {
                    instance.setProperty(TARGET_PROPERTY, instance.getTarget());
                }
                instance.setTarget(null);
                instance.lock();
            }
            ++i;
        }
    }

    public void unhideAllLabels() {
        int i = 0;
        while (i < this.size()) {
            Object t;
            Instance instance = (Instance)this.get(i);
            if (instance.getTarget() == null && (t = instance.getProperty(TARGET_PROPERTY)) != null) {
                instance.unLock();
                instance.setTarget(t);
                instance.lock();
            }
            ++i;
        }
    }

    public class CrossValidationIterator
    implements Iterator<InstanceList[]>,
    Serializable {
        int nfolds;
        InstanceList[] folds;
        int index;

        public CrossValidationIterator(int _nfolds, int seed) {
            assert (_nfolds > 0) : "nfolds: " + this.nfolds;
            this.nfolds = _nfolds;
            this.index = 0;
            this.folds = new InstanceList[_nfolds];
            double fraction = 1.0 / (double)_nfolds;
            double[] proportions = new double[_nfolds];
            int i = 0;
            while (i < _nfolds) {
                proportions[i] = fraction;
                ++i;
            }
            this.folds = InstanceList.this.split(new Random(seed), proportions);
        }

        public CrossValidationIterator(int _nfolds) {
            this(_nfolds, 1);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.nfolds;
        }

        public InstanceList[] nextSplit() {
            InstanceList[] ret = new InstanceList[2];
            ret[0] = new InstanceList(InstanceList.this.pipe);
            int i = 0;
            while (i < this.folds.length) {
                if (i != this.index) {
                    Iterator iter = this.folds[i].iterator();
                    while (iter.hasNext()) {
                        ret[0].add((Instance)iter.next());
                    }
                }
                ++i;
            }
            ret[1] = this.folds[this.index].shallowClone();
            ++this.index;
            return ret;
        }

        public InstanceList[] nextSplit(int numTrainFolds) {
            InstanceList[] ret = new InstanceList[]{new InstanceList(InstanceList.this.pipe), new InstanceList(InstanceList.this.pipe)};
            int i = 0;
            while (i < this.folds.length) {
                int foldno = (this.index + i) % this.folds.length;
                InstanceList addTo = i < numTrainFolds ? ret[0] : ret[1];
                Iterator iter = this.folds[foldno].iterator();
                while (iter.hasNext()) {
                    addTo.add((Instance)iter.next());
                }
                ++i;
            }
            ++this.index;
            return ret;
        }

        @Override
        public InstanceList[] next() {
            return this.nextSplit();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class NotYetSetPipe
    extends Pipe {
        private static final long serialVersionUID = 1L;

        private NotYetSetPipe() {
        }

        @Override
        public Instance pipe(Instance carrier) {
            throw new UnsupportedOperationException("The InstanceList has yet to have its pipe set; this could happen by calling InstanceList.add(InstanceList)");
        }

        @Override
        public Object readResolve() throws ObjectStreamException {
            return notYetSetPipe;
        }
    }
}

