/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.topics;

import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureSequence;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.util.Randoms;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;

public class LDA
implements Serializable {
    int numTopics;
    double alpha;
    double beta;
    double tAlpha;
    double vBeta;
    InstanceList ilist;
    int[][] topics;
    int numTypes;
    int numTokens;
    int[][] docTopicCounts;
    int[][] typeTopicCounts;
    int[] tokensPerTopic;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;
    private static final int NULL_INTEGER = -1;

    public LDA(int numberOfTopics) {
        this(numberOfTopics, 50.0, 0.01);
    }

    public LDA(int numberOfTopics, double alphaSum, double beta) {
        this.numTopics = numberOfTopics;
        this.alpha = alphaSum / (double)this.numTopics;
        this.beta = beta;
    }

    public void estimate(InstanceList documents, int numIterations, int showTopicsInterval, int outputModelInterval, String outputModelFilename, Randoms r) {
        this.ilist = documents.shallowClone();
        this.numTypes = this.ilist.getDataAlphabet().size();
        int numDocs = this.ilist.size();
        this.topics = new int[numDocs][];
        this.docTopicCounts = new int[numDocs][this.numTopics];
        this.typeTopicCounts = new int[this.numTypes][this.numTopics];
        this.tokensPerTopic = new int[this.numTopics];
        this.tAlpha = this.alpha * (double)this.numTopics;
        this.vBeta = this.beta * (double)this.numTypes;
        long startTime = System.currentTimeMillis();
        int di = 0;
        while (di < numDocs) {
            FeatureSequence fs;
            try {
                fs = (FeatureSequence)((Instance)this.ilist.get(di)).getData();
            }
            catch (ClassCastException e) {
                System.err.println("LDA and other topic models expect FeatureSequence data, not FeatureVector data.  With text2vectors, you can obtain such data with --keep-sequence or --keep-bisequence.");
                throw e;
            }
            int seqLen = fs.getLength();
            this.numTokens += seqLen;
            this.topics[di] = new int[seqLen];
            int si = 0;
            while (si < seqLen) {
                int topic;
                this.topics[di][si] = topic = r.nextInt(this.numTopics);
                int[] nArray = this.docTopicCounts[di];
                int n = topic;
                nArray[n] = nArray[n] + 1;
                int[] nArray2 = this.typeTopicCounts[fs.getIndexAtPosition(si)];
                int n2 = topic;
                nArray2[n2] = nArray2[n2] + 1;
                int n3 = topic;
                this.tokensPerTopic[n3] = this.tokensPerTopic[n3] + 1;
                ++si;
            }
            ++di;
        }
        this.estimate(0, numDocs, numIterations, showTopicsInterval, outputModelInterval, outputModelFilename, r);
    }

    public void addDocuments(InstanceList additionalDocuments, int numIterations, int showTopicsInterval, int outputModelInterval, String outputModelFilename, Randoms r) {
        if (this.ilist == null) {
            throw new IllegalStateException("Must already have some documents first.");
        }
        for (Instance inst : additionalDocuments) {
            this.ilist.add(inst);
        }
        assert (this.ilist.getDataAlphabet() == additionalDocuments.getDataAlphabet());
        assert (additionalDocuments.getDataAlphabet().size() >= this.numTypes);
        this.numTypes = additionalDocuments.getDataAlphabet().size();
        int numNewDocs = additionalDocuments.size();
        int numOldDocs = this.topics.length;
        int numDocs = numOldDocs + numNewDocs;
        int[][] newTopics = new int[numDocs][];
        int i = 0;
        while (i < this.topics.length) {
            newTopics[i] = this.topics[i];
            ++i;
        }
        this.topics = newTopics;
        int[][] newDocTopicCounts = new int[numDocs][this.numTopics];
        int i2 = 0;
        while (i2 < this.docTopicCounts.length) {
            newDocTopicCounts[i2] = this.docTopicCounts[i2];
            ++i2;
        }
        this.docTopicCounts = newDocTopicCounts;
        int[][] newTypeTopicCounts = new int[this.numTypes][this.numTopics];
        int i3 = 0;
        while (i3 < this.typeTopicCounts.length) {
            int j = 0;
            while (j < this.numTopics) {
                newTypeTopicCounts[i3][j] = this.typeTopicCounts[i3][j];
                ++j;
            }
            ++i3;
        }
        int di = numOldDocs;
        while (di < numDocs) {
            FeatureSequence fs;
            try {
                fs = (FeatureSequence)((Instance)additionalDocuments.get(di - numOldDocs)).getData();
            }
            catch (ClassCastException e) {
                System.err.println("LDA and other topic models expect FeatureSequence data, not FeatureVector data.  With text2vectors, you can obtain such data with --keep-sequence or --keep-bisequence.");
                throw e;
            }
            int seqLen = fs.getLength();
            this.numTokens += seqLen;
            this.topics[di] = new int[seqLen];
            int si = 0;
            while (si < seqLen) {
                int topic;
                this.topics[di][si] = topic = r.nextInt(this.numTopics);
                int[] nArray = this.docTopicCounts[di];
                int n = topic;
                nArray[n] = nArray[n] + 1;
                int[] nArray2 = this.typeTopicCounts[fs.getIndexAtPosition(si)];
                int n2 = topic;
                nArray2[n2] = nArray2[n2] + 1;
                int n3 = topic;
                this.tokensPerTopic[n3] = this.tokensPerTopic[n3] + 1;
                ++si;
            }
            ++di;
        }
    }

    public void estimate(int docIndexStart, int docIndexLength, int numIterations, int showTopicsInterval, int outputModelInterval, String outputModelFilename, Randoms r) {
        long startTime = System.currentTimeMillis();
        int iterations = 0;
        while (iterations < numIterations) {
            if (iterations % 10 == 0) {
                System.out.print(iterations);
            } else {
                System.out.print(".");
            }
            System.out.flush();
            if (showTopicsInterval != 0 && iterations % showTopicsInterval == 0 && iterations > 0) {
                System.out.println();
                this.printTopWords(5, false);
            }
            if (outputModelInterval != 0 && iterations % outputModelInterval == 0 && iterations > 0) {
                this.write(new File(String.valueOf(outputModelFilename) + '.' + iterations));
            }
            this.sampleTopicsForDocs(docIndexStart, docIndexLength, r);
            ++iterations;
        }
        long seconds = Math.round((double)(System.currentTimeMillis() - startTime) / 1000.0);
        long minutes = seconds / 60L;
        seconds %= 60L;
        long hours = minutes / 60L;
        minutes %= 60L;
        long days = hours / 24L;
        hours %= 24L;
        System.out.print("\nTotal time: ");
        if (days != 0L) {
            System.out.print(days);
            System.out.print(" days ");
        }
        if (hours != 0L) {
            System.out.print(hours);
            System.out.print(" hours ");
        }
        if (minutes != 0L) {
            System.out.print(minutes);
            System.out.print(" minutes ");
        }
        System.out.print(seconds);
        System.out.println(" seconds");
    }

    public void sampleTopicsForAllDocs(Randoms r) {
        double[] topicWeights = new double[this.numTopics];
        int di = 0;
        while (di < this.topics.length) {
            this.sampleTopicsForOneDoc((FeatureSequence)((Instance)this.ilist.get(di)).getData(), this.topics[di], this.docTopicCounts[di], topicWeights, r);
            ++di;
        }
    }

    public void sampleTopicsForDocs(int start, int length, Randoms r) {
        assert (start + length <= this.docTopicCounts.length);
        double[] topicWeights = new double[this.numTopics];
        int di = start;
        while (di < start + length) {
            this.sampleTopicsForOneDoc((FeatureSequence)((Instance)this.ilist.get(di)).getData(), this.topics[di], this.docTopicCounts[di], topicWeights, r);
            ++di;
        }
    }

    private void sampleTopicsForOneDoc(FeatureSequence oneDocTokens, int[] oneDocTopics, int[] oneDocTopicCounts, double[] topicWeights, Randoms r) {
        int docLen = oneDocTokens.getLength();
        int si = 0;
        while (si < docLen) {
            int newTopic;
            int oldTopic;
            int type = oneDocTokens.getIndexAtPosition(si);
            int n = oldTopic = oneDocTopics[si];
            oneDocTopicCounts[n] = oneDocTopicCounts[n] - 1;
            int[] nArray = this.typeTopicCounts[type];
            int n2 = oldTopic;
            nArray[n2] = nArray[n2] - 1;
            int n3 = oldTopic;
            this.tokensPerTopic[n3] = this.tokensPerTopic[n3] - 1;
            Arrays.fill(topicWeights, 0.0);
            double topicWeightsSum = 0.0;
            int[] currentTypeTopicCounts = this.typeTopicCounts[type];
            int ti = 0;
            while (ti < this.numTopics) {
                double tw = ((double)currentTypeTopicCounts[ti] + this.beta) / ((double)this.tokensPerTopic[ti] + this.vBeta) * ((double)oneDocTopicCounts[ti] + this.alpha);
                topicWeightsSum += tw;
                topicWeights[ti] = tw;
                ++ti;
            }
            oneDocTopics[si] = newTopic = r.nextDiscrete(topicWeights, topicWeightsSum);
            int n4 = newTopic;
            oneDocTopicCounts[n4] = oneDocTopicCounts[n4] + 1;
            int[] nArray2 = this.typeTopicCounts[type];
            int n5 = newTopic;
            nArray2[n5] = nArray2[n5] + 1;
            int n6 = newTopic;
            this.tokensPerTopic[n6] = this.tokensPerTopic[n6] + 1;
            ++si;
        }
    }

    public int[][] getDocTopicCounts() {
        return this.docTopicCounts;
    }

    public int[][] getTypeTopicCounts() {
        return this.typeTopicCounts;
    }

    public int[] getTokensPerTopic() {
        return this.tokensPerTopic;
    }

    public void printTopWords(int numWords, boolean useNewLines) {
        class WordProb
        implements Comparable {
            int wi;
            double p;

            public WordProb(int wi, double p) {
                this.wi = wi;
                this.p = p;
            }

            public final int compareTo(Object o2) {
                if (this.p > ((WordProb)o2).p) {
                    return -1;
                }
                if (this.p == ((WordProb)o2).p) {
                    return 0;
                }
                return 1;
            }
        }
        Object[] wp = new WordProb[this.numTypes];
        int ti = 0;
        while (ti < this.numTopics) {
            int i;
            int wi = 0;
            while (wi < this.numTypes) {
                wp[wi] = new WordProb(wi, (double)this.typeTopicCounts[wi][ti] / (double)this.tokensPerTopic[ti]);
                ++wi;
            }
            Arrays.sort(wp);
            if (useNewLines) {
                System.out.println("\nTopic " + ti);
                i = 0;
                while (i < numWords) {
                    System.out.println(String.valueOf(this.ilist.getDataAlphabet().lookupObject(((WordProb)wp[i]).wi).toString()) + " " + ((WordProb)wp[i]).p);
                    ++i;
                }
            } else {
                System.out.print("Topic " + ti + ": ");
                i = 0;
                while (i < numWords) {
                    System.out.print(String.valueOf(this.ilist.getDataAlphabet().lookupObject(((WordProb)wp[i]).wi).toString()) + " ");
                    ++i;
                }
                System.out.println();
            }
            ++ti;
        }
    }

    public void printDocumentTopics(File f) throws IOException {
        this.printDocumentTopics(new PrintWriter(new FileWriter(f)));
    }

    public void printDocumentTopics(PrintWriter pw) {
        this.printDocumentTopics(pw, 0.0, -1);
    }

    public void printDocumentTopics(PrintWriter pw, double threshold, int max) {
        pw.println("#doc source topic proportion ...");
        double[] topicDist = new double[this.topics.length];
        int di = 0;
        while (di < this.topics.length) {
            pw.print(di);
            pw.print(' ');
            if (((Instance)this.ilist.get(di)).getSource() != null) {
                pw.print(((Instance)this.ilist.get(di)).getSource().toString());
            } else {
                pw.print("null-source");
            }
            pw.print(' ');
            int docLen = this.topics[di].length;
            int ti = 0;
            while (ti < this.numTopics) {
                topicDist[ti] = (float)this.docTopicCounts[di][ti] / (float)docLen;
                ++ti;
            }
            if (max < 0) {
                max = this.numTopics;
            }
            int tp = 0;
            while (tp < max) {
                double maxvalue = 0.0;
                int maxindex = -1;
                int ti2 = 0;
                while (ti2 < this.numTopics) {
                    if (topicDist[ti2] > maxvalue) {
                        maxvalue = topicDist[ti2];
                        maxindex = ti2;
                    }
                    ++ti2;
                }
                if (maxindex == -1 || topicDist[maxindex] < threshold) break;
                pw.print(String.valueOf(maxindex) + " " + topicDist[maxindex] + " ");
                topicDist[maxindex] = 0.0;
                ++tp;
            }
            pw.println(' ');
            ++di;
        }
    }

    public void printState(File f) throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(f));
        this.printState(writer);
        writer.close();
    }

    public void printState(PrintWriter pw) {
        Alphabet a = this.ilist.getDataAlphabet();
        pw.println("#doc pos typeindex type topic");
        int di = 0;
        while (di < this.topics.length) {
            FeatureSequence fs = (FeatureSequence)((Instance)this.ilist.get(di)).getData();
            int si = 0;
            while (si < this.topics[di].length) {
                int type = fs.getIndexAtPosition(si);
                pw.print(di);
                pw.print(' ');
                pw.print(si);
                pw.print(' ');
                pw.print(type);
                pw.print(' ');
                pw.print(a.lookupObject(type));
                pw.print(' ');
                pw.print(this.topics[di][si]);
                pw.println();
                ++si;
            }
            ++di;
        }
    }

    public void write(File f) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));
            oos.writeObject(this);
            oos.close();
        }
        catch (IOException e) {
            System.err.println("Exception writing file " + f + ": " + e);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int ti;
        out.writeInt(0);
        out.writeObject(this.ilist);
        out.writeInt(this.numTopics);
        out.writeDouble(this.alpha);
        out.writeDouble(this.beta);
        out.writeDouble(this.tAlpha);
        out.writeDouble(this.vBeta);
        int di = 0;
        while (di < this.topics.length) {
            int si = 0;
            while (si < this.topics[di].length) {
                out.writeInt(this.topics[di][si]);
                ++si;
            }
            ++di;
        }
        di = 0;
        while (di < this.topics.length) {
            ti = 0;
            while (ti < this.numTopics) {
                out.writeInt(this.docTopicCounts[di][ti]);
                ++ti;
            }
            ++di;
        }
        int fi = 0;
        while (fi < this.numTypes) {
            ti = 0;
            while (ti < this.numTopics) {
                out.writeInt(this.typeTopicCounts[fi][ti]);
                ++ti;
            }
            ++fi;
        }
        int ti2 = 0;
        while (ti2 < this.numTopics) {
            out.writeInt(this.tokensPerTopic[ti2]);
            ++ti2;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int ti;
        int version2 = in.readInt();
        this.ilist = (InstanceList)in.readObject();
        this.numTopics = in.readInt();
        this.alpha = in.readDouble();
        this.beta = in.readDouble();
        this.tAlpha = in.readDouble();
        this.vBeta = in.readDouble();
        int numDocs = this.ilist.size();
        this.topics = new int[numDocs][];
        int di = 0;
        while (di < this.ilist.size()) {
            int docLen = ((FeatureSequence)((Instance)this.ilist.get(di)).getData()).getLength();
            this.topics[di] = new int[docLen];
            int si = 0;
            while (si < docLen) {
                this.topics[di][si] = in.readInt();
                ++si;
            }
            ++di;
        }
        this.docTopicCounts = new int[numDocs][this.numTopics];
        di = 0;
        while (di < this.ilist.size()) {
            ti = 0;
            while (ti < this.numTopics) {
                this.docTopicCounts[di][ti] = in.readInt();
                ++ti;
            }
            ++di;
        }
        int numTypes = this.ilist.getDataAlphabet().size();
        this.typeTopicCounts = new int[numTypes][this.numTopics];
        int fi = 0;
        while (fi < numTypes) {
            int ti2 = 0;
            while (ti2 < this.numTopics) {
                this.typeTopicCounts[fi][ti2] = in.readInt();
                ++ti2;
            }
            ++fi;
        }
        this.tokensPerTopic = new int[this.numTopics];
        ti = 0;
        while (ti < this.numTopics) {
            this.tokensPerTopic[ti] = in.readInt();
            ++ti;
        }
    }

    public InstanceList getInstanceList() {
        return this.ilist;
    }

    public static void main(String[] args) throws IOException {
        InstanceList ilist = InstanceList.load(new File(args[0]));
        int numIterations = args.length > 1 ? Integer.parseInt(args[1]) : 1000;
        int numTopWords = args.length > 2 ? Integer.parseInt(args[2]) : 20;
        System.out.println("Data loaded.");
        LDA lda = new LDA(10);
        lda.estimate(ilist, numIterations, 50, 0, null, new Randoms());
        lda.printTopWords(numTopWords, true);
        lda.printDocumentTopics(new File(String.valueOf(args[0]) + ".lda"));
    }
}

