/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.share.upenn.ner;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.io.Serializable;
import java.util.Arrays;

public class LengthBins
extends Pipe
implements Serializable {
    String name;
    int[] bins;
    String[] binNames;

    public LengthBins(String featureName, int[] binMaxes) {
        this.name = featureName;
        this.bins = binMaxes;
        Arrays.sort(this.bins);
        int min2 = 1;
        this.binNames = new String[this.bins.length + 1];
        int i = 0;
        while (i < this.bins.length) {
            this.binNames[i] = min2 == this.bins[i] ? "[" + min2 + "]" : "[" + min2 + "-" + this.bins[i] + "]";
            min2 = this.bins[i] + 1;
            ++i;
        }
        this.binNames[this.bins.length] = "[" + min2 + "+]";
    }

    @Override
    public Instance pipe(Instance carrier) {
        TokenSequence ts = (TokenSequence)carrier.getData();
        int i = 0;
        while (i < ts.size()) {
            block3: {
                Token t = (Token)ts.get(i);
                int length = t.getText().length();
                int j = 0;
                while (j < this.bins.length) {
                    if (length <= this.bins[j]) {
                        t.setFeatureValue(String.valueOf(this.name) + "=" + this.binNames[j], 1.0);
                        break block3;
                    }
                    ++j;
                }
                t.setFeatureValue(String.valueOf(this.name) + "=" + this.binNames[this.bins.length], 1.0);
            }
            ++i;
        }
        return carrier;
    }
}

