/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tsf;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TokenTextCharSuffix
extends Pipe
implements Serializable {
    String prefix;
    int suffixLength;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public TokenTextCharSuffix(String prefix, int suffixLength) {
        this.prefix = prefix;
        this.suffixLength = suffixLength;
    }

    public TokenTextCharSuffix() {
        this("SUFFIX=", 2);
    }

    @Override
    public Instance pipe(Instance carrier) {
        TokenSequence ts = (TokenSequence)carrier.getData();
        int i = 0;
        while (i < ts.size()) {
            Token t = (Token)ts.get(i);
            String s2 = t.getText();
            int slen = s2.length();
            if (slen > this.suffixLength) {
                t.setFeatureValue(String.valueOf(this.prefix) + s2.substring(slen - this.suffixLength, slen), 1.0);
            }
            ++i;
        }
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeObject(this.prefix);
        out.writeInt(this.suffixLength);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version2 = in.readInt();
        this.prefix = (String)in.readObject();
        this.suffixLength = in.readInt();
    }
}

