/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tsf;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.regex.Pattern;

public class TokenText
extends Pipe
implements Serializable {
    String prefix;
    Pattern matchingRegex;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public TokenText(String prefix, Pattern matchingRegex) {
        this.prefix = prefix;
        this.matchingRegex = matchingRegex;
    }

    public TokenText(String prefix) {
        this.prefix = prefix;
        this.matchingRegex = null;
    }

    public TokenText() {
    }

    @Override
    public Instance pipe(Instance carrier) {
        TokenSequence ts = (TokenSequence)carrier.getData();
        int i = 0;
        while (i < ts.size()) {
            Token t = (Token)ts.get(i);
            if (this.matchingRegex == null || this.matchingRegex.matcher(t.getText()).matches()) {
                t.setFeatureValue(this.prefix == null ? t.getText() : String.valueOf(this.prefix) + t.getText(), 1.0);
            }
            ++i;
        }
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.prefix);
        out.writeObject(this.matchingRegex);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version2 = in.readInt();
        this.prefix = (String)in.readObject();
        if (version2 > 0) {
            this.matchingRegex = (Pattern)in.readObject();
        }
    }
}

