/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tsf;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import cc.mallet.util.PropertyList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.regex.Pattern;

public class OffsetConjunctions
extends Pipe
implements Serializable {
    int[][] conjunctions;
    boolean includeOriginalSingletons;
    Pattern featureRegex;
    static final int maxWindowSize = 50;
    static final PropertyList[] startfs = new PropertyList[50];
    static final PropertyList[] endfs = new PropertyList[50];
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;
    private static final int NULL_INTEGER = -1;

    static {
        OffsetConjunctions.initStartEndFs();
    }

    private static void initStartEndFs() {
        int i = 0;
        while (i < 50) {
            OffsetConjunctions.startfs[i] = PropertyList.add("<START" + i + ">", 1.0, null);
            OffsetConjunctions.endfs[i] = PropertyList.add("<END" + i + ">", 1.0, null);
            ++i;
        }
    }

    public OffsetConjunctions(boolean includeOriginalSingletons, Pattern featureRegex, int[][] conjunctions) {
        this.conjunctions = conjunctions;
        this.featureRegex = featureRegex;
        this.includeOriginalSingletons = includeOriginalSingletons;
    }

    public OffsetConjunctions(boolean includeOriginalSingletons, int[][] conjunctions) {
        this(includeOriginalSingletons, null, conjunctions);
    }

    public OffsetConjunctions(int[][] conjunctions) {
        this(true, conjunctions);
    }

    @Override
    public Instance pipe(Instance carrier) {
        TokenSequence ts = (TokenSequence)carrier.getData();
        int tsSize = ts.size();
        PropertyList[] oldfs = null;
        PropertyList[] newfs = null;
        try {
            oldfs = new PropertyList[ts.size()];
        }
        catch (Exception e) {
            System.err.println("Exception allocating oldfs: " + e);
        }
        try {
            newfs = new PropertyList[ts.size()];
        }
        catch (Exception e) {
            System.err.println("Exception allocating newfs: " + e);
        }
        int i = 0;
        while (i < tsSize) {
            oldfs[i] = ((Token)ts.get(i)).getFeatures();
            ++i;
        }
        if (this.includeOriginalSingletons) {
            i = 0;
            while (i < tsSize) {
                newfs[i] = ((Token)ts.get(i)).getFeatures();
                ++i;
            }
        }
        i = 0;
        while (i < tsSize) {
            int j = 0;
            while (j < this.conjunctions.length) {
                PropertyList.Iterator[] iters = this.getOffsetIters(this.conjunctions, j, tsSize, i, oldfs);
                if (iters != null) {
                    int[] iterIndices = new int[iters.length];
                    int ii = 0;
                    while (ii < iterIndices.length) {
                        iterIndices[ii] = -1;
                        ++ii;
                    }
                    newfs[i] = this.makeConjunctions(iters, 0, this.conjunctions, j, tsSize, newfs[i], i, oldfs, iterIndices);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < ts.size()) {
            ((Token)ts.get(i)).setFeatures(newfs[i]);
            ++i;
        }
        return carrier;
    }

    /*
     * Unable to fully structure code
     */
    private PropertyList makeConjunctions(PropertyList.Iterator[] iters, int currIndex, int[][] conjunctions, int j, int tsSize, PropertyList newfs, int tsi, PropertyList[] oldfs, int[] iterIndices) {
        block4: {
            if (iters.length != currIndex) ** GOTO lbl22
            if (this.redundant(conjunctions, j, iterIndices)) {
                return newfs;
            }
            newFeature = "";
            newValue = 1.0;
            i = 0;
            while (i < iters.length) {
                s = iters[i].getKey();
                if (this.featureRegex != null && !this.featureRegex.matcher(s).matches()) {
                    return newfs;
                }
                newFeature = String.valueOf(newFeature) + (i == 0 ? "" : "_&_") + s + (conjunctions[j][i] == 0 ? "" : "@" + conjunctions[j][i]);
                newValue *= iters[i].getNumericValue();
                ++i;
            }
            newfs = PropertyList.add(newFeature, newValue, newfs);
            break block4;
lbl-1000:
            // 1 sources

            {
                iters[currIndex].next();
                v0 = currIndex;
                iterIndices[v0] = iterIndices[v0] + 1;
                newfs = this.makeConjunctions(iters, currIndex + 1, conjunctions, j, tsSize, newfs, tsi, oldfs, iterIndices);
lbl22:
                // 2 sources

                ** while (iters[currIndex].hasNext())
            }
lbl23:
            // 1 sources

            iters[currIndex] = this.getOffsetIter(conjunctions, j, currIndex, tsSize, tsi, oldfs);
            iterIndices[currIndex] = -1;
        }
        return newfs;
    }

    private boolean redundant(int[][] conjunctions, int j, int[] iterIndices) {
        int i = 1;
        while (i < iterIndices.length) {
            if (conjunctions[j][i - 1] == conjunctions[j][i] && iterIndices[i] <= iterIndices[i - 1]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private PropertyList.Iterator[] getOffsetIters(int[][] conjunctions, int j, int tsSize, int tsi, PropertyList[] oldfs) {
        PropertyList.Iterator[] iters = new PropertyList.Iterator[conjunctions[j].length];
        int iteri = 0;
        while (iteri < iters.length) {
            iters[iteri] = this.getOffsetIter(conjunctions, j, iteri, tsSize, tsi, oldfs);
            if (iters[iteri] == null) {
                return null;
            }
            ++iteri;
        }
        return iters;
    }

    private PropertyList.Iterator getOffsetIter(int[][] conjunctions, int j, int iteri, int tsSize, int tsi, PropertyList[] oldfs) {
        Object iter = tsi + conjunctions[j][iteri] < 0 ? startfs[-(tsi + conjunctions[j][iteri]) - 1].iterator() : (conjunctions[j][iteri] + tsi > tsSize - 1 ? endfs[tsi + conjunctions[j][iteri] - tsSize].iterator() : (oldfs[conjunctions[j][iteri] + tsi] == null ? null : oldfs[tsi + conjunctions[j][iteri]].iterator()));
        return iter;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        int size1 = this.conjunctions == null ? -1 : this.conjunctions.length;
        out.writeInt(size1);
        if (size1 != -1) {
            int i = 0;
            while (i < size1) {
                int size2 = this.conjunctions[i] == null ? -1 : this.conjunctions[i].length;
                out.writeInt(size2);
                if (size2 != -1) {
                    int j = 0;
                    while (j < size2) {
                        out.writeInt(this.conjunctions[i][j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
        out.writeBoolean(this.includeOriginalSingletons);
        out.writeObject(this.featureRegex);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version2 = in.readInt();
        int size1 = in.readInt();
        if (startfs[0] == null) {
            OffsetConjunctions.initStartEndFs();
        }
        if (size1 == -1) {
            this.conjunctions = null;
        } else {
            this.conjunctions = new int[size1][];
            int i = 0;
            while (i < size1) {
                int size2 = in.readInt();
                if (size2 == -1) {
                    this.conjunctions[i] = null;
                } else {
                    this.conjunctions[i] = new int[size2];
                    int j = 0;
                    while (j < size2) {
                        this.conjunctions[i][j] = in.readInt();
                        ++j;
                    }
                }
                ++i;
            }
        }
        this.includeOriginalSingletons = in.readBoolean();
        this.featureRegex = (Pattern)in.readObject();
    }
}

