/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tsf;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CountMatchesAlignedWithOffsets
extends Pipe {
    Pattern regex;
    String feature;
    int[] offsets;
    boolean normalizeByMatchCount = false;

    public CountMatchesAlignedWithOffsets(String featureName, Pattern regex, int[] offsets, boolean normalizeByMatchCount) {
        this.feature = featureName;
        this.regex = regex;
        this.offsets = offsets;
        this.normalizeByMatchCount = normalizeByMatchCount;
    }

    public CountMatchesAlignedWithOffsets(String featureName, Pattern regex, int[] offsets) {
        this(featureName, regex, offsets, false);
    }

    @Override
    public Instance pipe(Instance carrier) {
        TokenSequence ts = (TokenSequence)carrier.getData();
        int i = 0;
        while (i < ts.size()) {
            int countMatches = 0;
            int countAlignedMatches = 0;
            Token t = (Token)ts.get(i);
            Matcher matcher = this.regex.matcher(t.getText());
            while (matcher.find()) {
                ++countMatches;
                int position = matcher.start();
                int j = 0;
                while (j < this.offsets.length) {
                    Matcher offsetMatcher;
                    String offsetText;
                    int offset = i + this.offsets[j];
                    if (offset >= 0 && offset < ts.size() && (offsetText = ((Token)ts.get(offset)).getText()).length() > position && (offsetMatcher = this.regex.matcher(offsetText.substring(position))).lookingAt()) {
                        ++countAlignedMatches;
                    }
                    ++j;
                }
            }
            if (countAlignedMatches > 0) {
                t.setFeatureValue(this.feature, this.normalizeByMatchCount ? (double)countAlignedMatches / (double)countMatches : (double)countAlignedMatches);
            }
            ++i;
        }
        return carrier;
    }
}

