/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class TokenSequenceRemoveStopPatterns
extends Pipe
implements Serializable {
    ArrayList<Pattern> stopPatterns = new ArrayList();
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public TokenSequenceRemoveStopPatterns() {
    }

    public TokenSequenceRemoveStopPatterns(File patternFile) {
        this.addPatterns(patternFile);
    }

    public TokenSequenceRemoveStopPatterns(String[] patterns) {
        this.addPatterns(patterns);
    }

    public TokenSequenceRemoveStopPatterns addPatterns(String[] patterns) {
        String[] stringArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            this.stopPatterns.add(Pattern.compile(pattern));
            ++n2;
        }
        return this;
    }

    public TokenSequenceRemoveStopPatterns addPatterns(File patternFile) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(patternFile));
            String line = null;
            while ((line = in.readLine()) != null) {
                this.stopPatterns.add(Pattern.compile(line));
            }
        }
        catch (IOException e) {
            System.err.println("Problem reading stop pattern file: " + e.getMessage());
        }
        catch (PatternSyntaxException e) {
            System.err.println("Problem compiling regular expression: " + e.getMessage());
        }
        return this;
    }

    @Override
    public Instance pipe(Instance carrier) {
        TokenSequence originalSequence = (TokenSequence)carrier.getData();
        TokenSequence newSequence = new TokenSequence();
        int i = 0;
        while (i < originalSequence.size()) {
            Token t = (Token)originalSequence.get(i);
            boolean passed = true;
            String text = t.getText();
            for (Pattern pattern : this.stopPatterns) {
                Matcher matcher = pattern.matcher(text);
                if (!matcher.matches()) continue;
                passed = false;
                break;
            }
            if (passed) {
                newSequence.add(t);
            }
            ++i;
        }
        carrier.setData(newSequence);
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.stopPatterns);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version2 = in.readInt();
        this.stopPatterns = (ArrayList)in.readObject();
    }
}

